/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.action.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.license.common.LicenseUtils;
import ru.bitel.bgbilling.modules.license.common.bean.ConfirmedOrder;
import ru.bitel.bgbilling.modules.license.common.bean.Copy;
import ru.bitel.bgbilling.modules.license.common.bean.Order;
import ru.bitel.bgbilling.modules.license.common.bean.OrderBillData;
import ru.bitel.bgbilling.modules.license.server.action.web.ActionOrders;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionGetBills
extends ActionOrders {
    @Override
    public void doAction() throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.con, this.moduleId);
        int billsCount = 0;
        BigDecimal totalPaySum = BigDecimal.ZERO;
        int ordersCount = this.req.getInt("ordersCount", -1);
        ArrayList<Integer> processedIds = new ArrayList<Integer>();
        this.context.getRequest().setAttribute("bills", processedIds);
        int selectedCopyId = this.req.getInt("copyId", -1);
        for (int i = 1; i <= ordersCount; ++i) {
            Order order;
            int selectedOrderId = this.req.getInt("chbx_" + i, -1);
            if (selectedOrderId <= 0 || (order = licenseManager.getOrder(selectedOrderId)) == null) continue;
            Copy copy = licenseManager.getCopy(order.getCopyId());
            String productVersion = copy.getProductVersion();
            int productItemId = order.getComponentId();
            if (processedIds.contains(productItemId)) continue;
            processedIds.add(productItemId);
            ConfirmedOrder grouppedConfirmedItem = licenseManager.groupCopyItems(productItemId, selectedCopyId, new int[]{2, 3});
            ConfirmedOrder grouppedNewItem = licenseManager.groupCopyItems(productItemId, selectedCopyId, new int[]{0});
            if (grouppedConfirmedItem == null && grouppedNewItem == null) continue;
            String productItemName = new String();
            Integer confirmedItemsCount = null;
            if (grouppedConfirmedItem != null) {
                confirmedItemsCount = grouppedConfirmedItem.getCount();
                productItemName = grouppedConfirmedItem.getComponentName();
            }
            Integer newItemsCount = null;
            if (grouppedNewItem != null) {
                newItemsCount = grouppedNewItem.getCount();
                productItemName = grouppedNewItem.getComponentName();
            }
            OrderBillData addCostItem = LicenseUtils.getCostDelta((String)productItemName, (Integer)confirmedItemsCount, (Integer)newItemsCount, (String)productVersion, (Preferences)this.moduleSetup);
            totalPaySum = totalPaySum.add(addCostItem.getCostDelta());
            ++billsCount;
        }
        this.context.getRequest().setAttribute("billsCount", (Object)String.valueOf(billsCount));
        this.context.getRequest().setAttribute("totalPaySum", (Object)Utils.formatCost((BigDecimal)totalPaySum));
    }
}

