/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractTryAndBuy;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class MegogoContractTryAndBuyDao
extends AbstractIdDao<MegogoContractTryAndBuy> {
    public MegogoContractTryAndBuyDao(Connection con, int moduleId) {
        super(con, moduleId, "megogo_contract_try_and_buy");
    }

    public MegogoContractTryAndBuy getContractTBByIdSub(int idSub) throws BGException {
        return (MegogoContractTryAndBuy)this.get("idSub=?", new Object[]{idSub});
    }

    public List<MegogoContractTryAndBuy> getContractTBList(int contractId, Period period, int idTB) throws BGException {
        ArrayList<MegogoContractTryAndBuy> arrayList;
        block13: {
            String query = "SELECT mctab.*, mtab.title FROM " + this.tableName + " AS mctab LEFT JOIN megogo_try_and_buy_" + this.moduleId + " AS mtab ON mctab.idTB=mtab.id WHERE 1=1";
            if (contractId > 0) {
                query = query + " AND contractId=" + contractId;
            }
            if (idTB > 0) {
                query = query + " AND idTB=" + idTB;
            }
            if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
                query = query + " AND dateFrom<=? AND dateTo>=?";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                if (period != null && period.getDateFrom() != null && period.getDateTo() != null) {
                    ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
                    ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
                }
                ResultSet rs = ps.executeQuery();
                ArrayList<MegogoContractTryAndBuy> list = new ArrayList<MegogoContractTryAndBuy>();
                while (rs.next()) {
                    MegogoContractTryAndBuy contractTryAndBuy = this.getFromRS(rs);
                    contractTryAndBuy.setTitle(rs.getString("mtab.title"));
                    list.add(contractTryAndBuy);
                }
                arrayList = list;
                if (ps == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return arrayList;
    }

    protected MegogoContractTryAndBuy getFromRS(ResultSet rs) throws SQLException, BGException {
        MegogoContractTryAndBuy contractTryAndBuy = new MegogoContractTryAndBuy();
        contractTryAndBuy.setContractId(rs.getInt("contractId"));
        contractTryAndBuy.setId(rs.getInt("id"));
        contractTryAndBuy.setIdTB(rs.getInt("idTB"));
        contractTryAndBuy.setIdSub(rs.getInt("idSub"));
        contractTryAndBuy.setPeriod(new Period((Date)rs.getDate("dateFrom"), (Date)rs.getDate("dateTo")));
        contractTryAndBuy.setUserId(rs.getInt("userId"));
        return contractTryAndBuy;
    }

    protected void updateImpl(MegogoContractTryAndBuy contractTB) throws BGException, SQLException {
        if (contractTB != null && contractTB.getPeriod() != null) {
            PreparedStatement ps = null;
            if (contractTB.getId() < 1) {
                String query = "INSERT INTO " + this.tableName + " SET contractId=?, idTB=?, idSub=?, dateFrom=?, dateTo=?, userId=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                String query = "UPDATE " + this.tableName + " SET contractId=?, idTB=?, idSub=?, dateFrom=?, dateTo=?, userId=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(7, contractTB.getId());
            }
            ps.setInt(1, contractTB.getContractId());
            ps.setInt(2, contractTB.getIdTB());
            ps.setInt(3, contractTB.getIdSub());
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)contractTB.getPeriod().getDateFrom()));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)contractTB.getPeriod().getDateTo()));
            ps.setInt(6, contractTB.getUserId());
            ps.executeUpdate();
            if (contractTB.getId() < 1) {
                contractTB.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        } else {
            throw new BGIllegalArgumentException();
        }
    }
}

