/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.message4user.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.message4user.common.bean.Message;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.IdTitle;

public class MessageForUsersDao
extends AbstractDao<Message> {
    public MessageForUsersDao(Connection con) {
        super(con, 0, "message_for_users");
    }

    protected Message getFromRS(ResultSet rs) throws SQLException, BGException {
        Message message = new Message();
        message.setId(rs.getInt("id"));
        message.setDateFrom((Date)rs.getTimestamp("date_from"));
        message.setDateTo((Date)rs.getTimestamp("date_to"));
        message.setText(rs.getString("text"));
        message.setGroups(Utils.toIntegerSet((String)rs.getString("gr")));
        message.setUsers(Utils.toIntegerSet((String)rs.getString("users")));
        message.setMessageTitle(rs.getString("title"));
        message.setTitle(message.getId() + " [" + TimeUtils.format((Date)message.getDateFrom(), (String)"dd.MM.yyyy HH:mm") + " - " + TimeUtils.format((Date)message.getDateTo(), (String)"dd.MM.yyyy HH:mm") + " ] " + message.getMessageTitle());
        return message;
    }

    protected void updateImpl(Message b) throws BGException, SQLException {
        StringBuilder query = new StringBuilder();
        PreparedStatement ps = null;
        if (b.getId() > 0) {
            query.append("UPDATE ");
            query.append(this.tableName);
            query.append(" SET date_to=?, date_from=?, text=?, gr=?, title=?, users=? WHERE id=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(7, b.getId());
        } else {
            query.append("INSERT ");
            query.append(this.tableName);
            query.append("(date_to, date_from, text, gr, title, users) VALUES(?, ?, ?, ?, ?, ?)");
            ps = this.con.prepareStatement(query.toString());
        }
        ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)b.getDateTo()));
        ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)b.getDateFrom()));
        ps.setString(3, b.getText());
        ps.setString(4, Utils.toString((Iterable)b.getGroups(), (String)","));
        ps.setString(5, b.getMessageTitle());
        ps.setString(6, Utils.toString((Iterable)b.getUsers()));
        ps.executeUpdate();
        if (b.getId() < 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public List<Message> getMessageList() throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        try {
            String query = "SELECT * FROM message_for_users";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            messageList = this.getListFromRS(rs);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<Message> getMessageList(int lastMessagId, int userId) throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        String query = "SELECT * FROM message_for_users WHERE id>? AND now() BETWEEN date_from AND date_to";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, lastMessagId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next() && Utils.toIntegerList((String)rs.getString("users")).contains(userId)) {
                    messageList = this.getListFromRS(rs);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return messageList;
    }

    @Deprecated
    public List<Message> getMessageList(int lastMessagId, String userId) throws BGException {
        List<Object> messageList = new ArrayList<Message>();
        try {
            String query = "SELECT * FROM message_for_users WHERE id>? AND users LIKE '" + userId + "' AND now() BETWEEN date_from AND date_to";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, lastMessagId);
            ResultSet rs = ps.executeQuery();
            messageList = this.getListFromRS(rs);
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<IdTitle> getGroupList() {
        ArrayList<IdTitle> groupList = new ArrayList<IdTitle>();
        try {
            String query = "SELECT * FROM bgs_group ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                IdTitle idTitle = new IdTitle();
                idTitle.setId(rs.getInt("id"));
                idTitle.setTitle(rs.getString("title"));
                groupList.add(idTitle);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return groupList;
    }

    public void deleteMessage(int messageId) {
        try {
            String query = "DELETE FROM " + this.tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, messageId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Set<Integer> getUsersInGroup(Set<Integer> groups) {
        HashSet<Integer> userIds = new HashSet<Integer>();
        if (!groups.isEmpty()) {
            try {
                String query = "SELECT * FROM bgs_user_group WHERE gid IN (" + Utils.toString(groups) + ") group by uid";
                PreparedStatement ps = this.con.prepareStatement(query);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    userIds.add(rs.getInt("uid"));
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return userIds;
    }
}

