/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.news.server.service;

import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.plugins.news.common.bean.News;
import ru.bitel.bgbilling.plugins.news.common.service.NewsService;
import ru.bitel.bgbilling.plugins.news.server.bean.NewsManager;
import ru.bitel.bgbilling.plugins.news.server.event.NewsModifiedEvent;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.news.common.service.NewsService")
public class NewsServiceImpl
extends AbstractService
implements NewsService {
    public News newsGet(int id) throws BGException {
        try (NewsManager newsManager = new NewsManager(this.getConnection());){
            News news = (News)newsManager.get(id);
            return news;
        }
    }

    public int newsUpdate(News news) throws BGException {
        try (NewsManager newsManager = new NewsManager(this.getConnection());){
            newsManager.update(news);
        }
        this.context.publishAfterCommit((Event)new NewsModifiedEvent(this.userId, 0));
        return news.getId();
    }

    public List<News> newsList(Page page) throws BGException {
        try (NewsManager newsManager = new NewsManager(this.getConnection());){
            List<News> list = newsManager.list(page);
            return list;
        }
    }

    public List<News> newsListForContract(List<Integer> labelIds, Page page) throws BGException {
        return NewsManager.getNewsList(this.context.getSetup(), page, labelIds);
    }

    public void newsDelete(int id) throws BGException {
        try (NewsManager newsManager = new NewsManager(this.getConnection());){
            newsManager.delete(id);
        }
        this.context.publishAfterCommit((Event)new NewsModifiedEvent(this.userId, 0));
    }

    public SearchResult<News> newsSearch(Page page) throws BGException, BGMessageException {
        try (NewsManager newsManager = new NewsManager(this.getConnection());){
            SearchResult searchResult = new SearchResult();
            searchResult.setPage(page);
            newsManager.search((SearchResult<News>)searchResult);
            SearchResult searchResult2 = searchResult;
            return searchResult2;
        }
    }
}

