/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.account;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class VoipModuleAccount
extends ModuleAccount {
    private static Logger log = LogManager.getLogger();

    @Override
    public BigDecimal getPeriodAccount(Connection con, int contractId, Calendar from, Calendar to) {
        BigDecimal result = BigDecimal.ZERO;
        String tableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)from.getTime(), (int)this.getModleId());
        if (ServerUtils.tableExists((Connection)con, (String)tableName)) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT SUM(session_cost) FROM ");
            query.append(tableName);
            query.append(" WHERE cid=? AND DATE(session_start)>=? AND DATE(session_start)<=?");
            try (PreparedStatement ps = con.prepareStatement(query.toString());){
                from = (Calendar)from.clone();
                to = (Calendar)to.clone();
                ps.setInt(1, contractId);
                ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)from));
                ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)to));
                try (ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        result = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
        return result;
    }
}

