/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.bean.sets;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSet;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ServiceSetManager {
    private static final Pattern pattern = Pattern.compile("\\s*\\-\\s*\\{\\s*([\\d\\,\\s]+)\\s*\\}\\s*");
    private Map<Integer, ServiceSet> serviceSetMap = new HashMap<Integer, ServiceSet>();
    private List<ServiceSet> serviceSetList = new ArrayList<ServiceSet>();

    public ServiceSetManager(Connection con, int mid, Preferences setup) {
        String allSidList = ModuleCache.getInstance().getModuleServicesString(mid);
        ServiceSet fullSet = new ServiceSet();
        fullSet.setId(0);
        fullSet.setSidList(allSidList);
        fullSet.setTitle("\u041f\u043e\u043b\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0443\u0441\u043b\u0443\u0433");
        this.serviceSetList.add(fullSet);
        this.serviceSetMap.put(fullSet.getId(), fullSet);
        List data = setup.parseObjects("service.set.");
        for (Map entry : data) {
            ServiceSet set = new ServiceSet();
            set.setId(Utils.parseInt((String)((String)entry.get("id"))));
            set.setSidList((String)entry.get("sids"));
            set.setTitle((String)entry.get("title"));
            if (set.getId() < 0 || !Utils.notBlankString((String)set.getSidList()) || !Utils.notBlankString((String)set.getTitle())) continue;
            this.serviceSetList.add(set);
            this.serviceSetMap.put(set.getId(), set);
        }
        for (ServiceSet set : this.serviceSetList) {
            Matcher m = pattern.matcher(set.getSidList());
            if (!m.matches()) continue;
            HashSet services = new HashSet();
            Iterator iterator = Utils.toIntegerList((String)m.group(1)).iterator();
            while (iterator.hasNext()) {
                int serviceSet = (Integer)iterator.next();
                ServiceSet excludeSet = this.serviceSetMap.get(serviceSet);
                if (excludeSet == null) continue;
                services.addAll(Utils.toIntegerSet((String)excludeSet.getSidList()));
            }
            HashSet fullServiceSet = new HashSet();
            fullServiceSet.addAll(Utils.toIntegerSet((String)fullSet.getSidList()));
            fullServiceSet.removeAll(services);
            set.setSidList(Utils.toString(fullServiceSet));
            if (fullServiceSet.size() != 0) continue;
            set.setSidList("0");
        }
    }

    public Map<Integer, ServiceSet> getServiceSetMap() {
        return this.serviceSetMap;
    }

    public List<ServiceSet> getServiceSetList() {
        return this.serviceSetList;
    }
}

