/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.tariff;

import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;

public class YearAddModeCostTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    private final int account;
    private final BigDecimal cost;

    public YearAddModeCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.account = parameterMap.getInt("account", 0);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
    }

    protected int executeImpl(Long treeNodeId, NPayTariffRequest req, NPayTariffContext context) {
        BigDecimal cost;
        ModuleAccount moduleAccount = context.getModuleAccount(this.account);
        if (moduleAccount == null) {
            req.addError("Not found account " + this.account);
            return 0;
        }
        BigDecimal accountValue = context.getModuleAccount(this.account).getPeriodAccount(req.getConnection(), req.contractId, ((NPayServiceCost)req.serviceCost).date1, ((NPayServiceCost)req.serviceCost).date2);
        ((NPayServiceCost)req.serviceCost).addCost = cost = this.cost;
        ((NPayServiceCost)req.serviceCost).cost = accountValue.compareTo(cost) < 0 ? cost.subtract(accountValue) : BigDecimal.ZERO;
        return 1;
    }
}

