/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.payture.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.payture.common.bean.Transaction;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractDao<Transaction> {
    public TransactionManager(Connection con, int mid) {
        super(con, mid, "payture_payment");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.payment_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.payment_date<=?");
                }
            }
            if (Utils.notBlankString((String)status)) {
                query.append(" AND pt.status=?");
            }
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND c.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND c.id=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT pt.*, c.title " + query.toString() + (page != null ? page.sqlLimit() : ""));
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.payment_summ), COUNT(*) " + query.toString());
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (Utils.notBlankString((String)status)) {
                    ps.setString(index++, status);
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(index++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal summa;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((summa = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(summa);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected void updateImpl(Transaction paytureTransaction) throws BGException, SQLException {
        String querySet = " SET contract_id=?, status=?, payment_date=?, payment_summ=?";
        String query = paytureTransaction.getId() > 0 ? "UPDATE " + this.tableName + querySet + " WHERE id=?" : "INSERT INTO " + this.tableName + querySet;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, paytureTransaction.getContractId());
            ps.setString(index++, paytureTransaction.getStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)paytureTransaction.getTransactionDate()));
            ps.setBigDecimal(index++, paytureTransaction.getSum());
            if (paytureTransaction.getId() > 0) {
                ps.setLong(index++, paytureTransaction.getId());
            }
            ps.executeUpdate();
            if (paytureTransaction.getId() <= 0) {
                paytureTransaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public Transaction get(int id) throws BGException {
        Transaction result = null;
        String query = "SELECT pt.*, c.title FROM " + this.tableName + " AS pt  LEFT JOIN contract c ON c.id=pt.contract_id WHERE pt.id=" + id;
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction result = new Transaction();
        result.setId(rs.getInt("pt.id"));
        result.setContractId(rs.getInt("pt.contract_id"));
        result.setContractTitle(rs.getString("c.title"));
        result.setTransactionDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pt.payment_date")));
        result.setSum(rs.getBigDecimal("pt.payment_summ"));
        result.setStatus(rs.getString("pt.status"));
        return result;
    }
}

