/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.task;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.phone.server.bean.BalanceSetRoundCorrector;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class BalanceSetter
extends TaskBase {
    private Calendar startMonth;
    private String sessionTableName;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Phone. \u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.startMonth = (Calendar)this.getOperatingTime().clone();
            this.startMonth.add(11, -1);
            this.startMonth.set(5, 1);
            this.startMonth.set(11, 0);
            if (this.moduleId > 0) {
                this.sessionTableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)this.startMonth.getTime(), (int)this.moduleId);
                this.log.debug("Processing table: " + this.sessionTableName);
                if (!ServerUtils.tableExists((Connection)con, (String)this.sessionTableName)) {
                    this.log.error("No session table");
                    return;
                }
            } else {
                this.log.error("Param mid NOT Found in task config");
                return;
            }
            String sids = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
            String query = "SELECT cid, sid, SUM(cost) FROM " + this.sessionTableName + " GROUP BY cid, sid";
            PreparedStatement ps = con.prepareStatement(query);
            ServiceCostCache costCache = new ServiceCostCache();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CostSum sum = new CostSum(rs.getInt(1), rs.getInt(2), rs.getBigDecimal(3));
                costCache.addAmount(sum);
            }
            rs.close();
            ps.close();
            new BalanceSetRoundCorrector(con, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)), this.sessionTableName).correctAccounts(costCache);
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.moduleId));
            SortedMap operators = moduleSetup.subIndexed("operator.");
            for (Map.Entry e : operators.entrySet()) {
                if (!Utils.notBlankString((String)((ParameterMap)e.getValue()).get("oper_sid", null))) continue;
                int cid = ((ParameterMap)e.getValue()).getInt("cid", -1);
                if (cid == -1) {
                    cid = (Integer)e.getKey();
                }
                ps = conSlave.prepareStatement("SELECT SUM(oper_cost) FROM " + this.sessionTableName + " WHERE sid IN (" + ((ParameterMap)e.getValue()).get("oper_sid", "-1") + ")");
                rs = ps.executeQuery();
                while (rs.next()) {
                    CostSum sum = new CostSum(cid, ((ParameterMap)e.getValue()).getInt("sid", 0), rs.getBigDecimal(1));
                    costCache.addAmount(sum);
                }
                rs.close();
                ps.close();
            }
            for (Map.Entry operator : operators.entrySet()) {
                int operatorCid = ((ParameterMap)operator.getValue()).getInt("cid", -1);
                if (operatorCid <= 0) continue;
                SortedMap accounts = ((ParameterMap)operator.getValue()).subIndexed("account.");
                for (Map.Entry e : accounts.entrySet()) {
                    String operatorSids = ((ParameterMap)e.getValue()).get("", "all");
                    ps = operatorSids.trim().equals("all") ? conSlave.prepareStatement("SELECT SUM(oper_cost) FROM " + this.sessionTableName + " WHERE oper_id=?") : conSlave.prepareStatement("SELECT SUM(oper_cost) FROM " + this.sessionTableName + " WHERE oper_id=? AND sid IN (" + operatorSids + ")");
                    ps.setInt(1, (Integer)operator.getKey());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        BigDecimal decSum = rs.getBigDecimal(1);
                        if (decSum == null) continue;
                        costCache.addAmount(new CostSum(operatorCid, ((Integer)e.getKey()).intValue(), decSum));
                    }
                    rs.close();
                    ps.close();
                }
            }
            try (BalanceUtils balanceUtils = new BalanceUtils(con);){
                balanceUtils.setAccount(con, this.log, this.startMonth, costCache, sids, null, null);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }
}

