/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.qiwi.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Constants;
import ru.bitel.bgbilling.modules.qiwi.common.bean.Transaction;
import ru.bitel.bgbilling.modules.qiwi.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.qiwi.common.service.QiwiService;
import ru.bitel.bgbilling.modules.qiwi.server.bean.TransactionManager;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Qiwi")
public class ActionDoTransaction
extends AbstractAction {
    private final String moduleName = "qiwi";
    @Resource
    private QiwiService qiwiService;

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.setResultParam("gateUrl", this.moduleSetup.get("qiwi.gate.url", "https://bill.qiwi.com/order/external/main.action"));
        this.paymentForm("qiwi", Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws BGException {
        String phone = this.req.get("customerAddress", null);
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("phone", phone);
        Holder params = new Holder((Object)new MapHolder(map));
        Holder urlHolder = new Holder();
        try {
            this.qiwiService.beginTransaction(this.contractId, sum, urlHolder, null, params);
            this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
            this.context.getResponse().sendRedirect(URLDecoder.decode((String)urlHolder.value, "UTF-8"));
        }
        catch (Exception ex) {
            this.execute();
            throw new BGMessageException(ex.getMessage());
        }
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }
}

