/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Payment
extends BGJasperReport {
    public Report_Payment() {
        this.id = "kernel_contract_payment";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try (UserManager userManager = new UserManager(this.con);){
            Map usersMap = userManager.getUsersMap();
            java.sql.Date date1 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)this.getStringParam("date1"), (String)"dd.MM.yyyy"));
            java.sql.Date date2 = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)this.getStringParam("date2"), (String)"dd.MM.yyyy"));
            String types = this.getStringParam("pt");
            String groups = this.getStringParam("gr");
            String mask = this.getStringParam("mask");
            String groupMode = this.getStringParam("group_mode");
            String users = this.getStringParam("users");
            String sort1 = this.getStringParam("sort1");
            String sort2 = this.getStringParam("sort2");
            String sort3 = this.getStringParam("sort3");
            int fc = Integer.valueOf(this.getStringParam("fc"));
            StringBuilder order = new StringBuilder();
            this.addOrder(order, sort1);
            this.addOrder(order, sort2);
            this.addOrder(order, sort3);
            if (date1 != null && date2 != null && types != null && groups != null) {
                long groupMask = Utils.enumToMask((String)groups);
                Object query = "SELECT t1.title AS c1, t1.comment AS c2,  t2.summa AS c3, t2.dt AS c4, t3.title AS c5, t2.comment AS c6, t2.uid AS c7 FROM  contract AS t1, contract_payment AS t2, contract_payment_types AS t3  WHERE t1.id=t2.cid AND t3.id = t2.pt AND ( t2.dt >= ? OR ISNULL( ? ) ) AND ( t2.dt <= ? OR ISNULL( ? ) ) ";
                if (groupMask != 0L && Utils.notEmptyString((String)groupMode)) {
                    query = groupMode.equals("or") ? (String)query + " AND t1.gr & " + groupMask + " > 0 " : (String)query + " AND t1.gr & " + groupMask + "=" + groupMask + " ";
                }
                if (Utils.notEmptyString((String)types)) {
                    query = (String)query + "AND t2.pt IN ( " + types + " ) ";
                }
                if (Utils.notEmptyString((String)users)) {
                    query = (String)query + "AND t2.uid IN ( " + users + " ) ";
                }
                if (Utils.notEmptyString((String)mask)) {
                    query = (String)query + "AND t1.title REGEXP '" + mask + "' ";
                }
                if (fc > -1) {
                    query = (String)query + "AND t1.fc=" + fc + " ";
                }
                if (order.length() > 0) {
                    query = (String)query + order.toString();
                }
                PreparedStatement ps = this.con.prepareStatement((String)query);
                ps.setDate(1, date1);
                ps.setDate(2, date1);
                ps.setDate(3, date2);
                ps.setDate(4, date2);
                ResultSet rs = ps.executeQuery();
                BGDataSource data = new BGDataSource();
                BigDecimal sum = BigDecimal.ZERO;
                while (rs.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    String summa = rs.getString(3);
                    User user = (User)usersMap.get(rs.getInt(7));
                    row.put("col1", rs.getString(1));
                    row.put("col2", rs.getString(2));
                    row.put("col3", summa);
                    row.put("col4", TimeUtils.format((Date)rs.getDate(4), (String)"dd.MM.yyyy"));
                    row.put("col5", rs.getString(5));
                    row.put("col6", rs.getString(6));
                    row.put("col7", user != null ? user.getName() : "???");
                    data.addRow(row);
                    sum = sum.add(new BigDecimal(summa));
                }
                rs.close();
                ps.close();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("sum", sum.toPlainString());
                this.fillReportToStream(this.id, out, params, (JRDataSource)data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void addOrder(StringBuilder order, String sort) {
        if (Utils.notBlankString((String)sort)) {
            if (order.length() == 0) {
                order.append(" ORDER BY ");
                order.append(sort);
            } else {
                order.append(",");
                order.append(sort);
            }
        }
    }
}

