/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.dialup;

import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Shturman_1
extends BGJasperReport {
    public Report_Shturman_1() {
        this.id = "dialup_shturman_1";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        try {
            int mid = Utils.parseInt((String)this.getStringParam("mid"), (int)-1);
            String services = this.getStringParam("services");
            long groups = Utils.parseLong((String)this.getStringParam("gr"), (long)0L);
            Calendar date = TimeUtils.parseCalendar((String)this.getStringParam("date"), (String)"dd.MM.yyyy");
            int yy = date.get(1);
            int mm = date.get(2);
            HashMap<String, CallSite> params = new HashMap<String, CallSite>();
            params.put("addInfo", (CallSite)((Object)(" \u0433\u043e\u0434: " + date.get(1) + " \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.monthNames[date.get(2)])));
            DecimalFormat df = new DecimalFormat("### ### ### ### ##0.00");
            BGDataSource bds = new BGDataSource();
            String sessionDetailTable = ServerUtils.getModuleMonthTableName((String)"session_detail", (Date)date.getTime(), (int)mid);
            if (ServerUtils.tableExists((Connection)this.con, (String)sessionDetailTable)) {
                String addServices;
                HashMap<Integer, Entry<String>> unitMap = new HashMap<Integer, Entry<String>>();
                unitMap.put(0, new Entry<String>(1, ""));
                for (String _param : this.moduleSetup.get("reports.shturman_1.sids", "").split(";")) {
                    String[] param = _param.split(":", 3);
                    if (param.length <= 1) continue;
                    int sid = Utils.parseInt((String)param[0], (int)-1);
                    String name = param.length > 2 ? param[2] : "";
                    unitMap.put(sid, new Entry<String>(Utils.parseInt((String)param[1], (int)1), name));
                }
                Object contractGroupFilter = "";
                if (groups != 0L) {
                    contractGroupFilter = " AND (contract.gr&" + groups + ")>0 ";
                }
                if (Utils.isBlankString((String)(addServices = this.moduleSetup.get("reports.shturman_1.addsids", null)))) {
                    addServices = null;
                }
                String tmpTrafficSums = "_shturman_traf_sum";
                String tmpAccountSums = "_shturman_account_sum";
                ServerUtils.dropExistTable((Connection)this.con, (String)tmpTrafficSums);
                ServerUtils.dropExistTable((Connection)this.con, (String)tmpAccountSums);
                String query = null;
                PreparedStatement ps = null;
                query = "CREATE TABLE " + tmpTrafficSums + " (UNIQUE(cid, sid)) SELECT detail.cid, detail.sid, service.title, SUM(detail.amount) AS amount FROM " + sessionDetailTable + " AS detail INNER JOIN contract ON detail.cid=contract.id " + (String)contractGroupFilter + "LEFT JOIN service ON detail.sid=service.id ";
                if (Utils.notBlankString((String)services)) {
                    query = query + " WHERE detail.sid IN (" + services + ")";
                }
                query = query + "GROUP BY detail.cid, detail.sid";
                ps = this.con.prepareStatement(query);
                ps.executeUpdate();
                ps.close();
                query = "CREATE TABLE " + tmpAccountSums + " (UNIQUE(cid, sid)) SELECT account.cid, account.sid, service.title, ROUND(SUM(account.summa),2) AS summa FROM contract_account AS account INNER JOIN contract ON account.cid=contract.id " + (String)contractGroupFilter + "LEFT JOIN service ON account.sid=service.id WHERE account.yy=? AND account.mm=? GROUP BY account.cid, account.sid";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, yy);
                ps.setInt(2, mm);
                ps.executeUpdate();
                ps.close();
                Comparator<Entry<Map<String, Object>>> comp = new Comparator<Entry<Map<String, Object>>>(){

                    @Override
                    public int compare(Entry<Map<String, Object>> o1, Entry<Map<String, Object>> o2) {
                        return o1.i - o2.i;
                    }
                };
                ArrayList s = new ArrayList(100000);
                query = "SELECT contract.id, contract.title, contract.comment, detail.sid, detail.title, detail.amount, account.summa FROM contract INNER JOIN " + tmpTrafficSums + " AS detail ON contract.id=detail.cid LEFT JOIN " + tmpAccountSums + " AS account ON detail.cid=account.cid AND detail.sid=account.sid WHERE 1>0 " + (String)contractGroupFilter;
                ps = this.con.prepareStatement(query);
                ResultSet trafficRS = ps.executeQuery();
                while (trafficRS.next()) {
                    Entry unit = (Entry)unitMap.get(trafficRS.getInt(4));
                    if (unit == null) {
                        unit = (Entry)unitMap.get(0);
                    }
                    double d = (double)trafficRS.getLong(6) / (double)unit.i;
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    int cid = trafficRS.getInt(1);
                    row.put("cid", cid);
                    row.put("contract", trafficRS.getString(2));
                    row.put("comment", trafficRS.getString(3));
                    row.put("service", trafficRS.getString(5));
                    row.put("amount", df.format(d));
                    row.put("summ", Utils.maskNull((BigDecimal)trafficRS.getBigDecimal(7)));
                    row.put("unit", unit.v);
                    s.add(new Entry(cid, row));
                }
                trafficRS.close();
                ps.close();
                if (addServices != null) {
                    query = "SELECT contract.id, contract.title, contract.comment, account.sid, account.title, account.summa FROM contract INNER JOIN " + tmpAccountSums + " AS account ON contract.id=account.cid WHERE 1>0 " + (String)contractGroupFilter;
                    ps = this.con.prepareStatement(query);
                    trafficRS = ps.executeQuery();
                    while (trafficRS.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        int n = trafficRS.getInt(1);
                        row.put("cid", n);
                        row.put("contract", trafficRS.getString(2));
                        row.put("comment", trafficRS.getString(3));
                        row.put("service", trafficRS.getString(5));
                        row.put("amount", "");
                        row.put("summ", Utils.maskNull((BigDecimal)trafficRS.getBigDecimal(6)));
                        row.put("unit", "");
                        s.add(new Entry(n, row));
                    }
                    trafficRS.close();
                    ps.close();
                }
                Collections.sort(s, comp);
                for (Entry entry : s) {
                    bds.addRow((Map)entry.v);
                }
                ServerUtils.dropExistTable((Connection)this.con, (String)tmpTrafficSums);
                ServerUtils.dropExistTable((Connection)this.con, (String)tmpAccountSums);
            }
            this.fillReportToStream("dialup_shturman_1", out, params, (JRDataSource)bds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private final class Entry<K> {
        private final int i;
        private final K v;

        public Entry(int delim, K name) {
            this.i = delim;
            this.v = name;
        }
    }
}

