/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.report.csv;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class PaymasterReestrReport
implements BGCSVReport.CSVFillerData {
    @Override
    public void fillReport(Connection con, BGReportFilter filter, BGCSVReport.ReportResult result) throws Exception {
        int mid = filter.getIntParam("mid");
        ArrayList<Map<String, String>> fields = new ArrayList<Map<String, String>>(100);
        String periodFrom = filter.getStringParam("date1");
        if (Utils.isEmptyString((String)periodFrom)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("date", "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            fields.add(map);
            result.setData(fields);
            return;
        }
        String periodTo = filter.getStringParam("date2");
        if (Utils.isEmptyString((String)periodTo)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("date", "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            fields.add(map);
            result.setData(fields);
            return;
        }
        DecimalFormat decimalFormatId = new DecimalFormat("###,###,##0");
        DecimalFormat decimalFormatSum = new DecimalFormat("###,###,##0.00");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Period period = new Period(dateFormat.parse(periodFrom), dateFormat.parse(periodTo));
        int count = 0;
        BigDecimal sum = BigDecimal.ZERO;
        String query = "select t.id, t.payment_date, c.title, t.sum from paymaster_transaction_" + mid + " as t left join contract as c on c.id=t.contract_id where t.status='pay' AND t.payment_date>=? AND t.payment_date<?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
        ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)TimeUtils.getNextDay((Date)period.getDateTo())));
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            BigDecimal tSum = rs.getBigDecimal("t.sum");
            sum = sum.add(tSum);
            ++count;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("transactionId", decimalFormatId.format(rs.getInt("t.id")));
            map.put("date", dateFormat.format(rs.getDate("t.payment_date")));
            map.put("contractTitle", rs.getString("c.title"));
            map.put("sum", decimalFormatSum.format(tSum));
            fields.add(map);
        }
        rs.close();
        ps.close();
        HashMap<String, CallSite> map = new HashMap<String, CallSite>();
        map.put("transactionId", (CallSite)((Object)("\u0412\u0441\u0435\u0433\u043e \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439: " + decimalFormatId.format(count))));
        map.put("sum", (CallSite)((Object)("\u0418\u0442\u043e\u0433\u043e: " + decimalFormatSum.format(sum))));
        fields.add(map);
        result.setData(fields);
    }
}

