/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.include;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.reports.client.include.Params;
import ru.bitel.bgbilling.modules.reports.client.include.SetData;
import ru.bitel.bgbilling.modules.reports.client.modules.kernel.ReportParams_Default;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class RFAddress
extends JPanel
implements Params,
SetData {
    private String title = null;
    private BGComboBox<ComboBoxItem> city = new BGComboBox();
    private BGComboBox<ComboBoxItem> area = new BGComboBox();
    private BGComboBox<ComboBoxItem> street = new BGComboBox();
    private BGComboBox<ComboBoxItem> quarter = new BGComboBox();
    private BGComboBox<ComboBoxItem> house = new BGComboBox();
    private static final String ANY_VAL = "\u041b\u044e\u0431\u043e\u0439";
    public static final String CITY = "cityName";
    public static final String STREET = "streetName";
    public static final String AREA = "areaName";
    public static final String QUARTER = "quarterName";
    public static final String HOUSE = "houseName";
    private Map<String, String> paramsMap = new HashMap<String, String>();
    private ReportParams_Default report = null;

    public RFAddress(String title, String cityName, String streetName, String areaName, String quarterName, String houseName) {
        this.title = title;
        this.paramsMap.put(CITY, cityName);
        this.paramsMap.put(STREET, streetName);
        this.paramsMap.put(AREA, areaName);
        this.paramsMap.put(QUARTER, quarterName);
        this.paramsMap.put(HOUSE, houseName);
        this.inutGUI();
    }

    private void inutGUI() {
        this.setLayout(new GridBagLayout());
        if (this.title.equals("")) {
            this.setBorder((Border)new BGTitleBorder());
        } else if (this.title != null) {
            this.setBorder((Border)new BGTitleBorder(" " + this.title + " "));
        }
        if (Utils.notBlankString((String)this.paramsMap.get(CITY))) {
            this.add((Component)new JLabel("\u0413\u043e\u0440\u043e\u0434"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.city, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        if (Utils.notBlankString((String)this.paramsMap.get(AREA))) {
            this.add((Component)new JLabel("\u0420\u0430\u0439\u043e\u043d"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.area, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        if (Utils.notBlankString((String)this.paramsMap.get(QUARTER))) {
            this.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0430\u043b"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.quarter, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        if (Utils.notBlankString((String)this.paramsMap.get(STREET))) {
            this.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.street, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        if (Utils.notBlankString((String)this.paramsMap.get(HOUSE))) {
            this.add((Component)new JLabel("\u0414\u043e\u043c"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
            this.add((Component)this.house, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        this.city.addActionListener(e -> {
            this.fill(this.area, (ComboBoxItem)this.city.getSelectedItem(), 6);
            this.fill(this.street, (ComboBoxItem)this.city.getSelectedItem(), 7);
            this.fill(this.quarter, (ComboBoxItem)this.city.getSelectedItem(), 8);
        });
        this.area.addActionListener(e -> this.fillHouse());
        this.street.addActionListener(e -> this.fillHouse());
        this.quarter.addActionListener(e -> this.fillHouse());
    }

    @Override
    public void putParams(Map<String, Object> params) {
        ComboBoxItem houseItem;
        ComboBoxItem quarterItem;
        ComboBoxItem areaItem;
        ComboBoxItem streetItem;
        params.put(this.paramsMap.get(CITY), -1);
        params.put(this.paramsMap.get(STREET), -1);
        params.put(this.paramsMap.get(AREA), -1);
        params.put(this.paramsMap.get(QUARTER), -1);
        params.put(this.paramsMap.get(HOUSE), -1);
        ComboBoxItem cityItem = (ComboBoxItem)this.city.getSelectedItem();
        if (cityItem != null) {
            params.put(this.paramsMap.get(CITY), cityItem.getObject());
        }
        if ((streetItem = (ComboBoxItem)this.street.getSelectedItem()) != null) {
            params.put(this.paramsMap.get(STREET), streetItem.getObject());
        }
        if ((areaItem = (ComboBoxItem)this.area.getSelectedItem()) != null) {
            params.put(this.paramsMap.get(AREA), areaItem.getObject());
        }
        if ((quarterItem = (ComboBoxItem)this.quarter.getSelectedItem()) != null) {
            params.put(this.paramsMap.get(QUARTER), quarterItem.getObject());
        }
        if ((houseItem = (ComboBoxItem)this.house.getSelectedItem()) != null) {
            String houseVal = ANY_VAL.equals(houseItem.toString()) ? null : houseItem.toString();
            params.put(this.paramsMap.get(HOUSE), houseVal);
        }
    }

    @Override
    public void setData(ReportParams_Default d) {
        this.report = d;
        this.fillCity();
    }

    private void fillCity() {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressDirectory");
        request.setAttribute("mode", 5);
        Document doc = this.report.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.city, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/directory"), null);
        }
        this.city.insertItemAt((Object)new ComboBoxItem(-1, ANY_VAL), 0);
        this.city.setSelectedIndex(0);
    }

    private void fill(BGComboBox<ComboBoxItem> comboBox, ComboBoxItem item, int mode) {
        if (item == null) {
            return;
        }
        int cityId = Integer.valueOf((String)item.getObject());
        if (cityId > 0) {
            Request request = new Request();
            request.setModule("admin");
            request.setAction("GetAddressDirectory");
            request.setAttribute("mode", mode);
            request.setAttribute("city", cityId);
            Document doc = this.report.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildComboBox(comboBox, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/directory"), (String)"");
            }
        }
        comboBox.insertItemAt((Object)new ComboBoxItem(-1, ANY_VAL), 0);
        comboBox.setSelectedIndex(0);
    }

    private void fillHouse() {
        Document doc;
        int areaId = this.getValue(this.area);
        int streetId = this.getValue(this.street);
        int quarterId = this.getValue(this.quarter);
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressDirectory");
        request.setAttribute("mode", 9);
        if (areaId > 0) {
            request.setAttribute("area", areaId);
        }
        if (streetId > 0) {
            request.setAttribute("street", streetId);
        }
        if (quarterId > 0) {
            request.setAttribute("quarter", quarterId);
        }
        if (ClientUtils.checkStatus((Document)(doc = this.report.getDocument(request)))) {
            ClientUtils.buildComboBox(this.house, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/directory"), (String)"");
        }
        this.house.insertItemAt((Object)new ComboBoxItem(-1, ANY_VAL), 0);
        this.house.setSelectedIndex(0);
    }

    private int getValue(BGComboBox<ComboBoxItem> bgComboBox) {
        ComboBoxItem comboBoxItem = (ComboBoxItem)bgComboBox.getSelectedItem();
        return comboBoxItem == null ? -1 : Integer.valueOf((String)comboBoxItem.getObject());
    }
}

