/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.robokassa.server.servlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.robokassa.common.bean.Transaction;
import ru.bitel.bgbilling.modules.robokassa.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.robokassa.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebServlet(name="RobokassaExecutor", urlPatterns={"/robokassa/*"})
public class ModuleExecutor
extends CommonExecutor {
    private static final char CHAR_COLON = ':';
    private static final String PARAM_SIGNATURE_VALUE = "SignatureValue";
    private static final String PARAM_OUT_SUM = "OutSum";
    private static final String PARAM_INV_ID = "InvId";
    private static final Logger logger = LogManager.getLogger();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            block16: {
                block15: {
                    block14: {
                        con = null;
                        moduleId = ModuleExecutor.getModuleId((HttpServletRequest)request);
                        con = Setup.getSetup().getDBConnectionFromPool();
                        moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
                        transactionId = request.getParameter("InvId");
                        outSum = request.getParameter("OutSum");
                        signatureValue = request.getParameter("SignatureValue");
                        merchantPass2 = moduleSetup.get("robokassa.merchant.password.2", "");
                        if (transactionId == null || outSum == null || signatureValue == null) break block13;
                        signData = outSum + ':' + transactionId + ':' + merchantPass2;
                        checkSignData = Utils.getDigest((String)signData, (String)"UTF-8");
                        if (!signatureValue.equals(checkSignData)) ** GOTO lbl76
                        transactionManager = new TransactionManager(con, moduleId);
                        transaction = (Transaction)transactionManager.get(Utils.parseInt((String)transactionId));
                        transactionManager.close();
                        if (transaction != null) break block14;
                        ModuleExecutor.logger.error("Not found transaction for ID = " + transactionId);
                        response.setStatus(500);
                        ServerUtils.closeConnection((Connection)con);
                        return;
                    }
                    if (transaction.getStatus().equals(TransactionStatus.CREATED.getCode())) break block15;
                    ModuleExecutor.logger.error("Transaction for ID = " + transactionId + " has status != 'created'");
                    response.setStatus(200);
                    ServerUtils.closeConnection((Connection)con);
                    return;
                }
                if (transaction.getPaymentId() <= 0) break block16;
                ModuleExecutor.logger.error("Transaction for ID = " + transactionId + " has PaymentId > 0");
                response.setStatus(200);
                ServerUtils.closeConnection((Connection)con);
                return;
            }
            try {
                transaction.setSum(new BigDecimal(outSum));
                transaction.setTransactionId(transactionId);
                transaction.setTransactionDate(new Date());
                transaction.setStatus(TransactionStatus.OK.getCode());
                payment = new Payment();
                payment.setContractId(transaction.getContractId());
                payment.setSum(transaction.getSum());
                paymentDate = transaction.getTransactionDate();
                if (paymentDate == null) {
                    paymentDate = new Date();
                    transaction.setTransactionDate(paymentDate);
                }
                payment.setDate(paymentDate);
                payment.setTypeId(moduleSetup.getInt("robokassa.payment.type.id", 0));
                payment.setComment(moduleSetup.get("robokassa.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0448\u043b\u044e\u0437 \u0420\u0424\u0418 \u0411\u0430\u043d\u043a\u0430 [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
                paymentDao = new PaymentDao(con);
                try {
                    paymentDao.update((Object)payment);
                }
                finally {
                    paymentDao.close();
                }
                transaction.setPaymentId(payment.getId());
                transactionManager = new TransactionManager(con, moduleId);
                transactionManager.update(transaction);
                transactionManager.close();
                balanceUtils = new BalanceUtils(con);
                balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                balanceUtils.close();
                EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                response.setContentType("text/plain");
                out = response.getWriter();
                out.print("OK");
                out.print(transactionId);
                out.flush();
                out.close();
                break block13;
lbl76:
                // 1 sources

                ModuleExecutor.logger.error("Error check sign (in request check = '" + signatureValue + "' no equals calculate = '" + checkSignData + "' )");
                response.setStatus(500);
            }
            catch (BGException ex) {
                try {
                    ModuleExecutor.logger.error(ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable var19_21) {
                    ServerUtils.closeConnection(con);
                    throw var19_21;
                }
                ServerUtils.closeConnection((Connection)con);
            }
            ServerUtils.closeConnection((Connection)con);
            return;
        }
        ServerUtils.closeConnection((Connection)con);
    }
}

