/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.sberbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.sberbank.server.bean.Constants;
import ru.bitel.bgbilling.modules.sberbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankCheckEvent;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u0421\u0431\u0435\u0440\u0431\u0430\u043d\u043a")
public class ActionDoTransaction
extends AbstractAction {
    private final String moduleName = "sberbank";

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm("sberbank", Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(null, this.getPage(), new String[]{"transactionDatetime:1"});
            transactionManager.searchTransaction(searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL), null);
            this.context.getRequest().setAttribute("transactions", (Object)searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 + \u0438\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void check() throws Exception {
        EventProcessor.getInstance().publish((Event)new SberbankCheckEvent(this.moduleId, this.contractId, false));
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("sberbank.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("sberbank.sum.max", new BigDecimal(5000));
        String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        try (TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);){
            transactionManager.registerOrder(this.contractId, ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle(), customerAddress, sum, this.getResult(), false, false);
        }
        this.doRedirect();
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        int mode;
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        boolean autopaymentEnable = this.moduleSetup.getBoolean("sberbank.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = this.req.getInt("mode", 0)) > -1 && mode < 4) {
            Preferences modeDataMap;
            String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode().getCode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment();
                autopayment.setContractId(this.contractId);
            }
            TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);
            String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF.getCode()) {
                autopayment.setMode(AutopaymentMode.OFF);
                autopayment.setSum(BigDecimal.ZERO);
                autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                autopayment.setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK.getCode()) {
                int autopaymentWeekDay = this.moduleSetup.getInt("sberbank.autopayment.mode.week.day.default", 1);
                modeDataMap.set("autopayment.mode.week.day", String.valueOf(this.req.getInt("dayOfWeek", autopaymentWeekDay)));
                BigDecimal autopaymentWeekSum = this.moduleSetup.getBigDecimal("sberbank.autopayment.mode.week.sum.default", new BigDecimal(50));
                autopaymentWeekSum = this.req.getBigDecimal("weekSum", autopaymentWeekSum);
                modeDataMap.set("autopayment.mode.week.sum", String.valueOf(autopaymentWeekSum));
                autopayment.setSum(autopaymentWeekSum);
                autopayment.setMode(AutopaymentMode.WEEK);
                transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, autopaymentWeekSum, this.getResult(), false, true);
            } else if (mode == AutopaymentMode.MONTH.getCode()) {
                int autopaymentMonthDay = this.moduleSetup.getInt("sberbank.autopayment.mode.month.day.default", 1);
                modeDataMap.set("autopayment.mode.month.day", String.valueOf(this.req.getInt("dayOfMonth", autopaymentMonthDay)));
                BigDecimal autopaymentMonthSum = this.moduleSetup.getBigDecimal("sberbank.autopayment.mode.month.sum.default", new BigDecimal(50));
                autopaymentMonthSum = this.req.getBigDecimal("monthSum", autopaymentMonthSum);
                modeDataMap.set("autopayment.mode.month.sum", String.valueOf(autopaymentMonthSum));
                autopayment.setSum(autopaymentMonthSum);
                autopayment.setMode(AutopaymentMode.MONTH);
                transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, autopaymentMonthSum, this.getResult(), false, true);
            } else if (mode == AutopaymentMode.AUTO.getCode()) {
                BigDecimal autopaymentAutoMaxDaySum = this.moduleSetup.getBigDecimal("sberbank.autopayment.mode.auto.day.sum.default", new BigDecimal(500));
                autopaymentAutoMaxDaySum = this.req.getBigDecimal("maxDaySum", autopaymentAutoMaxDaySum);
                modeDataMap.set("autopayment.mode.auto.day.sum", String.valueOf(autopaymentAutoMaxDaySum));
                BigDecimal autopaymentAutoMaxWeekSum = this.moduleSetup.getBigDecimal("sberbank.autopayment.mode.auto.week.sum.default", new BigDecimal(1000));
                autopaymentAutoMaxWeekSum = this.req.getBigDecimal("maxWeekSum", autopaymentAutoMaxWeekSum);
                modeDataMap.set("autopayment.mode.auto.week.sum", String.valueOf(autopaymentAutoMaxWeekSum));
                BigDecimal autopaymentAutoMaxMonthSum = this.moduleSetup.getBigDecimal("sberbank.autopayment.mode.auto.month.sum.default", new BigDecimal(3000));
                autopaymentAutoMaxMonthSum = this.req.getBigDecimal("maxMonthSum", autopaymentAutoMaxMonthSum);
                modeDataMap.set("autopayment.mode.auto.month.sum", String.valueOf(autopaymentAutoMaxMonthSum));
                autopayment.setSum(autopaymentAutoMaxDaySum);
                autopayment.setMode(AutopaymentMode.AUTO);
                transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, autopaymentAutoMaxDaySum, this.getResult(), false, true);
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
            autopaymentManager.close();
            transactionManager.close();
            if (autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode()) {
                this.doRedirect();
            } else {
                this.execute();
            }
        }
    }

    protected void doRedirect() throws BGException {
        Object formUrl = this.getResultParam("formUrl");
        if (formUrl != null) {
            try {
                this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(String.valueOf(formUrl));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(this.getResultParam("errorMessage") + " [errorCode=" + this.getResultParam("errorCode") + "]");
    }
}

