/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client;

import java.util.Map;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections4.map.HashedMap;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.client.PackageOptionPanel;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.common.client.table.BGTableModel;

class PackageOptionTableModel
extends BGTableModel<SmartHousePackageOption> {
    private Map<Integer, String> services = null;
    private PackageOptionPanel packageOptionPanel = null;

    public PackageOptionTableModel(String name, PackageOptionPanel packageOptionPanel) {
        super(name);
        this.packageOptionPanel = packageOptionPanel;
    }

    protected void initColumns() {
        this.addColumn("\u041e\u043f\u0446\u0438\u044f", 250, 300, 500, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", 300, 400, -1, "serviceId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
    }

    public Object getValue(SmartHousePackageOption packageOption, int column) throws BGException {
        String identifier = this.getIdentifier(column);
        if ("serviceId".equals(identifier)) {
            return this.getServiceTitle(packageOption.getServiceId());
        }
        return super.getValue((Object)packageOption, column);
    }

    private String getServiceTitle(int serviceId) throws BGException {
        if (this.services == null) {
            this.services = new HashedMap();
            for (String service : this.packageOptionPanel.getSmartHousePackageService().serviceList()) {
                JSONObject json = new JSONObject(service);
                this.services.put(json.optInt("key"), json.optString("value"));
            }
        }
        return this.services.get(serviceId);
    }
}

