/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.intercom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.intercom.SmartHouseIntercomFlat;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseIntercomService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ContractIntercomPanel
extends BGUPanel {
    private Directory<UserInfo> userDirectory = null;
    private SmartHouseIntercomFlat smartHouseIntercomFlat = null;
    private JTextField currentStatus = new JTextField(15);
    private JButton statusButton = new JButton("\u0432\u043a\u043b.");
    private SmartHouseIntercomService smartHouseIntercomService = null;
    private JPanel statusLogPanel = null;
    private JPanel setIntercomPanel = null;
    private JPanel statusButtonPanel = null;
    private IntercomStatusLogTableModel intercomStatusLogTableModel = new IntercomStatusLogTableModel();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    private SmartHouseIntercomService getSmartHouseIntercomService() {
        if (this.smartHouseIntercomService == null) {
            this.smartHouseIntercomService = (SmartHouseIntercomService)((ClientContext)this.getContext()).getPort(SmartHouseIntercomService.class);
        }
        return this.smartHouseIntercomService;
    }

    private JPanel getStatusButtonPanel() {
        if (this.statusButtonPanel == null) {
            ActionListener statusActionListener = e -> {
                try {
                    this.getSmartHouseIntercomService().setIntercomFlatStatus(((ClientContext)this.getContext()).getContractId(), this.smartHouseIntercomFlat.getId(), "on".equals(this.statusButton.getActionCommand()));
                    this.performAction("refresh");
                }
                catch (Exception e1) {
                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                }
            };
            this.statusButton.addActionListener(statusActionListener);
            this.currentStatus.setHorizontalAlignment(0);
            this.currentStatus.setFont(this.currentStatus.getFont().deriveFont(1));
            this.currentStatus.setEditable(false);
            this.currentStatus.setBackground(new JTextField().getBackground());
            this.statusButtonPanel = new JPanel(new GridBagLayout());
            this.statusButtonPanel.add((Component)new JLabel("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0441\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.statusButtonPanel.add((Component)this.currentStatus, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.statusButtonPanel.add((Component)this.statusButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        return this.statusButtonPanel;
    }

    private JPanel getStatusLogPanel() {
        if (this.statusLogPanel == null) {
            BGUTable table = new BGUTable((TableModel)((Object)this.intercomStatusLogTableModel));
            table.setSelectionMode(0);
            this.statusLogPanel = new JPanel(new GridBagLayout());
            this.statusLogPanel.add((Component)new JLabel("\u041b\u043e\u0433 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.statusLogPanel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        }
        return this.statusLogPanel;
    }

    private JPanel getSetIntercomPanel() {
        if (this.setIntercomPanel == null) {
            JButton addButton = new JButton("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0434\u043e\u043c\u043e\u0444\u043e\u043d \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443");
            addButton.addActionListener(e -> {
                try {
                    ClientUtils.showMessageDialog((Object)"\u0424\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435...");
                }
                catch (Exception e1) {
                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                }
            });
            this.setIntercomPanel = new JPanel(new GridBagLayout());
            this.setIntercomPanel.add((Component)new JLabel("\u0414\u043e\u043c\u043e\u0444\u043e\u043d \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443..."), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setIntercomPanel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 50, 0), 0, 0));
        }
        return this.setIntercomPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ContractIntercomPanel.this.smartHouseIntercomFlat = ContractIntercomPanel.this.getSmartHouseIntercomService().getSmartHouseIntercomFlatByContractId(((ClientContext)ContractIntercomPanel.this.getContext()).getContractId());
                ContractIntercomPanel.this.removeAll();
                if (ContractIntercomPanel.this.smartHouseIntercomFlat == null) {
                    ContractIntercomPanel.this.add(ContractIntercomPanel.this.getSetIntercomPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                } else {
                    ContractIntercomPanel.this.add(ContractIntercomPanel.this.getStatusButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
                    ContractIntercomPanel.this.add(ContractIntercomPanel.this.getStatusLogPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                    ContractIntercomPanel.this.statusButton.setText(ContractIntercomPanel.this.smartHouseIntercomFlat.isStatus() ? "\u0412\u042b\u041a\u041b\u042e\u0427\u0418\u0422\u042c" : "\u0412\u041a\u041b\u042e\u0427\u0418\u0422\u042c");
                    ContractIntercomPanel.this.statusButton.setActionCommand(ContractIntercomPanel.this.smartHouseIntercomFlat.isStatus() ? "off" : "on");
                    ContractIntercomPanel.this.currentStatus.setText(ContractIntercomPanel.this.smartHouseIntercomFlat.isStatus() ? "\u0412\u041a\u041b\u042e\u0427\u0415\u041d\u041e" : "\u0412\u042b\u041a\u041b\u042e\u0427\u0415\u041d\u041e");
                    ContractIntercomPanel.this.setLogData();
                }
            }
        };
    }

    private void setLogData() {
        try {
            SearchResult searchResult = this.getSmartHouseIntercomService().searchIntercomFlatStatusLogs(this.smartHouseIntercomFlat.getId(), null);
            this.intercomStatusLogTableModel.setData(searchResult.getList().stream().map(e -> new JSONObject(e)).collect(Collectors.toList()));
        }
        catch (Exception e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    private Directory<UserInfo> getUserDirectory() throws BGException {
        if (this.userDirectory == null) {
            this.userDirectory = ((ClientContext)this.getContext()).getDirectory(UserInfo.class, 0);
        }
        return this.userDirectory;
    }

    class IntercomStatusLogTableModel
    extends BGTableModel<JSONObject> {
        public IntercomStatusLogTableModel() {
            super(IntercomStatusLogTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430", 200, 200, 200, "updateDate", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 200, 200, -1, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0418\u0437\u043c\u0435\u043d\u0438\u043b", 200, 200, -1, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(JSONObject val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("userId".equals(identifier)) {
                int userId = val.optInt(identifier);
                UserInfo userInfo = (UserInfo)ContractIntercomPanel.this.getUserDirectory().get(userId);
                return userInfo == null ? "??? (ID#" + userId + ")" : userInfo.getName();
            }
            if ("status".equals(identifier)) {
                return "0".equals(val.getString(identifier)) ? "\u0432\u044b\u043a\u043b." : "\u0432\u043a\u043b.";
            }
            return val.optString(identifier);
        }
    }
}

