/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import java.util.HashMap;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.event.forpost.ForpostAccountDefaultEvent;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostAccountService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostAccountService")
public class ForpostAccountServiceImpl
extends AbstractService
implements ForpostAccountService {
    public SearchResult<ForpostAccount> searchForpostAccounts(int contractId, String accountName, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setPage(page);
        searchResult.setSort(sort);
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            forpostAccountDao.searchForpostAccounts((SearchResult<ForpostAccount>)searchResult, contractId, accountName);
        }
        return searchResult;
    }

    public void doSync() throws BGException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            forpostAccountDao.doSync(new ForpostManager(this.moduleId).getAccounts());
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public ForpostAccount getDefaultForpostAccount(int contractId) throws BGException {
        ForpostAccountDefaultEvent event = new ForpostAccountDefaultEvent(this.moduleId, contractId, new ForpostAccount());
        return ((ForpostAccountDefaultEvent)EventProcessor.getInstance().request((QueueEvent)event)).getForpostAccount();
    }

    public int addForpostAccount(int contractId, ForpostAccount forpostAccount) throws BGException, BGMessageException {
        int n;
        if (contractId != forpostAccount.getContractId()) {
            return 0;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", forpostAccount.getName());
        params.put("MaxCameraCount", String.valueOf(forpostAccount.getMaxCameraCount()));
        params.put("MaxLoginCount", String.valueOf(forpostAccount.getMaxLoginCount()));
        params.put("IsActive", String.valueOf(forpostAccount.getIsActive()));
        params.putAll(Utils.linesToPairsHash((String)forpostAccount.getData()));
        ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
        try {
            ForpostAccount[] remoteForpostAccounts;
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseId responseId = forpostManager.addAccount(params);
            if (responseId.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
            }
            int accountId = responseId.getId();
            forpostAccount.setId(accountId);
            for (ForpostAccount remoteForpostAccount : remoteForpostAccounts = forpostManager.getAccounts(accountId, null, null)) {
                if (remoteForpostAccount.getId() != accountId) continue;
                remoteForpostAccount.setId(forpostAccount.getId());
                remoteForpostAccount.setName(forpostAccount.getName());
                forpostAccount = remoteForpostAccount;
                break;
            }
            forpostAccountDao.update(forpostAccount);
            forpostAccountDao.updateAccountContract(accountId, contractId);
            n = accountId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    forpostAccountDao.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        forpostAccountDao.close();
        return n;
    }

    public void updateForpostAccountParam(int forpostAccountId, String name, String value) throws BGException, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            ForpostAccount forpostAccount = forpostAccountDao.getForpostAccount(forpostAccountId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ID", String.valueOf(forpostAccount.getId()));
            params.put(name, value);
            switch (name) {
                case "Name": {
                    forpostAccount.setName(value);
                    break;
                }
                case "MaxCameraCount": {
                    forpostAccount.setMaxCameraCount(Utils.parseInt((String)value));
                    break;
                }
                case "MaxLoginCount": {
                    forpostAccount.setMaxLoginCount(Utils.parseInt((String)value));
                    break;
                }
                case "IsActive": {
                    forpostAccount.setIsActive(Utils.parseInt((String)value));
                    break;
                }
                default: {
                    forpostAccount.put(name, (Object)value);
                }
            }
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            try {
                ResponseId responseId = forpostManager.editAccount(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostAccountDao.update(forpostAccount);
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    public ForpostAccount getForpostAccount(int forpostAccountId) throws BGException, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            ForpostAccount forpostAccount = forpostAccountDao.getForpostAccount(forpostAccountId);
            return forpostAccount;
        }
    }

    public void deleteForpostAccount(int forpostAccountId) throws BGException, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            ForpostManager forpostManager = new ForpostManager(this.moduleId);
            ResponseStatus responseStatus = forpostManager.deleteAccount(forpostAccountId);
            if (responseStatus.getErrorCode() > 0) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
            }
            forpostAccountDao.deleteForpostAccount(forpostAccountId);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void unlinkForpostAccount(int forpostAccountId) throws BGException, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            forpostAccountDao.unlinkForpostAccount(forpostAccountId);
        }
    }

    public void linkForpostAccount(int forpostAccountId, int contractId) throws BGException, BGMessageException {
        try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);){
            forpostAccountDao.updateAccountContract(forpostAccountId, contractId);
        }
    }
}

