/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.tariff;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageContract;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHousePackageBaseDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHousePackageContractDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHousePackageOptionDao;
import ru.bitel.bgbilling.modules.smarthouse.server.tariff.SmartHousePackageOption;
import ru.bitel.bgbilling.modules.smarthouse.server.tariff.SmartHouseTariffContext;
import ru.bitel.bgbilling.modules.smarthouse.server.tariff.SmartHouseTariffRequest;
import ru.bitel.common.TimeUtils;

public class SmartHouseTariffUtils {
    private Connection con = null;
    private Logger logger = LogManager.getLogger();

    public SmartHouseTariffUtils(Connection con) {
        this.con = con;
    }

    public BigDecimal getPackageCost(int moduleId, int contractPackageId, LocalDate date) throws BGException {
        BigDecimal result;
        block21: {
            this.logger.debug("getPackageCost");
            result = BigDecimal.ZERO;
            try (SmartHousePackageContractDao packageContractDao = new SmartHousePackageContractDao(this.con, moduleId);
                 SmartHousePackageOptionDao packageOptionDao = new SmartHousePackageOptionDao(this.con, moduleId);
                 SmartHousePackageBaseDao packageBaseDao = new SmartHousePackageBaseDao(this.con, moduleId);){
                JSONArray options;
                SmartHousePackageContract packageContract = (SmartHousePackageContract)packageContractDao.get(contractPackageId);
                if (packageContract == null) break block21;
                int contractId = packageContract.getContractId();
                SmartHousePackageBase smartHousePackageBase = (SmartHousePackageBase)packageBaseDao.get(packageContract.getPackageId());
                ArrayList packageOptions = new ArrayList();
                if (smartHousePackageBase != null && (options = new JSONArray(smartHousePackageBase.getOptionNames())) != null) {
                    options.forEach(a -> packageOptions.add(String.valueOf(a)));
                }
                SmartHouseTariffContext tariffContext = new SmartHouseTariffContext(this.con, moduleId, TimeUtils.convertLocalDateToDate((LocalDate)date));
                try (TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);){
                    HashMap<String, SmartHousePackageOption> packageOptionMap = new HashMap<String, SmartHousePackageOption>();
                    SmartHouseTariffRequest smartHouseTariffRequest = new SmartHouseTariffRequest(0, moduleId, contractId, 0L, packageContract.getPackageId(), packageOptionMap);
                    TariffModuleTreeSet tariffModuleTreeSet = tariffModuleTreeSetDao.getTariffTreeSetForDay(contractId, date, "smarthouse", moduleId, 0, 0);
                    tariffModuleTreeSet.getTree(date).execute((AbstractTariffRequest)smartHouseTariffRequest, (TariffContext)tariffContext);
                }
            }
        }
        return result;
    }
}

