/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.task;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyProduct;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyParams;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyTransactionManager;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class UpdateSoftkeyProducts
extends TaskBase {
    private Connection con = null;
    private SoftkeyParams params = null;
    private List<SoftkeyProduct> productList = null;

    protected boolean initTask() {
        if (this.moduleId < 0) {
            this.log.error("Param mid not found!");
            return false;
        }
        this.con = Setup.getSetup().getDBConnectionFromPool();
        this.params = new SoftkeyParams(Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
        this.productList = new ArrayList<SoftkeyProduct>();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        try {
            this.log.info("Connecting to Softkey...");
            SoftkeyTransactionManager manager = new SoftkeyTransactionManager(this.con, this.moduleId);
            HashMap<String, String> dataParams = new HashMap<String, String>();
            dataParams.put("ac", String.valueOf(this.params.getAc()));
            dataParams.put("action", "ss-get_option_list");
            Document answerDoc = null;
            answerDoc = SoftkeyUtils.send(dataParams, this.params, false);
            if (answerDoc != null) {
                if (SoftkeyUtils.hasError(answerDoc)) {
                    SoftkeyUtils.setError(answerDoc);
                    throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432!");
                }
                Element confirmationCodeElement = XMLUtils.selectElement((Node)answerDoc, (String)"//result/confirmation_code");
                String code = confirmationCodeElement.getTextContent();
                dataParams.clear();
                dataParams.put("iconfirmationcode", code);
                answerDoc = SoftkeyUtils.send(dataParams, this.params, false);
                if (answerDoc != null) {
                    if (SoftkeyUtils.hasError(answerDoc)) {
                        SoftkeyUtils.setError(answerDoc);
                        throw new BGException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432!");
                    }
                    this.log.info("Getting product items...");
                    Iterable elems = XMLUtils.selectElements((Node)answerDoc, (String)"result/data/subscription_option_list/subscription_option");
                    for (Element node : elems) {
                        int optionId = Utils.parseInt((String)XMLUtils.selectElement((Node)node, (String)"OPTION_ID").getTextContent());
                        String optionName = XMLUtils.selectElement((Node)node, (String)"OPTION_NAME").getTextContent();
                        String programName = XMLUtils.selectElement((Node)node, (String)"PROGRAM_NAME").getTextContent();
                        String description = XMLUtils.selectElement((Node)node, (String)"CATALOG_DESC").getTextContent();
                        BigDecimal amount = Utils.parseBigDecimal((String)XMLUtils.selectElement((Node)node, (String)"AMOUNT").getTextContent(), (BigDecimal)BigDecimal.ZERO);
                        String currency = XMLUtils.selectElement((Node)node, (String)"CURRENCY").getTextContent();
                        Pattern pattern = Pattern.compile("<([\\/]*|[\\w])*>");
                        Matcher matcher = pattern.matcher(description);
                        if (matcher.find()) {
                            description = matcher.replaceAll("");
                        }
                        SoftkeyProduct product = new SoftkeyProduct();
                        product.setSubscribeId(optionId);
                        product.setSubscribeName(optionName);
                        product.setProductName(programName);
                        product.setProductDescription(description);
                        product.setAmount(amount);
                        product.setCurrency(currency);
                        this.productList.add(product);
                    }
                    if (!this.productList.isEmpty()) {
                        this.log.info("Cleaning products from database...");
                        manager.deleteProducts();
                        this.log.info("Adding products to the database...");
                        for (SoftkeyProduct product : this.productList) {
                            manager.addProduct(product);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage());
        }
        finally {
            ServerUtils.closeConnection((Connection)this.con);
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Softkey. \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0434\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
    }
}

