/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softline.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.softline.client.AbstractEditor;
import ru.bitel.bgbilling.modules.softline.client.SoftLineConfigureProductPanel;
import ru.bitel.bgbilling.modules.softline.common.bean.ProductCategory;
import ru.bitel.bgbilling.modules.softline.common.bean.TypeProduct;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class ProductCategoryPanel
extends BGUPanel
implements ActionListener {
    private BGUTable productCategoryTable;
    private BGControlPanelPages page = new BGControlPanelPages();
    private ProductCategoryTableModel tableModel;
    private SoftLineConfigureProductPanel parent;
    private ProductCategoryEditor editor;

    ProductCategoryPanel(SoftLineConfigureProductPanel parent) {
        this.parent = parent;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new ProductCategoryTableModel(ProductCategoryPanel.class.getName());
        this.editor = new ProductCategoryEditor();
        BGDialogToolBar toolBar = this.parent.buildToolBar(this);
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        this.add(this.getFilterPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)this.getProductTable()), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)((Object)this.editor), new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 3, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (e.getActionCommand()) {
            case "newItem": {
                this.editor.newItem();
                break;
            }
            case "editItem": {
                this.editor.editItem();
                break;
            }
            case "deleteItem": {
                this.editor.deleteItem();
            }
        }
    }

    private JPanel getFilterPanel() {
        this.page.setKey(this.getClass().getName());
        this.page.init();
        this.page.addPropertyChangeListener(evt -> this.performAction("refresh"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.page, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        return filterPanel;
    }

    private BGUTable getProductTable() {
        if (this.productCategoryTable == null) {
            this.productCategoryTable = new BGUTable((TableModel)((Object)this.tableModel));
            this.productCategoryTable.setSelectionMode(0);
            this.productCategoryTable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1 && ProductCategoryPanel.this.tableModel.getSelectedRow() != null) {
                        ProductCategoryPanel.this.editor.editItem();
                    }
                }
            });
        }
        return this.productCategoryTable;
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "refresh"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SearchResult result = ProductCategoryPanel.this.parent.getService().getProductCategories(ProductCategoryPanel.this.page.getPage());
                ProductCategoryPanel.this.tableModel.setData(result.getList());
                ProductCategoryPanel.this.page.setPage(result.getPage());
            }
        };
    }

    private class ProductCategoryTableModel
    extends BGTableModel<ProductCategory> {
        ProductCategoryTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", -1, 200, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "description", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    private class ProductCategoryEditor
    extends AbstractEditor {
        private ProductCategory current;

        private ProductCategoryEditor() {
        }

        @Override
        protected void jbInit() throws Exception {
            super.jbInit();
            this.add(new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.title, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.getDescriptionPanel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.productPicture, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 0), 0, 0));
            this.add(this.selectPicture, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 5, 0), 0, 0));
            this.add((Component)this.buttonPanel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 3, 0), 0, 0));
        }

        @Override
        protected void actionOpen() {
            if (this.current != null) {
                this.title.setText(this.current.getTitle());
                this.description.setText(this.current.getDescription());
                try {
                    this.setPicture(ProductCategoryPanel.this.parent.getService().getProductPicture(this.current.getId(), TypeProduct.PRODUCT_CATEGORY));
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        }

        @Override
        protected void actionSave() throws BGException {
            String titleStr;
            if (this.current == null) {
                this.current = new ProductCategory();
            }
            if (Utils.isBlankString((String)(titleStr = this.title.getText()))) {
                BGToolTip.showErrorMessage((JComponent)this.title, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438");
                return;
            }
            this.current.setTitle(titleStr);
            this.current.setDescription(this.description.getText());
            ProductCategoryPanel.this.parent.getService().updateProductCategory(this.current);
            byte[] bytesPicture = this.getSelectedPicture();
            if (bytesPicture != null) {
                ProductCategoryPanel.this.parent.getService().setProductPicture(this.current.getId(), bytesPicture, TypeProduct.PRODUCT_CATEGORY);
            }
            ProductCategoryPanel.this.performAction("refresh");
            this.setVisible(false);
        }

        @Override
        protected void newItem() {
            this.current = new ProductCategory();
            this.performActionOpen();
        }

        @Override
        protected void editItem() {
            this.current = (ProductCategory)ProductCategoryPanel.this.tableModel.getSelectedRow();
            if (this.current != null) {
                this.performActionOpen();
            }
            ProductCategoryPanel.this.parent.performAction("refresh");
        }

        @Override
        protected void deleteItem() {
            this.current = (ProductCategory)ProductCategoryPanel.this.tableModel.getSelectedRow();
            if (this.current == null) {
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e " + this.current.getTitle() + "? \u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u044b \u043d\u0435 \u0431\u0443\u0434\u0443\u0442.", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                try {
                    ProductCategoryPanel.this.parent.getService().deleteProductCategory(this.current);
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
            ProductCategoryPanel.this.parent.performAction("refresh");
        }
    }
}

