/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormStatisticDao;
import ru.bitel.bgbilling.modules.sorm.server.event.SormUploadEvent;
import ru.bitel.bgbilling.modules.sorm.server.upload.PrepareUploadFilesByProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadToFTP;
import ru.bitel.bgbilling.modules.sorm.server.upload.bastion.BastionUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.elkom.ElkomUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.mfisoft.MfiSoftUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.shiftsystems.ShiftSystemsUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.specialtehnology.SpecTehUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.vasexpert.VasexpertUpload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SormProjectUpload {
    private static final Logger logger = LogManager.getLogger();
    protected Upload defaultUploadVersion;
    protected Upload customUploadVersion;
    private SormProject sormProject;
    protected Preferences config;
    protected boolean uploadOnlyPayments = false;
    protected boolean isFullUpload;
    protected boolean enablePaymentsUpload;
    protected SormManufacturer manufacturer;

    private SormProjectUpload() {
    }

    private void initVersion() throws BGException {
        this.manufacturer = SormManufacturer.getType((int)this.config.getInt("sorm.manufacturer", -1));
        if (this.manufacturer == null) {
            throw new BGException("\u041d\u0435\u0442 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430");
        }
        switch (this.manufacturer) {
            case VASEXPERTS: {
                this.defaultUploadVersion = new VasexpertUpload(this.sormProject, this.isFullUpload);
                break;
            }
            case MFISOFT: {
                this.defaultUploadVersion = new MfiSoftUpload(this.sormProject, this.isFullUpload);
                break;
            }
            case SPECIALTECHNOLOGY: {
                this.defaultUploadVersion = new SpecTehUpload(this.sormProject, this.isFullUpload);
                break;
            }
            case NORSITRANS: {
                this.defaultUploadVersion = new NorsiTransUpload(this.sormProject, this.isFullUpload);
                break;
            }
            case ELKOM: {
                this.defaultUploadVersion = new ElkomUpload(this.sormProject, this.isFullUpload);
                break;
            }
            case SHIFTSYSTEMS: {
                this.defaultUploadVersion = new ShiftSystemsUpload(this.sormProject, this.isFullUpload);
                break;
            }
            case BASTION: {
                this.defaultUploadVersion = new BastionUpload(this.sormProject, this.isFullUpload);
            }
        }
        SormUploadEvent sormUploadEvent = new SormUploadEvent(SormUtils.sormModuleId, this.sormProject, this.isFullUpload);
        EventProcessor.getInstance().request((QueueEvent)sormUploadEvent);
        this.customUploadVersion = sormUploadEvent.getUploadVersion();
        if (this.customUploadVersion != null) {
            logger.info("\u0411\u044b\u043b\u0430 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c. \u0412\u0441\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0431\u0443\u0434\u0443\u0442 \u0432\u0437\u044f\u0442\u044b \u0438\u0437 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438.");
        }
    }

    public void startUploadForStatistic(SormUploadStatistic statistic) throws BGException {
        if (this.defaultUploadVersion != null) {
            this.defaultUploadVersion.uploadForStatistic(statistic);
        }
        this.startUpload();
    }

    public void startUpload() throws BGException {
        boolean isNeedUploadToFtp;
        this.printDebugMessageToLog();
        UploadFiles uploadFiles = new PrepareUploadFilesByProject(this).getUploadFiles();
        boolean bl = isNeedUploadToFtp = this.config.getInt("sorm.ftp.upload.enable", -1) == 1;
        if (logger.isDebugEnabled()) {
            logger.debug("\u0424\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e. \u0412\u0441\u0435\u0433\u043e \u0444\u0430\u0439\u043b\u043e\u0432: " + uploadFiles.filesCount());
            logger.debug(isNeedUploadToFtp ? "\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP" : "\u0424\u0430\u0439\u043b\u044b \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0430 FTP, \u0442.\u043a. \u0434\u0430\u043d\u043d\u0430\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
        }
        SormUploadStatistic statistic = this.getUploadStatistic();
        if (isNeedUploadToFtp) {
            try {
                new UploadToFTP(uploadFiles, this.config, this.defaultUploadVersion);
                statistic.setUploadToFtpStatus(true);
            }
            catch (BGException ex) {
                logger.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0430 FTP \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + this.sormProject.getId() + "\n\u041e\u0448\u0438\u0431\u043a\u0430: " + ex.getMessage());
                statistic.setUploadToFtpStatus(false);
                statistic.setFtpUploadErrorMessage("(\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043d\u0430 FTP. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 \u043b\u043e\u0433\u0430\u0445)");
            }
        } else {
            statistic.setUploadToFtpStatus(false);
            statistic.setFtpUploadErrorMessage("(\u0432 \u043c\u043e\u0434\u0443\u043b\u0435 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP)");
        }
        this.updateStatisticUpload(statistic);
        if (this.customUploadVersion != null) {
            this.customUploadVersion.closeResources();
        }
        this.defaultUploadVersion.closeResources();
        if (this.config.getInt("sorm.upload.deletelocalfiles", -1) == 1) {
            this.deleteLocalFiles(uploadFiles);
        }
    }

    private void printDebugMessageToLog() {
        if (logger.isDebugEnabled()) {
            StringBuilder debugMessage = new StringBuilder("\u041d\u0430\u0447\u0430\u043b\u043e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438. \u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: ");
            debugMessage.append(this.isFullUpload ? "\u041f\u043e\u043b\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 " : "\u0418\u043d\u043a\u0440\u0435\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ");
            if (this.uploadOnlyPayments) {
                debugMessage.append("\u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
            } else {
                debugMessage.append(this.enablePaymentsUpload ? "\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438" : "\u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
            }
            logger.debug(debugMessage.toString());
        }
    }

    private void updateStatisticUpload(SormUploadStatistic statistic) throws BGException {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        int sormModuleId = serverContext.getModuleId();
        if (sormModuleId <= 0) {
            sormModuleId = SormUtils.sormModuleId;
        }
        SormStatisticDao statisticDao = new SormStatisticDao(serverContext.getConnection(), sormModuleId);
        try {
            statisticDao.update(statistic);
        }
        catch (BGException e) {
            logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \u0421\u041e\u0420\u041c: " + statistic.getSormProjectId());
            throw new BGException((Throwable)e);
        }
    }

    public SormUploadStatistic getUploadStatistic() {
        List<SormContract> contracts = this.defaultUploadVersion.contracts;
        SormUploadStatistic statistic = new SormUploadStatistic(this.sormProject.getId(), contracts.size());
        if (Utils.notEmptyCollection(contracts)) {
            statistic.setFirstUploadContractId(contracts.get(0).getContractId());
            statistic.setLastUploadContractId(contracts.get(contracts.size() - 1).getContractId());
        }
        return statistic;
    }

    private void deleteLocalFiles(UploadFiles uploadFiles) {
        List<Path> localFiles = uploadFiles.getFiles();
        logger.info("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438. \u0424\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f: " + localFiles.size());
        for (Path file : localFiles) {
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                logger.info("\u041c\u043e\u0434\u0443\u043b\u044c \u0421\u041e\u0420\u041c. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432.\n \u0424\u0430\u0439\u043b: " + file + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430");
            }
        }
    }

    public static Builder newUploadBuilder(SormProject sormProject) {
        return new SormProjectUpload().new Builder(sormProject);
    }

    public final class Builder {
        private Builder(SormProject sormProject) {
            SormProjectUpload.this.sormProject = sormProject;
            SormProjectUpload.this.config = sormProject.getLoadedConfig();
        }

        public Builder uploadOnlyPayments() {
            SormProjectUpload.this.uploadOnlyPayments = true;
            SormProjectUpload.this.isFullUpload = false;
            return this;
        }

        public Builder fullUploadOnlyPayments() {
            SormProjectUpload.this.uploadOnlyPayments = true;
            SormProjectUpload.this.isFullUpload = true;
            return this;
        }

        public Builder fullUploadWithPayments() {
            SormProjectUpload.this.isFullUpload = true;
            SormProjectUpload.this.enablePaymentsUpload = true;
            return this;
        }

        public Builder fullUploadWithoutPayments() {
            SormProjectUpload.this.isFullUpload = true;
            SormProjectUpload.this.enablePaymentsUpload = false;
            return this;
        }

        public Builder uploadWithPayments() {
            SormProjectUpload.this.isFullUpload = false;
            SormProjectUpload.this.enablePaymentsUpload = true;
            return this;
        }

        public Builder uploadWithoutPayments() {
            SormProjectUpload.this.isFullUpload = false;
            SormProjectUpload.this.enablePaymentsUpload = false;
            return this;
        }

        public SormProjectUpload build() throws BGException {
            if (SormProjectUpload.this.sormProject == null) {
                throw new BGException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0435\u043a\u0442 \u0421\u041e\u0420\u041c \u0434\u043b\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\n\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f SormProjectUpload: \n\t\tsormProjectId=" + SormProjectUpload.this.sormProject.getId() + "\n\t\tisFullUpload=" + SormProjectUpload.this.isFullUpload + "\n\t\tuploadOnlyPayments=" + SormProjectUpload.this.uploadOnlyPayments + "\n\t\tenablePaymentsUpload=" + SormProjectUpload.this.enablePaymentsUpload);
            }
            SormProjectUpload.this.initVersion();
            return SormProjectUpload.this;
        }
    }
}

