/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.common.bean.Unit;
import ru.bitel.bgbilling.modules.subscription.common.bean.ValueUnit;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class SubscriptionTypeDao
extends AbstractIdDao<SubscriptionType>
implements Directory<SubscriptionType> {
    public SubscriptionTypeDao(Connection con, int mid) {
        super(con, mid, "subscription_type");
    }

    protected SubscriptionType getFromRS(ResultSet rs) throws SQLException, BGException {
        SubscriptionType result = new SubscriptionType();
        result.setId(rs.getInt("id"));
        result.setServiceId(rs.getInt("service_id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setPeriod(new Period((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        result.setDuration(new ValueUnit(rs.getLong("duration_value"), Unit.valueOf((String)rs.getString("duration_unit"))));
        result.setDelay(new ValueUnit(rs.getLong("delay_value"), Unit.valueOf((String)rs.getString("delay_unit"))));
        result.setRound(new ValueUnit(rs.getLong("round_value"), Unit.valueOf((String)rs.getString("round_unit"))));
        result.setAvtoCommit(rs.getBoolean("avto_commit"));
        result.setConfig(rs.getString("config"));
        return result;
    }

    protected void updateImpl(SubscriptionType subscriptionType) throws BGException, SQLException {
        if (Utils.isBlankString((String)subscriptionType.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        int index = 1;
        boolean insertFlag = subscriptionType.getId() < 1;
        String query = this.tableName + " SET service_id=?, title=?, comment=?, date_from=?, date_to=?, duration_value=?, duration_unit=?, delay_value=?, delay_unit=?, round_value=?, round_unit=?, avto_commit=?, config=?";
        PreparedStatement ps = insertFlag ? this.con.prepareStatement("INSERT INTO " + query, 1) : this.con.prepareStatement("UPDATE " + query + " WHERE id=?");
        ps.setInt(index++, subscriptionType.getServiceId());
        ps.setString(index++, subscriptionType.getTitle());
        ps.setString(index++, subscriptionType.getComment());
        Period period = subscriptionType.getPeriod();
        ps.setDate(index++, period != null ? TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()) : null);
        ps.setDate(index++, period != null ? TimeUtils.convertDateToSqlDate((Date)period.getDateTo()) : null);
        ps.setLong(index++, subscriptionType.getDuration().getValue());
        ps.setString(index++, subscriptionType.getDuration().getUnit().toString());
        ps.setLong(index++, subscriptionType.getDelay().getValue());
        ps.setString(index++, subscriptionType.getDelay().getUnit().toString());
        ps.setLong(index++, subscriptionType.getRound().getValue());
        ps.setString(index++, subscriptionType.getRound().getUnit().toString());
        ps.setBoolean(index++, subscriptionType.isAvtoCommit());
        ps.setString(index++, subscriptionType.getConfig());
        if (!insertFlag) {
            ps.setInt(index++, subscriptionType.getId());
        }
        ps.executeUpdate();
        if (insertFlag) {
            subscriptionType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    public SubscriptionType get(String title) throws BGException {
        return (SubscriptionType)super.get("title=?", new Object[]{title});
    }

    public List<SubscriptionType> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }
}

