/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting.worker;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.accounting.TvAccounting;
import ru.bitel.bgbilling.apps.tv.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.apps.tv.accounting.worker.TvAccountTrackingWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusModifiedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.ContractTariffOptionChangedEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class EventTrackingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final TvAccounting accounting;
    private static final Map<Integer, ContractEventListener> MODULE_MAP = new HashMap<Integer, ContractEventListener>();
    private final ContractEventListener contractEventListener;
    private final FrequencyCounter processedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final FrequencyCounter processedContractsPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTrackingWorker(TvAccounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap processingParams) throws BGException {
        super(scheduledExecutorService, "event", processingParams);
        logger.info("Add event worker: delay=" + this.getDelay() + ", batchSize=" + this.batchSize);
        this.accounting = accounting;
        Class<EventTrackingWorker> clazz = EventTrackingWorker.class;
        synchronized (EventTrackingWorker.class) {
            ContractEventListener contractEventListener = MODULE_MAP.get(accounting.moduleId);
            if (contractEventListener == null) {
                contractEventListener = new ContractEventListener(accounting.moduleId);
                MODULE_MAP.put(accounting.moduleId, contractEventListener);
            }
            this.contractEventListener = contractEventListener;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected void runImpl() throws BGException, InterruptedException {
        Integer contractId;
        logger.trace("Run event processing...");
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        long millis = System.currentTimeMillis();
        Date now = new Date(millis);
        EventProcessor ep = EventProcessor.getInstance();
        TvAccountRuntimeMap inetServRuntimeMap = this.accounting.tvAccountRuntimeMap;
        TvDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        HashSet<Integer> processedContractIds = new HashSet<Integer>();
        int count = 0;
        int contractCount = 0;
        int batchSize = this.batchSize;
        while (count < batchSize && (contractId = this.contractEventListener.contractIdQueue.poll()) != null) {
            List<TvAccountRuntime> inetServRuntimeList;
            if (!processedContractIds.add(contractId) || (inetServRuntimeList = inetServRuntimeMap.list(contractId)) == null) continue;
            boolean contractProcessed = false;
            int size = inetServRuntimeList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.process(ep, connectionSet, rootDeviceRuntime, inetServRuntimeList.get(i), now, millis)) continue;
                contractProcessed = true;
                ++count;
            }
            if (!contractProcessed) continue;
            ++contractCount;
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.processedPerMinute.add(millis2, (long)count);
        this.processedContractsPerMinute.add(millis2, (long)contractCount);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (count > 0 && logger.isInfoEnabled()) {
            logger.info("Processed " + count + " inetServs for " + duration + " ms.");
        }
    }

    private boolean process(EventProcessor ep, ConnectionSet connectionSet, TvDeviceRuntime rootDeviceRuntime, TvAccountRuntime tvAccountRuntime, Date now, long millis) throws BGException {
        TvAccount inetServ = tvAccountRuntime.getTvAccount();
        if (inetServ.getDeviceId() != rootDeviceRuntime.tvDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(inetServ.getDeviceId())) {
            return false;
        }
        TvAccountTrackingWorker.process(this.accounting, (ServerContext)this.context, connectionSet, ep, tvAccountRuntime, now, millis);
        return true;
    }

    @MBeanAttribute
    public long getQueueSize() {
        return this.contractEventListener.contractIdQueue.size();
    }

    @MBeanAttribute
    public long getProcessedPerMinute() {
        return this.processedPerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getProcessedContractsPerMinute() {
        return this.processedContractsPerMinute.get(System.currentTimeMillis());
    }

    private class ContractEventListener
    implements EventListener<Event> {
        public final LinkedBlockingQueue<Integer> contractIdQueue = new LinkedBlockingQueue(10000);

        public ContractEventListener(int moduleId) throws BGException {
            EventProcessor ep = EventProcessor.getInstance();
            ep.addListener((EventListener)this, ContractTariffOptionChangedEvent.class);
            ep.addListener((EventListener)this, ContractStatusChangedTopicEvent.class);
            ep.addListener((EventListener)this, ContractStatusModifiedEvent.class);
            ep.addListener((EventListener)this, ContractModifiedEvent.class);
            ep.addListener((EventListener)this, ContractTariffChangedEvent.class);
            ep.addListener((EventListener)this, SystemLimitChangedEvent.class);
        }

        public void notify(Event e, EventListenerContext ctx) throws BGException {
            assert (e.getContractId() != 0);
            while (!this.contractIdQueue.add(e.getContractId()) && this.contractIdQueue.poll() != null) {
            }
        }
    }
}

