/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.tv.accounting.worker;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.tv.accounting.TvAccounting;
import ru.bitel.bgbilling.apps.tv.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.model.Pair;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

public class TvAccountTrackingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final TvAccounting accounting;
    private final Set<Integer> specIds;
    private Iterator<TvAccountRuntime> iterator;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final boolean deactivateProductsWithoutPrice;

    public TvAccountTrackingWorker(TvAccounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap params) {
        super(scheduledExecutorService, "", params);
        this.accounting = accounting;
        Set specIds = Utils.toIntegerSet((String)params.get("specIds", null));
        this.specIds = specIds == null || specIds.size() == 0 ? null : specIds;
        this.deactivateProductsWithoutPrice = params.getInt("deactivateProductsWithoutPrice", 0) > 0;
        logger.info("Add tvAccount tracking worker: delay=" + this.getDelay() + ", batchSize=" + this.batchSize + ", deactivateProductsWithoutPrice=" + this.deactivateProductsWithoutPrice);
    }

    protected void runImpl() throws BGException {
        logger.trace("Run account tracker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.accounting.tvAccountRuntimeMap.values().iterator();
        }
        EventProcessor ep = EventProcessor.getInstance();
        long millis = System.currentTimeMillis();
        Date now = new Date(millis);
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        TvDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        int count = 0;
        int size = this.batchSize;
        while (count < size && this.iterator.hasNext()) {
            TvAccountRuntime tvAccountRuntime = this.iterator.next();
            if (!TvAccountTrackingWorker.process(this.accounting, (ServerContext)this.context, connectionSet, ep, rootDeviceRuntime, tvAccountRuntime, now, millis, this.specIds, this.deactivateProductsWithoutPrice)) continue;
            ++count;
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug("Tracked " + count + " servs for " + duration + " ms.");
        }
    }

    public static boolean process(TvAccounting accounting, ServerContext context, ConnectionSet connectionSet, EventProcessor ep, TvAccountRuntime tvAccountRuntime, Date now, long millis) throws BGException {
        return TvAccountTrackingWorker.process(accounting, context, connectionSet, ep, null, tvAccountRuntime, now, millis, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean process(TvAccounting accounting, ServerContext context, ConnectionSet connectionSet, EventProcessor ep, TvDeviceRuntime rootDeviceRuntime, TvAccountRuntime tvAccountRuntime, Date now, long millis, Set<Integer> specIds, boolean deactivateProductsWithoutPrice) throws BGException {
        TvAccount tvAccount = tvAccountRuntime.getTvAccount();
        if (tvAccount.getParentId() > 0) {
            return false;
        }
        TvAccountRuntimeRoot tvAccountRuntimeRoot = (TvAccountRuntimeRoot)tvAccountRuntime;
        if (tvAccount.getDeviceState() != 1) {
            return false;
        }
        if (specIds != null && !specIds.contains(tvAccount.getSpecId())) {
            return false;
        }
        if (rootDeviceRuntime != null && tvAccount.getDeviceId() != rootDeviceRuntime.tvDeviceId.intValue() && !rootDeviceRuntime.descendantIds.contains(tvAccount.getDeviceId())) {
            return false;
        }
        if (!RangeUtils.inRange((long)millis, (long)millis, (long)tvAccountRuntime.getDateFromMillis(), (long)tvAccountRuntime.getDateToMillis())) {
            return false;
        }
        tvAccountRuntime.lock();
        try {
            tvAccount = tvAccountRuntime.getTvAccount();
            if (tvAccount.getDeviceState() != 1) {
                boolean bl = true;
                return bl;
            }
            Set<Integer> newOptions = accounting.tvAccountOptionSet(connectionSet, tvAccountRuntime, now);
            if (tvAccount.getDeviceOptionIds() == null && (newOptions == null || newOptions.size() == 0) || tvAccount.getDeviceOptionIds() != null && tvAccount.getDeviceOptionIds().equals(newOptions)) {
                if (deactivateProductsWithoutPrice) {
                    TvAccountTrackingWorker.deactivateProductsWithoutPrice(accounting, context, tvAccount, now);
                }
                boolean bl = true;
                return bl;
            }
            logger.info("Found options needs change to " + newOptions);
            TvAccountTrackingWorker.deactivateProductsWithoutPrice(accounting, context, tvAccount, now);
            tvAccountRuntimeRoot.processOptionsModified(null, accounting.moduleId, millis, newOptions);
        }
        finally {
            tvAccountRuntime.unlock();
        }
        return true;
    }

    private static void deactivateProductsWithoutPrice(TvAccounting accounting, ServerContext context, TvAccount tvAccount, Date now) throws BGException {
        ProductService productService = (ProductService)context.getService(ProductService.class, 0);
        ProductOrderService productOrderService = (ProductOrderService)context.getService(ProductOrderService.class, 0);
        List productList = productService.productList(accounting.moduleId, tvAccount.getContractId(), tvAccount.getId(), false, null, null, new Date(), null, false, false);
        if (productList.size() > 0) {
            List productOfferingList = productOrderService.productOfferingList(Integer.valueOf(accounting.moduleId), tvAccount.getContractId(), tvAccount.getId(), -1, new Date(), false, false);
            Map<Pair<Integer, Integer>, Pair<ProductOffering, ProductOfferingActivationMode>> productOfferingMap = TvUtils.getProductOfferingMap(productOfferingList);
            for (Product product : productList) {
                Pair<ProductOffering, ProductOfferingActivationMode> pair = productOfferingMap.get(new Pair((Object)product.getProductSpecId(), (Object)product.getActivationModeId()));
                if (pair != null && ((ProductOfferingActivationMode)pair.getSecond()).getPrice() != null) continue;
                logger.info("Found activated product " + product + " without price in tariff. Deactivating it.");
                productOrderService.productDeactivate(tvAccount.getContractId(), product.getId(), now, false, true, true);
            }
        }
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

