/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.task;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.tv.common.ProlongationType;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvTarifficationManager;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;

public class TvProlongationTask
extends TaskBase {
    private final Logger logger = LogManager.getLogger();

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c TV. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try {
            this.executeTaskImpl();
        }
        catch (BGException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTaskImpl() throws BGException {
        Date time = new Date();
        ServerContext context = (ServerContext)ServerContext.get();
        TvAccountDao tvAccountDao = new TvAccountDao(context.getConnection(), this.moduleId);
        ProductManager productManager = new ProductManager(context, this.moduleId);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(time);
        ((Calendar)calendar).add(1, -1);
        TvTariffContext tvTariffContext = new TvTariffContext(context.getConnectionSet(), this.moduleId, calendar.getTime(), TvTariffContext.TvTariffMode.scheduler);
        TvTariffWorkerContext tvTariffWorkerContext = new TvTariffWorkerContext(context, this.moduleId);
        TvTarifficationManager tvTarifficationManager = new TvTarifficationManager(context.getSetup(), context.getConnectionSet(), this.moduleId);
        TariffModuleTreeSetDao tariffModuleTreeSetDao = new TariffModuleTreeSetDao(context.getConnection());
        ContractRuntime contractRuntime = null;
        ConvergenceBalance convergenceBalance = null;
        BigDecimal balance = null;
        BigDecimal limit = null;
        for (TvAccount tvAccount : tvAccountDao.list(-1, null, null, null, true, "contractId, id")) {
            Date now = new Date();
            int contractId = tvAccount.getContractId();
            if (contractRuntime == null || contractRuntime.contractId != contractId) {
                contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(context.getConnectionSet(), Integer.valueOf(contractId));
                convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(context.getConnectionSet(), Integer.valueOf(contractId), now.getTime());
                if (contractRuntime == null) {
                    this.logger.error("ContractRuntime:" + tvAccount.getContractId() + " is null");
                    continue;
                }
                balance = convergenceBalance.getBalance();
                limit = convergenceBalance.getLimit();
            }
            TariffModuleTreeSet tariffTreeSet = tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractRuntime.contractId, calendar.getTime(), "tv", this.moduleId, 0, 0);
            tvTariffContext.getTvAccountRuntimeMap().load(context.getConnectionSet(), contractId);
            TvAccountRuntimeRoot tvAccountRuntime = (TvAccountRuntimeRoot)tvTariffContext.getTvAccountRuntimeMap().get(tvAccount.getId());
            contractRuntime.lock();
            try {
                balance = productManager.productsProlongate(tvTariffContext, tvTariffWorkerContext, tvTarifficationManager, contractRuntime, contractId, balance, limit, tariffTreeSet, tvTariffContext.getTvAccountRuntimeMap(), time, ProlongationType.scheduler);
            }
            finally {
                contractRuntime.unlock();
            }
            context.commit();
        }
        tariffModuleTreeSetDao.freeResources();
        productManager.recycle();
        tvAccountDao.close();
        tariffModuleTreeSetDao.close();
    }
}

