/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.event.access.manage;

import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;

@XmlRootElement
public class TvDeviceManageEvent
extends PartitionedQueueEvent {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final String operation;
    @XmlAttribute
    private final int accountId;
    @XmlAttribute
    private final int connectionId;
    private final Map<String, String> params;
    private Object result;
    private static final String packageName = TvDeviceManageEvent.class.getPackage().getName();

    protected TvDeviceManageEvent() {
        this.deviceId = -1;
        this.operation = null;
        this.accountId = -1;
        this.connectionId = -1;
        this.params = null;
    }

    public TvDeviceManageEvent(int moduleId, int userId, int deviceId, String operation, int accountId, int connectionId) {
        this(moduleId, userId, deviceId, operation, accountId, connectionId, null);
    }

    public TvDeviceManageEvent(int moduleId, int userId, int deviceId, String operation, int accountId, int connectionId, Map<String, String> params) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.deviceId = deviceId;
        this.operation = operation;
        this.accountId = accountId;
        this.connectionId = connectionId;
        this.params = params;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getOperation() {
        return this.operation;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
        sb.append("; operation: ");
        sb.append(this.operation);
    }

    protected String getPackageName() {
        return packageName;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }

    public Map<String, String> getParams() {
        if (this.params != null) {
            return this.params;
        }
        return Collections.emptyMap();
    }
}

