/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import bitel.billing.module.common.BGControlPanelDateNoB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.tv.client.TvDevicePanel;
import ru.bitel.bgbilling.modules.tv.client.contract.TvAccountForm;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.bgbilling.modules.tv.common.service.TvDeviceService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.systems.inventory.resource.common.DeviceManagerMethodType;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod;

public class TvAccountPanel
extends BGUPanel {
    protected TvAccountTreeTableModel model = new TvAccountTreeTableModel();
    private BGUTreeTable table;
    private TvAccountService tvService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
    private TvDeviceService deviceService = (TvDeviceService)((ClientContext)this.getContext()).getPort(TvDeviceService.class);
    private int oldMenuDeviceId = Integer.MIN_VALUE;
    private int oldMenuDeviceTypeId = Integer.MIN_VALUE;
    private List<JMenuItem> oldMenuItemList = new ArrayList<JMenuItem>();
    private JSeparator menuSeparator = new JSeparator();
    private TvDevice menuDevice;
    private TvAccount menuServ;
    private TvAccountForm tvAccountForm;
    private JPopupMenu popupMenu;
    private Action editDateItemAction;
    private Action deleteItemAction;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (TvAccountPanel.this.tvAccountForm.productPanel.isShowing()) {
                TvAccountPanel.this.tvAccountForm.productPanel.refresh.actionPerformed(e);
                return;
            }
            TvAccountPanel.this.model.setData(TvAccountPanel.this.tvService.tvAccountTree(((ClientContext)TvAccountPanel.this.getContext()).getContractId()));
            TvAccountPanel.this.table.expand();
        }
    };

    public TvAccountPanel() {
        super((LayoutManager)new BorderLayout());
        this.tvService = (TvAccountService)((ClientContext)this.getContext()).getPort(TvAccountService.class);
        this.deviceService = (TvDeviceService)((ClientContext)this.getContext()).getPort(TvDeviceService.class);
    }

    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)((Object)this));
        if (this.popupMenu == null) {
            this.editDateItemAction = new AbstractAction("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0430\u0442\u0443"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    List selectedAccounts = TvAccountPanel.this.model.getSelectedRows();
                    if (Utils.isEmptyCollection((Collection)selectedAccounts)) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        return;
                    }
                    new AccoutPeriodEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430", selectedAccounts).getDialog().setVisible(true);
                }
            };
            this.deleteItemAction = new AbstractAction("\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        TvAccountPanel.this.deleteAccount();
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            };
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.editDateItemAction);
            this.popupMenu.add(this.deleteItemAction);
            this.updateDeviceManagerMethodList(this.popupMenu);
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    int row = TvAccountPanel.this.table.rowAtPoint(event.getPoint());
                    if (SwingUtilities.isRightMouseButton(event) && IntStream.of(TvAccountPanel.this.table.getSelectedRows()).filter(a -> a > 0).anyMatch(a -> a == row)) {
                        TvAccountPanel.this.popupMenu.show((Component)TvAccountPanel.this.table, event.getX(), event.getY());
                    }
                }
            });
        }
    }

    private void deleteAccount() throws BGException {
        List selectedAccounts = this.model.getSelectedRows();
        if (Utils.isEmptyCollection((Collection)selectedAccounts)) {
            JOptionPane.showMessageDialog((Component)BGClient.getFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            return;
        }
        if (JOptionPane.showConfirmDialog((Component)BGClient.getFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", 0) == 0) {
            for (TvAccount account : selectedAccounts) {
                this.tvService.tvAccountDelete(account.getContractId(), account.getId(), false);
            }
            this.performAction("refresh");
        }
    }

    private void updateDeviceManagerMethodList(JPopupMenu popupMenu) {
        TvAccount tvAccount;
        this.menuServ = tvAccount = (TvAccount)this.model.getSelectedRow();
        if (tvAccount != null && tvAccount.getDeviceId() == this.oldMenuDeviceId) {
            return;
        }
        try {
            TvDevice tvDevice = this.menuDevice = tvAccount != null ? (TvDevice)this.deviceService.deviceGet(tvAccount.getDeviceId()) : null;
            if (this.menuDevice != null && this.menuDevice.getDeviceTypeId() == this.oldMenuDeviceTypeId) {
                return;
            }
            for (JMenuItem m : this.oldMenuItemList) {
                popupMenu.remove(m);
            }
            popupMenu.remove(this.menuSeparator);
            this.oldMenuItemList.clear();
            if (this.menuDevice == null) {
                this.oldMenuDeviceId = Integer.MIN_VALUE;
                this.oldMenuDeviceTypeId = Integer.MIN_VALUE;
                return;
            }
            this.oldMenuDeviceId = tvAccount.getDeviceId();
            this.oldMenuDeviceTypeId = this.menuDevice.getDeviceTypeId();
            List methodList = this.deviceService.deviceManagerMethodList(this.menuDevice.getDeviceTypeId());
            boolean separatorAdded = popupMenu.getComponentCount() == 0;
            for (final DeviceManagerMethod m : methodList) {
                if (!m.getTypes().contains(DeviceManagerMethodType.ACCOUNT)) continue;
                if (!separatorAdded) {
                    popupMenu.add(this.menuSeparator);
                    separatorAdded = true;
                }
                AbstractBGUPanel.DefaultAction action = new AbstractBGUPanel.DefaultAction("command." + m.getMethod(), m.getTitle(), ClientUtils.getIcon((String)"fugue/terminal-network")){

                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        try {
                            TvDevicePanel.executeCommand((ClientContext)TvAccountPanel.this.getContext(), TvAccountPanel.this.menuDevice.getId(), m.getMethod(), TvAccountPanel.this.menuServ.getId(), 0);
                        }
                        catch (BGException ex) {
                            ((ClientContext)TvAccountPanel.this.getContext()).processException((Throwable)ex);
                        }
                    }
                };
                JMenuItem menu = new JMenuItem((Action)action);
                popupMenu.add(menu);
                this.oldMenuItemList.add(menu);
            }
        }
        catch (BGException ex) {
            ((ClientContext)this.getContext()).processException((Throwable)ex);
        }
    }

    protected void jbInit() {
        this.table = new BGUTreeTable((BGTreeTableModel)this.model);
        BGEditor editor = new BGEditor("table");
        editor.addForm(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)this.table)), (Object)"table");
        this.tvAccountForm = new TvAccountForm(this);
        editor.addForm((JComponent)((Object)this.tvAccountForm));
        this.add((Component)editor, "Center");
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)editor);
    }

    class TvAccountTreeTableModel
    extends BGTreeTableModel<TvAccount> {
        private Icon folder2;
        private Icon folder;
        private Icon leaf;

        public TvAccountTreeTableModel() {
            super(TvAccountTreeTableModel.class.getName());
            this.folder2 = ClientUtils.getIcon((String)"fugue/home-network");
            this.folder = ClientUtils.getIcon((String)"fugue/card-address");
            this.leaf = ClientUtils.getIcon((String)"fugue/television");
        }

        public Icon getIcon(TvAccount value) {
            if (value == this.root) {
                return this.folder2;
            }
            if (value.getChildren() == null || value.getChildren().size() == 0) {
                return this.leaf;
            }
            return this.folder;
        }

        protected void initColumns() {
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", TvAccount.class, -1, -1, -1, "tvAccount", false);
            this.addColumn("\u0422\u0438\u043f", 180, 180, 180, "specTitle", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 160, 160, 160, "period", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 60, 80, 100, "status", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 100, 120, 180, "deviceState", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("ExtID", 40, 80, 180, "deviceAccountId", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 80, -1, -1, "comment", false).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        public Object getValue(TvAccount tvAccount, int column) throws BGException {
            if (tvAccount == this.root && column != 0) {
                return "";
            }
            String identifier = this.getIdentifier(column);
            if ("tvAccount".equals(identifier)) {
                return tvAccount;
            }
            if ("period".equals(identifier)) {
                return TimeUtils.formatPeriod((Date)tvAccount.getDateFrom(), (Date)tvAccount.getDateTo());
            }
            if ("status".equals(identifier)) {
                if (tvAccount.getParentId() > 0) {
                    return "";
                }
                switch (tvAccount.getStatus()) {
                    case 0: {
                        return "\u043e\u0442\u043a\u0440\u044b\u0442";
                    }
                    case 1: {
                        return "\u0437\u0430\u043a\u0440\u044b\u0442";
                    }
                    case 2: {
                        return "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d";
                    }
                }
                return "---";
            }
            if ("deviceState".equals(identifier)) {
                switch (tvAccount.getDeviceState()) {
                    case -1: {
                        return "\u0443\u0434\u0430\u043b\u0435\u043d";
                    }
                    case 1: {
                        return "\u0432\u043a\u043b\u044e\u0447\u0435\u043d";
                    }
                    case 0: {
                        return "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
                    }
                }
                return "---";
            }
            return super.getValue((Object)tvAccount, column);
        }
    }

    class AccoutPeriodEditorDialog
    extends BGEditorDialog<List<TvAccount>> {
        public BGControlPanelDateNoB fromDate;
        public BGControlPanelDateNoB toDate;

        public AccoutPeriodEditorDialog(String title, List<TvAccount> data) {
            super(title, data);
            this.fromDate = new BGControlPanelDateNoB();
            this.toDate = new BGControlPanelDateNoB();
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.fromDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 5), 0, 0));
            this.panel.add((Component)this.toDate, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 5), 0, 0));
        }

        public boolean doApply() throws Exception {
            Date dateFrom = this.fromDate.getDate();
            Date dateTo = this.toDate.getDate();
            if (dateFrom != null && dateTo != null && dateFrom.after(dateTo)) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f");
                return false;
            }
            for (TvAccount account : (List)this.data) {
                account.setDateFrom(dateFrom);
                if (dateTo != null) {
                    account.setDateTo(dateTo);
                }
                try {
                    TvAccountPanel.this.tvService.tvAccountUpdate(account.getContractId(), account, true, true, 0L);
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            TvAccountPanel.this.performAction("refresh");
            return true;
        }
    }
}

