/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.event.worker.YoomoneyCheckEventWorker;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.yoomoney.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        new YoomoneyCheckEventWorker(Setup.getSetup(), module.getId());
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            if (!cdEvent.isCheck()) {
                String cidStr = String.valueOf(event.getContractId());
                ServerUtils.deleteRowsFromTable((Connection)serverContext.getConnection(), (String)("yoomoney_transactions_" + moduleId), (String)"cid", (String)cidStr, null);
            }
        } else if (event instanceof PaymentEvent) {
            PaymentEvent paymentEvent = (PaymentEvent)event;
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
            int chargeTypeId = moduleSetup.getInt("yoomoney.commission.charge.type.id", 0);
            if (moduleSetup.getBoolean("yoomoney.commission.charge.enable", false) && chargeTypeId > 0) {
                Payment payment = paymentEvent.getPayment();
                int paymentId = payment.getId();
                try (Connection con = serverContext.getConnection();
                     ChargeDao chargeDao = new ChargeDao(con);
                     BalanceUtils balanceUtils = new BalanceUtils(con);
                     TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                    Transaction transaction = transactionManager.getTransactionByPaymentId(paymentId);
                    if (transaction != null) {
                        JSONObject json = new JSONObject(transaction.getRawRequest());
                        Object amountValue = json.optQuery("/amount/value");
                        Object incomeAmountValue = json.optQuery("/income_amount/value");
                        if (amountValue != null && incomeAmountValue != null) {
                            BigDecimal sum = new BigDecimal(String.valueOf(amountValue)).subtract(new BigDecimal(String.valueOf(incomeAmountValue)));
                            Charge charge = new Charge();
                            charge.setContractId(payment.getContractId());
                            charge.setDate(new Date());
                            charge.setTypeId(chargeTypeId);
                            charge.setSum(sum);
                            charge.setComment("\u041a\u043e\u043c\u043c\u0438c\u0441\u0438\u044f \u0437\u0430 \u043f\u043b\u0430\u0442\u0435\u0436 (#" + payment.getId() + ")");
                            charge.setUserId(0);
                            chargeDao.update((Object)charge);
                            balanceUtils.updateBalance(charge.getDate(), charge.getContractId());
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
    }

    public boolean isPaymentModule() {
        return true;
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        return Arrays.asList(PaymentMethod.CARD);
    }
}

