/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.assist.server.action.web;

import bitel.billing.server.ActionBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistPaymentRecurring;
import ru.bitel.bgbilling.modules.assist.common.bean.AssistStatus;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistPaymentRecurringManager;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistShopMode;
import ru.bitel.bgbilling.modules.assist.server.bean.AssistUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;

public class ActionPay
extends ActionBase {
    private static final String ACTION_TEST_URL = "https://test.paysecure.ru/pay/order.cfm";
    private static final String ACTION_URL = "https://payments.paysecure.ru/pay/order.cfm";

    public void doAction() throws SQLException, BGException {
        if (this.cid <= 0 && this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        String command = this.getParameter("command");
        if ("deleterecurring".equals(command)) {
            this.doDeleteRecurringAction();
            return;
        }
        BigDecimal summ = this.getBigDecimalParameter("summ", BigDecimal.ZERO);
        String Merchant_ID = this.moduleSetup.get("assist.Merchant_ID", null);
        Object path = this.moduleSetup.get("assist.path", null);
        String shopModeP = this.moduleSetup.get("assist.ShopMode", "test");
        String actionUrl = this.moduleSetup.get("assist.actionUrl", null);
        if (Utils.isBlankString((String)Merchant_ID) || Utils.isBlankString((String)path)) {
            throw new BGException("error assist config");
        }
        if (!((String)path).endsWith("webexecuter")) {
            path = (String)path + "webexecuter";
            log.error("warning! parameter 'assist.path' \u2014 FULL path to webexecuter ('http://provider/bgbilling/webexecuter')");
        }
        AssistShopMode shopMode = null;
        try {
            shopMode = AssistShopMode.valueOf(shopModeP);
        }
        catch (Exception e) {
            throw new BGException("error parameter assist.ShopMode");
        }
        BigDecimal RecurringMinAmount = this.moduleSetup.getBigDecimal("assist.RecurringMinAmount", null);
        BigDecimal RecurringMaxAmount = this.moduleSetup.getBigDecimal("assist.RecurringMaxAmount", null);
        int RecurringPeriod = this.moduleSetup.getInt("assist.RecurringPeriod", -1);
        boolean RecurringAllowed = RecurringMinAmount != null && RecurringMaxAmount != null && RecurringPeriod != -1;
        AssistPaymentRecurringManager prm = new AssistPaymentRecurringManager(this.con, this.mid);
        AssistPaymentRecurring recurringAlreadyHas = prm.getRecurringForCid(this.cid);
        if (recurringAlreadyHas != null) {
            RecurringAllowed = false;
        }
        String urlOk = this.getParameter("url_ok");
        String urlNo = this.getParameter("url_no");
        if (summ.compareTo(BigDecimal.ZERO) > 0) {
            AssistPaymentManager pm = new AssistPaymentManager(this.con, this.mid);
            int id = pm.addPayment(this.cid, summ, 0);
            Element pay = this.createElement(this.rootNode, "pay");
            XMLUtils.setAttribute((Element)pay, (String)"ACTION_URL", (String)(actionUrl != null ? actionUrl : (shopMode == AssistShopMode.test ? ACTION_TEST_URL : ACTION_URL)));
            XMLUtils.setAttribute((Element)pay, (String)"Merchant_ID", (String)Merchant_ID);
            XMLUtils.setAttribute((Element)pay, (String)"OrderNumber", (String)String.valueOf(id));
            XMLUtils.setAttribute((Element)pay, (String)"OrderAmount", (String)summ.toPlainString());
            XMLUtils.setAttribute((Element)pay, (String)"OrderComment", (String)AssistUtils.getPaymentDesc(this.con, this.moduleSetup.get("assist.OrderComment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433. ${contract} (${contract_comment})"), this.cid));
            XMLUtils.setAttribute((Element)pay, (String)"URL_RETURN_OK", (String)(urlOk == null ? (String)path + "?action=PayList&mid=" + this.mid + "&module=" + this.module + "&result=" + AssistStatus.OK : urlOk));
            XMLUtils.setAttribute((Element)pay, (String)"URL_RETURN_NO", (String)(urlNo == null ? (String)path + "?action=PayList&mid=" + this.mid + "&module=" + this.module + "&result=" + AssistStatus.FAIL : urlNo));
            int mobilePhoneParamId = this.moduleSetup.getInt("assist.MobilePhone.param.id", 0);
            if (mobilePhoneParamId > 0) {
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    List phones;
                    EntityAttr entityAttr = contractDao.getContractParameter(this.cid, mobilePhoneParamId);
                    if (entityAttr instanceof EntityAttrPhone && (phones = ((EntityAttrPhone)entityAttr).getUnformattedPhoneList()) != null && !phones.isEmpty()) {
                        XMLUtils.setAttribute((Element)pay, (String)"MobilePhone", (String)((String)phones.get(0)));
                    }
                }
            }
            XMLUtils.setAttribute((Element)pay, (String)"Delay", (String)this.moduleSetup.get("assist.Delay", null));
            XMLUtils.setAttribute((Element)pay, (String)"CardPayment", (String)this.moduleSetup.get("assist.CardPayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"WMPayment", (String)this.moduleSetup.get("assist.WMPayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"YMPayment", (String)this.moduleSetup.get("assist.YMPayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"QIWIPayment", (String)this.moduleSetup.get("assist.QIWIPayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"QIWIMtsPayment", (String)this.moduleSetup.get("assist.QIWIMtsPayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"QIWIMegafonPayment", (String)this.moduleSetup.get("assist.QIWIMegafonPayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"QIWIBeelinePayment", (String)this.moduleSetup.get("assist.QIWIBeelinePayment", null));
            XMLUtils.setAttribute((Element)pay, (String)"AssistIDPayment", (String)this.moduleSetup.get("assist.AssistIDPayment", null));
            if (shopMode == AssistShopMode.battletest || shopMode == AssistShopMode.test) {
                XMLUtils.setAttribute((Element)pay, (String)"TestMode", (String)"1");
            }
            XMLUtils.setAttribute((Element)pay, (String)"RecurringIndicator", (String)"0");
            if (RecurringAllowed) {
                boolean recurringCheckbox = this.getBooleanParameter("recurring", false);
                String RecurringMaxDate = this.getParameter("recurringmaxdate", null);
                Date dRecurringMaxDate = TimeUtils.parseDate((String)RecurringMaxDate, (String)"dd.MM.yyyy");
                if (dRecurringMaxDate == null) {
                    dRecurringMaxDate = new Date(0L);
                }
                if (recurringCheckbox) {
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringIndicator", (String)"1");
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringMinAmount", (String)RecurringMinAmount.toPlainString());
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringMaxAmount", (String)RecurringMaxAmount.toPlainString());
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringPeriod", (String)String.valueOf(RecurringPeriod));
                    XMLUtils.setAttribute((Element)pay, (String)"RecurringMaxDate", (String)RecurringMaxDate);
                    AssistPaymentRecurring pr = new AssistPaymentRecurring();
                    pr.setCid(this.cid);
                    pr.setDate(new Date());
                    pr.setAmount(summ);
                    pr.setOrdernumber(id);
                    pr.setRecurringMinAmount(RecurringMinAmount);
                    pr.setRecurringMaxAmount(RecurringMaxAmount);
                    pr.setRecurringPeriod(RecurringPeriod);
                    pr.setRecurringMaxDate(dRecurringMaxDate);
                    prm.add(pr);
                }
            }
        } else {
            BalanceUtils bu = new BalanceUtils(this.con);
            BigDecimal balance = bu.getBalance(new Date(), this.cid);
            Element balanceEl = this.createElement(this.rootNode, "balance");
            balanceEl.setAttribute("balance", balance.toPlainString());
            bu.close();
            XMLUtils.setAttribute((Element)balanceEl, (String)"RecurringAllowed", (String)(RecurringAllowed ? "1" : "0"));
            XMLUtils.setAttribute((Element)balanceEl, (String)"defaultrecurringmaxdate", (String)TimeUtils.formatDate((Date)TimeUtils.nowPlusPeriod((int)2, (int)6)));
        }
    }

    private void doDeleteRecurringAction() throws BGException {
        AssistPaymentRecurringManager prm = new AssistPaymentRecurringManager(this.con, this.mid);
        prm.deleteRecurringForCid(this.cid);
        try {
            this.response.sendRedirect("webexecuter?action=PayList&mid=" + this.mid + "&module=" + this.module);
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }
}

