/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class BotDialogElementDao
extends AbstractIdDao<BotDialogElement> {
    public BotDialogElementDao(Connection connection, int moduleId) {
        this(connection, moduleId, "bot_dialog_elements");
    }

    private BotDialogElementDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public BotDialogElement getElement(int id) throws BGException {
        BotDialogElement element;
        String query = "SELECT * FROM " + this.tableName + " WHERE id=" + id;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            element = this.getFromRS(rs);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return element;
    }

    public List<BotDialogElement> getElements() throws BGException {
        return super.list(null, "sort", new Object[0]);
    }

    public List<BotDialogElement> getElementsByIds(String ids) throws BGException {
        ArrayList<BotDialogElement> result = new ArrayList<BotDialogElement>();
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN(" + ids + ") order by id";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        List idsList = Utils.toIntegerList((String)ids);
        result.sort(Comparator.comparingInt(el -> idsList.indexOf(el.getId())));
        return result;
    }

    public List<BotDialogElement> getElementsByIds(List<Integer> ids) throws BGException {
        return this.getElementsByIds(Utils.toString(ids, (String)","));
    }

    public List<BotDialogElement> getElementsOfDialog(int dialogId) throws BGException {
        ArrayList<BotDialogElement> elements = new ArrayList<BotDialogElement>();
        String query = "SELECT * FROM " + this.tableName + " WHERE dialog_ids LIKE '" + dialogId + "'";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                elements.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return elements;
    }

    protected BotDialogElement getFromRS(ResultSet rs) throws SQLException {
        BotDialogElement element = new BotDialogElement();
        element.setId(rs.getInt("id"));
        element.setElementType(BotDialogElementType.getElementType((int)rs.getInt("element_type")));
        element.setDialogIds(Utils.toIntegerSet((String)rs.getString("dialog_ids")));
        element.setConfigElement(rs.getString("config"));
        element.setSortPosition(rs.getInt("sort"));
        return element;
    }

    protected void updateImpl(BotDialogElement dialogElement) throws BGException, SQLException {
        this.updateElement(dialogElement);
    }

    public int updateElement(BotDialogElement element) throws BGException {
        int insertId = 0;
        String set = " SET dialog_ids=?, element_type=?, config=?, sort=?";
        String query = element.getId() > 0 ? "UPDATE " + this.tableName + set + " WHERE id=?" : "INSERT INTO " + this.tableName + set;
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, Utils.toString((Iterable)element.getDialogIds(), (String)","));
            ps.setInt(index++, element.getElementType().ordinal());
            ps.setString(index++, element.getConfigElement());
            ps.setInt(index++, element.getSortPosition());
            if (element.getId() > 0) {
                ps.setInt(index, element.getId());
            }
            ps.executeUpdate();
            if (element.getId() <= 0) {
                insertId = ServerUtils.lastInsertId((PreparedStatement)ps);
                element.setId(insertId);
                int newSortPosition = this.updateSortPosition(insertId);
                element.setSortPosition(newSortPosition);
            } else {
                insertId = element.getId();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return insertId;
    }

    private int updateSortPosition(int elementId) throws SQLException {
        int newSortPosition = 0;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery("select MAX(sort) as sort from " + this.tableName);){
            if (rs.next()) {
                newSortPosition = rs.getInt("sort");
            }
        }
        st = this.con.createStatement();
        try {
            st.executeUpdate("update " + this.tableName + " set sort=" + newSortPosition + " where id=" + elementId);
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
        return newSortPosition;
    }

    public synchronized void updateSortingElements(Map<Integer, Integer> elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        Setup setup = Setup.getSetup();
        Connection connection = setup.getDBConnectionFromPool();
        new Thread(() -> {
            try (Statement statement = connection.createStatement();){
                for (Integer key : elements.keySet()) {
                    String update = "UPDATE " + this.tableName + " SET sort=" + elements.get(key) + " WHERE id=" + key;
                    statement.addBatch(update);
                }
                statement.executeBatch();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }).start();
    }
}

