/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.task;

import java.sql.Connection;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyManager;
import ru.bitel.bgbilling.modules.buyemoney.server.bean.BuyemoneyPayment;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolCurrency;
import ru.bitel.bgbilling.modules.buyemoney.server.protocols.ProtocolManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class SendRegistry
extends TaskBase {
    private int mid;

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c BuyEmoney. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u043e\u0441\u044b\u043b\u043a\u0438 \u0435\u0436\u0435\u0441\u0443\u0442\u043e\u0447\u043d\u043e \u0440\u0435\u0435\u0441\u0442\u0440\u0430 \u043f\u0440\u0438\u043d\u044f\u0442\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.mid + ".";
    }

    protected boolean initTask() {
        this.mid = this.taskSetup.getInt("mid", -1);
        if (this.mid < 0) {
            this.log.error("Param mid not found!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            ModuleSetup moduleSetup = this.setup.getModuleSetup(Integer.valueOf(this.mid));
            ProtocolManager protocolManager = new ProtocolManager((ParameterMap)moduleSetup, this.log);
            BuyemoneyManager manager = new BuyemoneyManager(con, this.mid);
            Calendar end = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)Calendar.getInstance());
            Calendar begin = TimeUtils.getPrevDay((Calendar)end);
            Map<Integer, List<BuyemoneyPayment>> paymentMap = manager.getProtocolPaymentMap(begin.getTime(), end.getTime(), null);
            for (Map.Entry<Integer, ProtocolCurrency> entry : protocolManager.getProtocols().entrySet()) {
                int protocolId = entry.getKey();
                ProtocolCurrency protocolCurrency = entry.getValue();
                List<BuyemoneyPayment> paymentsOfProtocol = paymentMap.get(protocolId);
                protocolCurrency.sendRegistry(paymentsOfProtocol, begin.getTime(), (Preferences)this.setup);
            }
        }
        catch (Exception e) {
            this.log.error("error execute task", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

