/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.utils;

import java.io.File;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class FrkUtils {
    static final String PATH_ROOT_DRIVER = "ru/bitel/bgbilling/apps/cashcheck/frk/driver/";

    public static int parseInt(String val) throws DriverException {
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new DriverException("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + val + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
    }

    public static long parseLong(String val) throws DriverException {
        try {
            return Long.parseLong(val);
        }
        catch (Exception e) {
            throw new DriverException("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + val + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
    }

    public static BigDecimal parseBigDecimal(String val) throws DriverException {
        try {
            return new BigDecimal(val);
        }
        catch (Exception e) {
            throw new DriverException("\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + val + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c");
        }
    }

    public static boolean testBit(byte b, int n) {
        return (b & 1 << n) != 0;
    }

    public static boolean testBit(int b, int n) {
        return (b & 1 << n) != 0;
    }

    public static byte makeByte(int bit7, int bit6, int bit5, int bit4, int bit3, int bit2, int bit1, int bit0) {
        return (byte)(128 * bit7 + 64 * bit6 + 32 * bit5 + 16 * bit4 + 8 * bit3 + 4 * bit2 + 2 * bit1 + bit0);
    }

    public static final String fn(int num, int width) {
        StringBuffer sb = new StringBuffer(width);
        String num_s = String.valueOf(num);
        for (int i = num_s.length(); i < width; ++i) {
            sb.append("0");
        }
        sb.append(num_s);
        return sb.toString();
    }

    public static final String spaces(int width) {
        StringBuffer sb = new StringBuffer(width);
        for (int i = 0; i < width; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String formatMDE(long total) {
        StringBuilder sb = new StringBuilder();
        sb.append(total / 100L).append(" \u0440\u0443\u0431. ");
        sb.append(total % 100L > 9L ? "" : "0");
        sb.append(total % 100L).append(" \u043a\u043e\u043f.");
        return sb.toString();
    }

    public static Set<Class<?>> driversTouch() {
        HashSet classes = new HashSet();
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urls = ClassLoader.getSystemResources(PATH_ROOT_DRIVER);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try (URLClassLoader classLoader = new URLClassLoader(new URL[]{url}, contextClassLoader);){
                    if ("file".equals(url.getProtocol())) {
                        try {
                            File[] driverFolders;
                            File f = new File(url.toURI());
                            for (File driverFolder : driverFolders = f.listFiles()) {
                                File[] driverFiles;
                                if (!driverFolder.exists() || !driverFolder.isDirectory()) continue;
                                for (File driverFile : driverFiles = driverFolder.listFiles()) {
                                    if (!driverFile.exists() || !driverFile.isFile() || !driverFile.getCanonicalPath().endsWith(".class")) continue;
                                    String classSubPath = driverFile.getCanonicalPath().substring(driverFile.getCanonicalPath().indexOf(PATH_ROOT_DRIVER));
                                    classSubPath = classSubPath.replace('/', '.');
                                    classSubPath = classSubPath.substring(0, classSubPath.length() - 6);
                                    Class<?> c = classLoader.loadClass(classSubPath);
                                    classes.add(c);
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                    }
                    if (!"jar".equals(url.getProtocol())) continue;
                    String jarName = url.getFile().substring(5, url.getFile().indexOf(PATH_ROOT_DRIVER) - 2);
                    try (JarFile jarFile = new JarFile(jarName);){
                        Enumeration<JarEntry> enum1 = jarFile.entries();
                        while (enum1.hasMoreElements()) {
                            JarEntry entry = enum1.nextElement();
                            if (!entry.getName().startsWith(PATH_ROOT_DRIVER) || !entry.getName().endsWith(".class")) continue;
                            String classSubPath = entry.getName().replace('/', '.');
                            classSubPath = classSubPath.substring(0, classSubPath.length() - 6);
                            Class<?> c = classLoader.loadClass(classSubPath);
                            classes.add(c);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static String getUpTime(long _startTime) {
        StringBuilder report = new StringBuilder(100);
        report.append("started: ");
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        report.append(format.format(_startTime));
        report.append(",\t");
        long delta = (System.currentTimeMillis() - _startTime) / 1000L;
        int days = (int)(delta / 86400L);
        int hours = (int)((delta -= (long)(days * 86400)) / 3600L);
        int min = (int)((delta -= (long)(hours * 3600)) / 60L);
        int sec = (int)(delta -= (long)(min * 60));
        DecimalFormat dfTime = new DecimalFormat("00");
        report.append("uptime: ");
        if (days > 0) {
            report.append(days);
            report.append(" d ");
        }
        report.append(dfTime.format(hours));
        report.append(":");
        report.append(dfTime.format(min));
        report.append(":");
        report.append(dfTime.format(sec));
        return report.toString();
    }

    public static final String getMemoryStatus() {
        StringBuilder report = new StringBuilder(50);
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);
        Runtime r = Runtime.getRuntime();
        report.append("memory total: ");
        report.append(df.format(r.totalMemory()));
        report.append(",\tmax: ");
        report.append(df.format(r.maxMemory()));
        report.append(",\tfree: ");
        report.append(df.format(r.freeMemory()));
        return report.toString();
    }

    public static String getExceptionMessage(Throwable t, Class<?>[] noIncludeClassnameExceptions) {
        Object message;
        boolean includeClassname = true;
        if (noIncludeClassnameExceptions != null) {
            for (Class<?> noIncludeClassnameException : noIncludeClassnameExceptions) {
                if (!noIncludeClassnameException.isInstance(t)) continue;
                includeClassname = false;
            }
        }
        Object object = includeClassname ? t.toString() : (message = t.getMessage() != null ? t.getMessage() : t.getClass().getSimpleName());
        if (t.getCause() != null && t.getCause() != t) {
            message = (String)message + " <= " + FrkUtils.getExceptionMessage(t.getCause(), noIncludeClassnameExceptions);
        }
        return message;
    }

    public static String serializeToString(Document xml) {
        StringWriter writer = new StringWriter();
        FrkUtils.serialize(xml, new StreamResult(writer), "UTF-8", true);
        return writer.toString();
    }

    public static void serialize(Node node, Result result, String encoding, boolean indent) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            if (indent) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(node), result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void _CUSTOMTAG_decode(String t, Map<Integer, Object> customTags) throws DriverException {
        String[] tv = t.split(";");
        if (tv.length == 2) {
            int tag = FrkUtils.parseInt(tv[0]);
            String svtag = tv[1];
            if (svtag.startsWith("\"0x")) {
                svtag = svtag.substring(3, svtag.length() - 1);
                byte[] value = FrkUtils.stringToBytes(svtag, "");
                customTags.put(tag, value);
            } else if (svtag.startsWith("\"")) {
                svtag = svtag.substring(1, svtag.length() - 1);
                customTags.put(tag, svtag);
            } else if (svtag.startsWith("{")) {
                customTags.put(tag, Check.STAG.fromJson((String)svtag));
            } else {
                customTags.put(tag, FrkUtils.parseLong(svtag));
            }
        }
    }

    protected static BigDecimal _roundSum(BigDecimal summa) {
        summa = summa.setScale(2, RoundingMode.HALF_UP);
        return summa;
    }

    public static CommandCheckParameters processCommandCheckParameters(String[] parameters, Logger logger) throws DriverException {
        CommandCheckParameters commandCheckParameters = new CommandCheckParameters();
        BigDecimal summa = BigDecimal.valueOf(0L, 2);
        for (int i = 2; i < parameters.length; i += 3) {
            String s = parameters[i];
            String t = parameters[i + 1];
            String d = parameters[i + 2];
            if ("STRING".equals(s)) {
                commandCheckParameters.lines.add(new Check.CheckLine(null, t, -1));
                if (logger == null) continue;
                logger.debug("Driver: TEXT: " + t);
                continue;
            }
            if ("CUSTOMEREMAIL".equals(s)) {
                commandCheckParameters.customerEmail = t;
                if (logger == null) continue;
                logger.debug("Driver: CUSTOMER EMAIL: " + t);
                continue;
            }
            if ("TAX".equals(s)) {
                commandCheckParameters.tax = FrkUtils.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: TAX: " + t);
                continue;
            }
            if ("PAYMENTTYPE".equals(s)) {
                commandCheckParameters.paymentType = FrkUtils.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: PAYMENT TYPE: " + t);
                continue;
            }
            if ("ONLYELCHECK".equals(s)) {
                commandCheckParameters.onlyElCheck = Utils.parseBoolean((String)t, (boolean)false);
                if (logger == null) continue;
                logger.debug("Driver: ONLYELCHECK: " + t);
                continue;
            }
            if ("CUSTOMTAG".equals(s)) {
                FrkUtils._CUSTOMTAG_decode(t, commandCheckParameters.customTags);
                if (logger == null) continue;
                logger.debug("Driver: CUSTOMTAG: " + t);
                continue;
            }
            if ("PAYMETHOD".equals(s)) {
                commandCheckParameters.payMethod = FrkUtils.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: PAY METHOD: " + t);
                continue;
            }
            if ("PAYOBJECT".equals(s)) {
                commandCheckParameters.payObject = FrkUtils.parseInt(t);
                if (logger == null) continue;
                logger.debug("Driver: PAY OBJECT: " + t);
                continue;
            }
            if ("CHECKTYPE".equals(s)) {
                commandCheckParameters.checkType = Check.Type.valueOf((String)t);
                if (logger == null) continue;
                logger.debug("Driver: CHECK TYPE: " + t);
                continue;
            }
            if ("CASHIERNAME".equals(s)) {
                commandCheckParameters.cashierName = t;
                if (logger == null) continue;
                logger.debug("Driver: CASHIER NAME: " + t);
                continue;
            }
            if ("CASHIERINN".equals(s)) {
                commandCheckParameters.cashierINN = t;
                if (logger == null) continue;
                logger.debug("Driver: CASHIER INN: " + t);
                continue;
            }
            if ("DOCUMENTDATE".equals(s)) {
                commandCheckParameters.documentDate = TimeUtils.parseDate((String)t, (String)"dd.MM.yyyy HH:mm:ss");
                if (logger == null) continue;
                logger.debug("Driver: DOCUMENT DATE: " + t);
                continue;
            }
            if ("DOCUMENTID".equals(s)) {
                commandCheckParameters.documentId = t;
                if (logger == null) continue;
                logger.debug("Driver: DOCUMENT ID: " + t);
                continue;
            }
            if ("PAYMETHOD_ITEM".equals(s)) {
                int PAYMETHOD_value = FrkUtils.parseInt(t);
                if (logger != null) {
                    logger.debug("Driver: PAYMETHOD_ITEM: " + PAYMETHOD_value);
                }
                commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).payMethod = PAYMETHOD_value;
                continue;
            }
            if ("PAYOBJECT_ITEM".equals(s)) {
                int PAYOBJECT_value = FrkUtils.parseInt(t);
                if (logger != null) {
                    logger.debug("Driver: PAYOBJECT_ITEM: " + PAYOBJECT_value);
                }
                commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).payObject = PAYOBJECT_value;
                continue;
            }
            if ("TAX_ITEM".equals(s)) {
                int TAX_value = FrkUtils.parseInt(t);
                if (logger != null) {
                    logger.debug("Driver: TAX_ITEM: " + TAX_value);
                }
                commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).tax = TAX_value;
                continue;
            }
            if ("CUSTOMTAG_ITEM".equals(s)) {
                if (logger != null) {
                    logger.debug("Driver: CUSTOMTAG_ITEM: " + t);
                }
                FrkUtils._CUSTOMTAG_decode(t, commandCheckParameters.lines.get((int)(commandCheckParameters.lines.size() - 1)).customTags);
                continue;
            }
            if (!d.isEmpty()) {
                BigDecimal sum = FrkUtils.parseBigDecimal(s);
                sum = FrkUtils._roundSum(sum);
                int dep = FrkUtils.parseInt(d);
                commandCheckParameters.lines.add(new Check.CheckLine(sum, t, dep));
                if (logger != null) {
                    logger.debug("Driver: SALE: sum=" + s + ";txt=" + t + ";dep=" + dep);
                }
                summa = summa.add(sum);
                continue;
            }
            if (logger == null) continue;
            logger.error("Driver: UNKNOWN TAG: " + s + "|" + t + "|" + d);
        }
        commandCheckParameters.paymentsum = summa;
        return commandCheckParameters;
    }

    public static void main(String[] args) throws Exception {
        String[] parameters = new String[]{"p", "p", "1.23", "test1", "1", "4.56", "test2", "2"};
        CommandCheckParameters ccp = FrkUtils.processCommandCheckParameters(parameters, null);
        System.out.println();
        for (Check.CheckLine line : ccp.lines) {
            System.out.println(line);
        }
    }

    public static byte[] hexStringToBytes(String value) {
        return FrkUtils.stringToBytes(value, " ");
    }

    public static byte[] stringToBytes(String s, String delimeter) {
        byte[] result;
        int i;
        int j;
        StringTokenizer st;
        int size;
        if (s == null) {
            return null;
        }
        if (delimeter != null && delimeter.length() > 0 && (size = (st = new StringTokenizer(s, delimeter)).countTokens()) > 1) {
            byte[] result2 = new byte[size];
            int pos = 0;
            try {
                while (st.hasMoreTokens()) {
                    result2[pos++] = (byte)Integer.parseInt(st.nextToken().trim(), 16);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return result2;
        }
        int size2 = s.length();
        if (size2 % 2 == 0) {
            j = 0;
            i = 0;
            result = new byte[size2 / 2];
        } else {
            j = 1;
            i = 1;
            result = new byte[size2 / 2 + 1];
            result[0] = (byte)Character.digit(s.charAt(0), 16);
        }
        while (i < size2) {
            int digit1 = Character.digit(s.charAt(i++), 16);
            int digit2 = Character.digit(s.charAt(i++), 16);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    public static String formatDate(LocalDate date) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        return date.format(formatter);
    }

    public static String formatDateTime(LocalDateTime datetime) {
        if (datetime == null) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
        return datetime.format(formatter);
    }

    public static class CommandCheckParameters {
        public BigDecimal paymentsum = null;
        public List<Check.CheckLine> lines = new ArrayList<Check.CheckLine>();
        public String customerEmail = null;
        public Integer paymentType = null;
        public Integer tax = null;
        public boolean onlyElCheck = false;
        public Map<Integer, Object> customTags = new HashMap<Integer, Object>();
        public Integer payMethod = null;
        public Integer payObject = null;
        public Check.Type checkType = null;
        public String cashierName = null;
        public String cashierINN = null;
        public Date documentDate = null;
        public String documentId = null;
    }
}

