/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.griffin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class GriffinConnection {
    private String host;
    private int port;
    private String username;
    private String password;
    private String pwdroot;
    private int cardcount;
    private FTPClient ftp = null;

    public GriffinConnection(ParameterMap preferences, int serverId) throws IOException {
        this.host = preferences.get("host", null);
        this.port = preferences.getInt("port", 21);
        this.username = preferences.get("username", "anonymous");
        this.password = preferences.get("password", "");
        this.pwdroot = preferences.get("pwdroot", ".");
        if (Utils.isEmptyString((String)this.host) || this.port <= 0) {
            throw new IOException("Host or port for server " + serverId + " undefined!");
        }
        this.cardcount = preferences.getInt("cardcount", -1);
        if (this.cardcount <= 0) {
            throw new IOException("\u0421ardcount undefined!");
        }
    }

    public void connect() throws IOException {
        this.ftp = new FTPClient();
        this.ftp.connect(this.host, this.port);
        int reply = this.ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            this.ftp.disconnect();
            throw new IOException("FTP server refused connection.");
        }
        if (!this.ftp.login(this.username, this.password)) {
            this.ftp.disconnect();
            throw new IOException("FTP server login attempt failed.");
        }
        if (!this.ftp.changeWorkingDirectory(this.pwdroot)) {
            String rs = this.ftp.getReplyString().trim();
            this.ftp.logout();
            this.ftp.disconnect();
            throw new IOException("FTP server change working directory '" + this.pwdroot + "' failed (" + rs + ").");
        }
        this.ftp.setFileType(2);
    }

    public void disconnect() {
        if (this.ftp != null) {
            try {
                this.ftp.logout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ftp.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void postrequest(int server, Map<Integer, List<Integer>> cardpackets) throws IOException {
        for (Integer card : cardpackets.keySet()) {
            if (card <= this.cardcount) continue;
            throw new IOException("Card number " + card + " is more than a specified card count " + this.cardcount);
        }
        byte[] buffer = new byte[this.cardcount * 2];
        for (int card = 1; card <= this.cardcount; ++card) {
            int packetmask = 0;
            List<Integer> packets = cardpackets.get(card);
            if (packets != null) {
                for (Integer packet : packets) {
                    if (packet < 1 || packet > 16) {
                        throw new IOException("Packet number invalid: " + packet);
                    }
                    packetmask |= 1 << packet - 1;
                }
            }
            buffer[(card - 1) * 2] = (byte)(packetmask >>> 8 & 0xFF);
            buffer[(card - 1) * 2 + 1] = (byte)(packetmask & 0xFF);
        }
        String filename = "grif" + server + "-sub16.dat";
        this.putfile(filename, new ByteArrayInputStream(buffer));
    }

    public void postend() throws IOException {
        this.putfile("__new_db__", new ByteArrayInputStream(new byte[]{49, 10}));
    }

    public boolean isNewDbFileExist() throws IOException {
        String[] names = this.ftp.listNames("__new_db__");
        return names != null && names.length > 0;
    }

    public boolean deleteNewDbFile() throws IOException {
        return this.ftp.deleteFile("__new_db__");
    }

    private void putfile(String filename, InputStream local) throws IOException {
        if (!this.ftp.storeFile(filename, local)) {
            throw new IOException("FTP server store file failed (" + this.ftp.getReplyString().trim() + ")");
        }
    }
}

