/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cladr.server.action;

import bitel.billing.common.ModelItem;
import java.sql.SQLException;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.plugins.cladr.common.model.Address;
import ru.bitel.bgbilling.plugins.cladr.common.model.House;
import ru.bitel.bgbilling.plugins.cladr.common.model.Street;
import ru.bitel.bgbilling.plugins.cladr.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.cladr.server.dao.AddressDBFDAO;
import ru.bitel.bgbilling.plugins.cladr.server.dao.StreetDAO;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class ActionLoadCladr
extends ActionBase {
    String command = null;
    String code = null;
    StreetDAO streetDAO = null;
    AddressDBFDAO addressDBF = null;
    Street street = null;
    Element status = null;
    boolean region = false;
    boolean area = false;
    boolean ignoreSocr = true;
    int direct = 0;
    int cityId = -1;

    public void doAction() throws SQLException {
        this.command = this.getParameter("command");
        this.code = this.getParameter("city_code");
        this.region = this.getBooleanParameter("region");
        this.area = this.getBooleanParameter("area");
        this.ignoreSocr = this.getBooleanParameter("ignoreSocr");
        this.direct = this.getIntParameter("direct", 1);
        this.cityId = this.getIntParameter("city_id", -1);
        this.streetDAO = new StreetDAO(this.con, log);
        this.addressDBF = new AddressDBFDAO(this.con, log);
        this.street = new Street();
        this.loadModelItem((ModelItem)this.street);
        this.status = this.createElement(this.rootNode, "status");
        if ("start".equals(this.command)) {
            this.startLoad();
        } else {
            this.street();
        }
    }

    protected void loadModelItem(ModelItem item) {
        for (String name : item.getAllKey()) {
            item.setValue(name, this.getParameter(name));
        }
    }

    private void startLoad() throws SQLException {
        Address city = this.addressDBF.getAddressByCode(this.code);
        Address regionAddress = null;
        Address areaAddress = null;
        if (this.region) {
            regionAddress = this.addressDBF.getAddressLevelByCode(this.code, 1);
        }
        if (this.area) {
            areaAddress = this.addressDBF.getAddressLevelByCode(this.code, 2);
        }
        this.streetDAO.addCity(regionAddress, areaAddress, city, this.direct, this.cityId);
        List<Street> list = this.streetDAO.getStreetNotFromCladr(city, this.cityId);
        this.streetDAO.addStreetForCladrCompare(list);
        this.nextStreet();
    }

    private void street() throws SQLException {
        if ("commit".equals(this.command)) {
            this.commitStreet();
        }
        if ("del".equals(this.command)) {
            this.delStreet();
        }
        if ("ignore".equals(this.command)) {
            this.ignoreStreet();
        }
    }

    private void commitStreet() throws SQLException {
        this.street.setCityId(this.cityId);
        this.streetDAO.addStreet(this.street, this.ignoreSocr);
        AddressUtils.onUpdateAddressStreet((Setup)this.setup, (int)this.street.getId());
        this.ignoreStreet();
    }

    private void delStreet() throws SQLException {
        this.streetDAO.delStreet(this.street);
        this.ignoreStreet();
    }

    private void ignoreStreet() throws SQLException {
        this.streetDAO.delStreetFromCladrCompare(this.street);
        this.nextStreet();
    }

    private void nextStreet() throws SQLException {
        this.street = this.streetDAO.getNextStreet();
        if (this.street != null) {
            this.street.saveToXML(this.rootNode);
            String[] words = this.street.getTitle().split(" ");
            List<Address> list = this.addressDBF.getStreetByTitleWord(this.code, words);
            this.buildList(this.rootNode, list);
        } else {
            List<Address> address = this.addressDBF.getStreetByCode(this.code);
            List<Integer> list = this.streetDAO.addStreeFromCladr(address, this.ignoreSocr, this.cityId);
            for (Integer streetId : list) {
                AddressUtils.onUpdateAddressStreet((Setup)this.setup, (int)streetId);
            }
            List<House> houses = this.addressDBF.getHouseByCode(this.code);
            this.streetDAO.addHouseForCladr(houses);
            this.status.setAttribute("end", "1");
        }
    }
}

