/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.bean;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.encoders.Hex;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.OrderStatus;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final String PARAM_ORDER_ID = "orderId";
    private static final Logger logger = LogManager.getLogger();

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "cloudpayments_transaction");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("contract_id"));
        transaction.setContractTitle(rs.getString("contract_title"));
        transaction.setPaymentId(rs.getInt("payment_id"));
        transaction.setCreateDate((Date)rs.getTimestamp("create_date"));
        transaction.setTransactionId(rs.getString("order_id"));
        transaction.setTransactionDate((Date)rs.getTimestamp("transaction_date"));
        transaction.setStatus(rs.getString("status"));
        transaction.setParameters(rs.getString("params"));
        transaction.setSum(rs.getBigDecimal("sum"));
        transaction.setAutopayment(rs.getBoolean("autopayment"));
        return transaction;
    }

    protected Transaction getImpl(int transactionId) throws BGException, SQLException {
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            ps = this.getByIdPS = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title FROM " + this.tableName + " AS pt LEFT JOIN contract AS c ON c.id=pt.contract_id WHERE pt.id=?");
        }
        ps.setInt(1, transactionId);
        ResultSet rs = ps.executeQuery();
        Transaction result = rs.next() ? this.getFromRS(rs) : null;
        rs.close();
        return result;
    }

    public boolean update(Transaction transaction, TransactionStatus newTransactionStatus) throws BGException {
        boolean result = false;
        if (transaction != null && newTransactionStatus != null) {
            try {
                StringBuilder query = new StringBuilder("UPDATE ").append(this.tableName).append(" SET ").append("status=?").append(" WHERE ").append("status=? AND id=?");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setString(index++, newTransactionStatus.getCode());
                ps.setString(index++, transaction.getStatus());
                ps.setInt(index++, transaction.getId());
                boolean bl = result = ps.executeUpdate() > 0;
                if (logger.isDebugEnabled()) {
                    logger.debug("updateTransactionStatus: " + result);
                    logger.debug("\ttransaction.getId() = " + transaction.getId());
                    logger.debug("\ttransaction.getStatus() = " + transaction.getStatus());
                    logger.debug("\tnewTransactionStatus = " + newTransactionStatus.getCode());
                }
                ps.close();
                if (result) {
                    transaction.setStatus(newTransactionStatus.getCode());
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return result;
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, order_id=?, status=?, params=?, sum=?, autopayment=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getTransactionId());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                ps.setBoolean(index++, transaction.isAutopayment());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                logger.error(ex.getMessage());
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void doCheckRequest(int contractId, boolean autopaymentTransaction) throws BGException {
        String statusUrl = "";
        Page page = new Page(1, 25);
        String[] sort = new String[]{"createDate:1"};
        SearchResult searchResult = new SearchResult(null, page, sort);
        this.searchTransaction(searchResult, contractId, null, TransactionStatus.NEW.getCode(), autopaymentTransaction);
        for (Transaction transaction : searchResult.getList()) {
            JSONObject resultJsonObject;
            boolean error;
            block38: {
                block39: {
                    String orderId = transaction.getTransactionId();
                    if (logger.isDebugEnabled()) {
                        logger.debug("cloudpaymentsTransactionId = {}", (Object)transaction.getId());
                        logger.debug("cloudpaymentsTransactionOrderId = {}", (Object)orderId);
                    }
                    if (orderId == null && System.currentTimeMillis() - transaction.getCreateDate().getTime() > 86400000L) {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                        this.update(transaction);
                        continue;
                    }
                    String userName = this.getUserName(autopaymentTransaction);
                    String userPswd = this.getUserPswd(autopaymentTransaction);
                    try {
                        userName = URLEncoder.encode(userName, "UTF-8");
                        userPswd = URLEncoder.encode(userPswd, "UTF-8");
                        orderId = URLEncoder.encode(orderId, "UTF-8");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    StringBuilder spec = new StringBuilder();
                    spec.append(statusUrl).append("?language=").append(this.moduleSetup.get("cloudpayments.rest.language", "ru")).append("&orderId=").append(orderId).append("&userName=").append(userName).append("&password=").append(userPswd);
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
                    }
                    StringBuilder resultJson = null;
                    try {
                        resultJson = this.doConnection(spec.toString(), "GET", true, null);
                        if (logger.isDebugEnabled()) {
                            logger.debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                        }
                    }
                    catch (Exception ex) {
                        logger.error(ex.getMessage());
                    }
                    error = false;
                    resultJsonObject = null;
                    if (resultJson == null) break block38;
                    resultJsonObject = new JSONObject(resultJson.toString());
                    String errorCode = resultJsonObject.optString("errorCode", null);
                    if (errorCode != null && !"0".equals(errorCode)) break block39;
                    String orderStatus = resultJsonObject.optString("orderStatus", null);
                    if (orderStatus == null) break block38;
                    if (OrderStatus.AUTHORIZATION.getCode().equals(orderStatus)) continue;
                    if (OrderStatus.REGISTER.getCode().equals(orderStatus) || OrderStatus.APPROVED.getCode().equals(orderStatus)) break block38;
                    if (OrderStatus.DEPOSITED.getCode().equals(orderStatus)) {
                        if (!transaction.getStatus().equals(TransactionStatus.NEW.getCode())) {
                            logger.error("Transaction for ID = " + transaction.getId() + " has status != 'created'");
                        } else if (transaction.getPaymentId() > 0) {
                            logger.error("Transaction for ID = " + transaction.getId() + " has paymentId > 0");
                        } else {
                            this.addTransactionPayment(transaction, TransactionManager.getParamString(resultJsonObject));
                            JSONObject bindingInfoJsonObject = resultJsonObject.optJSONObject("bindingInfo");
                            if (bindingInfoJsonObject != null) {
                                String clientId = bindingInfoJsonObject.optString("clientId", null);
                                String bindingId = bindingInfoJsonObject.optString("bindingId", null);
                                if (clientId != null && bindingId != null) {
                                    PeriodWithTime period;
                                    AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
                                    Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                                    if (autopayment != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                                        period.setLocalDateTimeFrom(LocalDateTime.now());
                                        autopayment.setAccessToken(bindingId);
                                        autopaymentManager.updateAutopayment(autopayment);
                                    }
                                    autopaymentManager.close();
                                }
                            }
                        }
                    } else if (OrderStatus.REVERSED.getCode().equals(orderStatus) || OrderStatus.REFUNDED.getCode().equals(orderStatus)) {
                        if (!transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                            logger.error("Transaction for ID = " + transaction.getId() + " has status != 'ok'");
                            error = true;
                        } else if (transaction.getPaymentId() < 1) {
                            logger.error("Transaction for ID = " + transaction.getId() + " has paymentId < 1");
                            error = true;
                        } else {
                            Payment payment = null;
                            try (PaymentDao paymentDao = new PaymentDao(this.con);){
                                payment = (Payment)paymentDao.get(transaction.getPaymentId());
                                paymentDao.delete(transaction.getPaymentId());
                            }
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                            transaction.setPaymentId(0);
                            this.update(transaction);
                            if (payment != null) {
                                try (BalanceUtils bu = new BalanceUtils(this.con);){
                                    bu.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                                }
                                EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
                            }
                        }
                    } else {
                        error = true;
                    }
                    break block38;
                }
                error = true;
            }
            if (!error) continue;
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setTransactionDate(new Date());
            TransactionManager.addTransactionParameters(transaction, TransactionManager.getParamString(resultJsonObject));
            this.update(transaction);
        }
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId) throws BGException {
        return this.registerOrder(contractId, contractTitle, customerAddress, sum, dataMap, autopaymentTransaction, requestBindingId, "");
    }

    public Transaction registerOrder(int contractId, String contractTitle, String customerAddress, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId, String returnUrl) throws BGException {
        if (autopaymentTransaction || requestBindingId) {
            CloudPaymentsAutopaymentSumEvent event = new CloudPaymentsAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((CloudPaymentsAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = new Transaction();
        transaction.setSum(sum);
        transaction.setContractId(contractId);
        transaction.setCreateDate(new Date());
        transaction.setAutopayment(autopaymentTransaction);
        this.update(transaction);
        String userName = this.getUserName(autopaymentTransaction);
        String userPswd = this.getUserPswd(autopaymentTransaction);
        String description = this.moduleSetup.get("cloudpayments.rest.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}");
        description = description.replace("{CONTRACT_TITLE}", contractTitle);
        try {
            userName = URLEncoder.encode(userName, "UTF-8");
            userPswd = URLEncoder.encode(userPswd, "UTF-8");
            description = URLEncoder.encode(description, "UTF-8");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        int currency = this.moduleSetup.getInt("cloudpayments.rest.currency", 0);
        try {
            returnUrl = Utils.isBlankString((String)returnUrl) ? URLEncoder.encode(this.moduleSetup.get("cloudpayments.rest.return.url", ""), "UTF-8") : URLEncoder.encode(returnUrl, "UTF-8");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new BGException("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430", "system.error");
        }
        String billingName = this.moduleSetup.get("cloudpayments.billing.name", Setup.getSetup().get("billing.name"));
        StringBuilder spec = new StringBuilder();
        spec.append("?amount=").append(sum.multiply(new BigDecimal(100)).setScale(0)).append(currency > 0 ? "&currency=" : "").append(currency > 0 ? Integer.valueOf(currency) : "").append("&language=").append(this.moduleSetup.get("cloudpayments.rest.language", "ru")).append("&orderNumber=").append(transaction.getId()).append("&userName=").append(userName).append("&password=").append(userPswd).append("&description=").append(description).append("&returnUrl=").append(returnUrl);
        String features = this.moduleSetup.get(autopaymentTransaction ? "cloudpayments.autopayment.features" : "cloudpayments.payment.features", null);
        if (!Utils.isBlankString((String)features)) {
            spec.append("&features=").append(features);
        }
        if (requestBindingId) {
            StringBuilder clientId = new StringBuilder();
            if (billingName != null) {
                clientId.append(billingName).append("_");
            }
            clientId.append(this.moduleId).append("_").append(contractId);
            spec.append("&clientId=").append(clientId.toString());
        }
        if (this.moduleSetup.getBoolean("cloudpayments.fiscalization.enable", false)) {
            JSONObject customerDetailsJSON = new JSONObject();
            if (!Utils.isBlankString((String)customerAddress)) {
                if (customerAddress.contains("@")) {
                    customerDetailsJSON.put("email", (Object)customerAddress);
                } else {
                    customerDetailsJSON.put("phone", (Object)customerAddress);
                }
            }
            JSONObject quantityJSON = new JSONObject();
            quantityJSON.put("value", this.moduleSetup.getInt("cloudpayments.fiscalization.receipt.qty", 1));
            quantityJSON.put("measure", (Object)this.moduleSetup.get("cloudpayments.fiscalization.receipt.qty.measure", "\u0448\u0442"));
            JSONObject taxJSON = new JSONObject();
            taxJSON.put("taxType", this.moduleSetup.getInt("cloudpayments.fiscalization.receipt.tax.type", this.moduleSetup.getInt("cloudpayments.fiscalization.receipt.vat", 0)));
            JSONObject itemJSON = new JSONObject();
            itemJSON.put("positionId", (Object)"1");
            itemJSON.put("name", (Object)this.moduleSetup.get("cloudpayments.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
            itemJSON.put("quantity", (Object)quantityJSON);
            itemJSON.put("itemAmount", sum.multiply(new BigDecimal(100)).setScale(0).intValue());
            itemJSON.put("itemCode", (Object)String.valueOf(transaction.getId()));
            itemJSON.put("tax", (Object)taxJSON);
            itemJSON.put("itemPrice", sum.multiply(new BigDecimal(100)).setScale(0).intValue());
            JSONArray itemsJSON = new JSONArray();
            itemsJSON.put((Object)itemJSON);
            JSONObject cartItemsJSON = new JSONObject();
            cartItemsJSON.put("items", (Object)itemsJSON);
            JSONObject orderBundleJSON = new JSONObject();
            orderBundleJSON.put("customerDetails", (Object)customerDetailsJSON);
            orderBundleJSON.put("cartItems", (Object)cartItemsJSON);
            try {
                spec.append("&orderBundle=").append(URLEncoder.encode(orderBundleJSON.toString(), "UTF-8"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            spec.append("&taxSystem=").append(this.moduleSetup.getInt("cloudpayments.fiscalization.receipt.tax.system", 0));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
        }
        StringBuilder resultJson = null;
        try {
            resultJson = this.doConnection(spec.toString(), "GET", true, null);
            if (logger.isDebugEnabled()) {
                logger.debug("\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        if (resultJson != null) {
            try {
                JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                for (String key : new String[]{PARAM_ORDER_ID, "formUrl", "errorCode", "errorMessage"}) {
                    if (!resultJsonObject.has(key)) continue;
                    dataMap.put(key, resultJsonObject.get(key));
                }
            }
            catch (JSONException ex) {
                logger.error(ex.getMessage());
                ex.printStackTrace();
            }
        } else {
            logger.error("resultJson = " + resultJson);
        }
        if (dataMap.containsKey(PARAM_ORDER_ID)) {
            String orderId = String.valueOf(dataMap.get(PARAM_ORDER_ID));
            TransactionManager.addTransactionParameters(transaction, "orderId=" + orderId);
            transaction.setTransactionId(orderId);
            this.update(transaction);
            if (logger.isDebugEnabled()) {
                logger.debug("\torderId = " + orderId);
                logger.debug("\ttransaction.getTransactionId() = " + transaction.getTransactionId());
                logger.debug("\ttransaction.getParameters() = " + transaction.getParameters());
            }
        } else if (dataMap.containsKey("errorCode")) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            TransactionManager.addTransactionParameters(transaction, "errorCode=" + dataMap.get("errorCode") + "\nerrorMessage=" + dataMap.get("errorMessage"));
            this.update(transaction);
        } else {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            TransactionManager.addTransactionParameters(transaction, "resultJson=" + (resultJson == null ? "" : resultJson.toString()));
            this.update(transaction);
        }
        return transaction;
    }

    public String paymentOrderBinding(Transaction transaction, Autopayment autopayment) {
        String result = null;
        if (transaction != null && autopayment != null) {
            String userName = this.moduleSetup.get("cloudpayments.autopayment.rest.user.name", "autopaymentUser");
            String userPswd = this.moduleSetup.get("cloudpayments.autopayment.rest.user.pswd", "autopaymentPassword");
            String bindingId = autopayment.getAccessToken();
            if (bindingId != null) {
                try {
                    userName = URLEncoder.encode(userName, "UTF-8");
                    userPswd = URLEncoder.encode(userPswd, "UTF-8");
                    bindingId = URLEncoder.encode(bindingId, "UTF-8");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                String url = this.moduleSetup.get("cloudpayments.rest.order.binding.url", "https://securepayments.cloudpayments.ru/payment/rest/paymentOrderBinding.do");
                StringBuilder spec = new StringBuilder().append("language=").append(this.moduleSetup.get("cloudpayments.rest.language", "ru")).append("&mdOrder=").append(transaction.getTransactionId()).append("&bindingId=").append(bindingId).append("&userName=").append(userName).append("&password=").append(userPswd);
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + url);
                    logger.debug("\t\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + spec.toString());
                }
                StringBuilder resultJson = null;
                try {
                    resultJson = this.doConnection(url, "POST", true, spec.toString());
                    if (logger.isDebugEnabled()) {
                        logger.debug("\t\u041e\u0442\u0432\u0435\u0442: " + String.valueOf(resultJson));
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
                if (resultJson != null) {
                    StringBuilder resultData = new StringBuilder();
                    JSONObject resultJsonObject = new JSONObject(resultJson.toString());
                    if (resultJsonObject != null) {
                        if (resultJsonObject.has("errorCode")) {
                            resultData.append("errorCode=").append(resultJsonObject.getInt("errorCode")).append("\n");
                        }
                        if (resultJsonObject.has("info")) {
                            resultData.append("info=").append(resultJsonObject.getString("info")).append("\n");
                        }
                        if (resultJsonObject.has("redirect")) {
                            resultData.append("redirect=").append(resultJsonObject.getString("redirect")).append("\n");
                        }
                        result = resultData.toString();
                    }
                }
            } else {
                logger.error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d, \u0442\u0430\u043a \u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d bindingId = " + bindingId);
            }
        }
        return result;
    }

    public void addTransactionPayment(Transaction transaction, String transactionParameters) throws BGException {
        if (this.update(transaction, TransactionStatus.APPROVED)) {
            Payment payment = new Payment();
            payment.setContractId(transaction.getContractId());
            payment.setSum(transaction.getSum());
            payment.setDate(new Date());
            payment.setTypeId(this.moduleSetup.getInt("cloudpayments.payment.type.id", 0));
            payment.setComment(this.moduleSetup.get("cloudpayments.payment.comment", "\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0421\u0431\u0435\u0440\u0431\u0430\u043d\u043a\u0430").replace("{TRANSACTION_ID}", String.valueOf(transaction.getId())));
            PaymentDao paymentDao = new PaymentDao(this.con);
            paymentDao.update((Object)payment);
            paymentDao.close();
            BalanceUtils balanceUtils = new BalanceUtils(this.con);
            balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
            balanceUtils.close();
            transaction.setPaymentId(payment.getId());
            transaction.setTransactionDate(new Date());
            TransactionManager.addTransactionParameters(transaction, transactionParameters);
            this.update(transaction);
            EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
        }
    }

    public static String generateHMacSHA256(String key, String data) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac hMacSHA256 = Mac.getInstance("HmacSHA256");
        byte[] hmacKeyBytes = key.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec secretKey = new SecretKeySpec(hmacKeyBytes, "HmacSHA256");
        hMacSHA256.init(secretKey);
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] res = hMacSHA256.doFinal(dataBytes);
        return new String(Hex.encode((byte[])res));
    }

    public static void aSign() throws Exception {
        String callbackParamsString = "amount=35000099, sign_alias=SHA-256 with RSA, checksum=163BD9FAE437B5DCDAAC4EB5ECEE5E533DAC7BD2C8947B0719F7A8BD17C101EBDBEACDB295C10BF041E903AF3FF1E6101FF7DB9BD024C6272912D86382090D5A7614E174DC034EBBB541435C80869CEED1F1E1710B71D6EE7F52AE354505A83A1E279FBA02572DC4661C1D75ABF5A7130B70306CAFA69DABC2F6200A698198F8, mdOrder=12b59da8-f68f-7c8d-12b5-9da8000826ea, operation=deposited, status=1";
        Map<String, String> callbackParamsMap = Stream.of(callbackParamsString.split(",")).map(String::trim).map(s -> s.split("=")).collect(Collectors.toMap(s -> s[0].trim(), s -> s[1].trim()));
        String checksum = callbackParamsMap.get("checksum");
        callbackParamsMap.remove("checksum");
        callbackParamsMap.remove("sign_alias");
        String signString = callbackParamsMap.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.naturalOrder())).collect(Collector.of(StringBuilder::new, (accumulator, element) -> accumulator.append((String)element.getKey()).append(";").append((String)element.getValue()).append(";"), StringBuilder::append, StringBuilder::toString, new Collector.Characteristics[0]));
        String cert = "MIICcTCCAdqgAwIBAgIGAWAnZt3aMA0GCSqGSIb3DQEBCwUAMHwxIDAeBgkqhkiG9w0BCQEWEWt6\nbnRlc3RAeWFuZGV4LnJ1MQswCQYDVQQGEwJSVTESMBAGA1UECBMJVGF0YXJzdGFuMQ4wDAYDVQQH\nEwVLYXphbjEMMAoGA1UEChMDUkJTMQswCQYDVQQLEwJRQTEMMAoGA1UEAxMDUkJTMB4XDTE3MTIw\nNTE2MDEyMFoXDTE4MTIwNTE2MDExOVowfDEgMB4GCSqGSIb3DQEJARYRa3pudGVzdEB5YW5kZXgu\ncnUxCzAJBgNVBAYTAlJVMRIwEAYDVQQIEwlUYXRhcnN0YW4xDjAMBgNVBAcTBUthemFuMQwwCgYD\nVQQKEwNSQlMxCzAJBgNVBAsTAlFBMQwwCgYDVQQDEwNSQlMwgZ8wDQYJKoZIhvcNAQEBBQADgY0A\nMIGJAoGBAJNgxgtWRFe8zhF6FE1C8s1t/dnnC8qzNN+uuUOQ3hBx1CHKQTEtZFTiCbNLMNkgWtJ/\nCRBBiFXQbyza0/Ks7FRgSD52qFYUV05zRjLLoEyzG6LAfihJwTEPddNxBNvCxqdBeVdDThG81zC0\nDiAhMeSwvcPCtejaDDSEYcQBLLhDAgMBAAEwDQYJKoZIhvcNAQELBQADgYEAfRP54xwuGLW/Cg08\nar6YqhdFNGq5TgXMBvQGQfRvL7W6oH67PcvzgvzN8XCL56dcpB7S8ek6NGYfPQ4K2zhgxhxpFEDH\nPcgU4vswnhhWbGVMoVgmTA0hEkwq86CA5ZXJkJm6f3E/J6lYoPQaKatKF24706T6iH2htG4Bkjre\ngUA=";
        byte[] b = Base64.getDecoder().decode(cert);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        X509Certificate x509Cert = (X509Certificate)certFactory.generateCertificate(in);
        Signature sig = Signature.getInstance("SHA512withRSA");
        sig.initVerify(x509Cert.getPublicKey());
        sig.update(signString.getBytes());
        boolean verifies = sig.verify(Hex.decode((String)checksum.toLowerCase()));
        System.out.println("signature verifies: " + verifies);
    }

    public static void addTransactionParameters(Transaction transaction, String params) {
        if (transaction != null && Utils.notBlankString((String)params)) {
            Object newParams = transaction.getParameters();
            if (newParams != null && !((String)newParams).endsWith("\n")) {
                newParams = (String)newParams + "\n";
            }
            transaction.setParameters((String)newParams + params);
        }
    }

    private static String getParamString(JSONObject resultJsonObject) {
        StringBuilder builder = new StringBuilder();
        TransactionManager.getParamString(resultJsonObject, builder, "");
        return builder.toString();
    }

    private static void getParamString(JSONObject jsonObject, StringBuilder builder, String prefix) {
        if (jsonObject != null) {
            Iterator iterator = jsonObject.keySet().iterator();
            while (iterator.hasNext()) {
                String key = String.valueOf(iterator.next());
                Object value = jsonObject.get(key);
                if (key == null || value == null) continue;
                if (value instanceof JSONObject) {
                    TransactionManager.getParamString((JSONObject)value, builder, key + ".");
                    continue;
                }
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(prefix + key).append("=").append(value);
            }
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("cloudpayments.request.timeout", 10000));
        connection.setReadTimeout(this.moduleSetup.getInt("cloudpayments.request.read.timeout", 5000));
    }

    private String getUserName(boolean autopayment) {
        return autopayment ? this.moduleSetup.get("cloudpayments.autopayment.rest.user.name", "autopaymentUser") : this.moduleSetup.get("cloudpayments.rest.user.name", "user");
    }

    private String getUserPswd(boolean autopayment) {
        return autopayment ? this.moduleSetup.get("cloudpayments.autopayment.rest.user.pswd", "autopaymentPassword") : this.moduleSetup.get("cloudpayments.rest.user.pswd", "password");
    }
}

