/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGFileFilter;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ListItem;
import bitel.billing.module.common.print.HtmlPrinter;
import bitel.billing.module.contract.directory.AddressList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.crm.client.RegisterPanel;
import ru.bitel.bgbilling.plugins.crm.client.SyncAcceptEditor;
import ru.bitel.bgbilling.plugins.crm.client.SyncCloseEditor;
import ru.bitel.bgbilling.plugins.crm.client.TaskEditor;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;

public class TaskManager
extends BGUPanel {
    private int contractId = -1;
    private boolean init = false;
    private boolean openFromProblem = false;
    private String module = "ru.bitel.bgbilling.plugins.crm";
    private String taskId;
    private TaskEditor taskEditor;
    private SyncAcceptEditor syncAcceptEditor;
    private SyncCloseEditor syncCloseEditor;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JLabel countLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u0434\u0430\u0447: 0");
    private BGComboBox<ComboBoxItem> city_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> quarter_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> street_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> house_CB = new BGComboBox();
    private JRadioButton processedYesRb = new JRadioButton("\u0434\u0430");
    private JRadioButton processedNoRb = new JRadioButton("\u043d\u0435\u0442");
    private JRadioButton processedAllRb = new JRadioButton("\u0432\u0441\u0435");
    private JToggleButton filterButton = new JToggleButton();
    private BGControlPanelDateNoB fromDate = new BGControlPanelDateNoB();
    private BGControlPanelDateNoB toDate = new BGControlPanelDateNoB();
    private BGButtonPanel actionPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.PRINT_M, BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M, BGButtonPanel.GLUE, BGButtonPanel.DO_M});
    private BGControlPanelListSelect executors_P = new BGControlPanelListSelect(5);
    private BGControlPanelListSelect groups_P = new BGControlPanelListSelect(5);
    private BGControlPanelListSelect type_CB = new BGControlPanelListSelect(5);
    private JPopupMenu rcMenu = new JPopupMenu();
    private BGComboBox<ComboBoxItem> date_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> sort1_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> sort2_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> sort3_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> sort4_CB = new BGComboBox();
    private BGComboBox<ComboBoxItem> sort5_CB = new BGComboBox();
    private JButton doButton = new JButton("Ok");
    private BGComboBox<ComboBoxItem> do_CB = new BGComboBox();
    private JPanel topPanel = new JPanel();
    private BGComboBox<ListItem> reportFormat_CB = new BGComboBox();
    private BGControlPanelListSelect statusList = new BGControlPanelListSelect(5);
    private AddressList quartersList = null;
    private AddressList streetsList = null;
    private HashMap<Integer, Color> colorMap = new HashMap();
    private TaskTableModel taskTableModel = new TaskTableModel();
    AbstractBGUPanel.DefaultAction newAction = new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            if (TaskManager.this.contractId > 0) {
                TaskManager.this.taskEditor.setId("new");
                TaskManager.this.taskEditor.setData();
                TaskManager.this.taskEditor.setVisible(true);
            }
        }
    };
    AbstractBGUPanel.DefaultAction editAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            List rows = TaskManager.this.taskTableModel.getSelectedRows();
            if (rows == null || rows.size() == 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            } else if (rows.size() > 1) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u041e\u0414\u041d\u0423 \u0441\u0442\u0440\u043e\u043a\u0443!");
            } else {
                TaskManager.this.taskEditor.setId(TaskManager.this.taskTableModel.getRowId((Map)rows.get(0)).toString());
                TaskManager.this.taskEditor.setData();
                TaskManager.this.taskEditor.setVisible(true);
            }
        }
    };
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent event) throws Exception {
            if (!TaskManager.this.init) {
                Element list;
                TaskManager.this.date_CB.removeAllItems();
                TaskManager.this.date_CB.addItem((Object)new ComboBoxItem((Object)"open_dt", "\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f"));
                TaskManager.this.date_CB.addItem((Object)new ComboBoxItem((Object)"accept_dt", "\u0414\u0430\u0442\u0430 \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u044f"));
                TaskManager.this.date_CB.addItem((Object)new ComboBoxItem((Object)"close_dt", "\u0414\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f"));
                TaskManager.this.date_CB.addItem((Object)new ComboBoxItem((Object)"target_dt", "\u0421\u0440\u043e\u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f"));
                TaskManager.this.date_CB.addItem((Object)new ComboBoxItem((Object)"execute_dt", "\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f"));
                TaskManager.this.buildTypeCombo();
                Request request = new Request();
                request.setModule(TaskManager.this.module);
                request.setAction("GetAddressInfo");
                Document doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    TaskManager.this.streetsList = new AddressList(XMLUtils.selectNode((Node)doc, (String)"//streets"));
                    TaskManager.this.quartersList = new AddressList(XMLUtils.selectNode((Node)doc, (String)"//quarters"));
                    TaskManager.this.city_CB.setModel((ComboBoxModel)ClientUtils.buildComboBox((Node)XMLUtils.selectNode((Node)doc, (String)"//cities"), null));
                    TaskManager.this.city_CB.setSelectedIndex(0);
                    TaskManager.this.buildHouseList();
                }
                request = new Request();
                request.setModule(TaskManager.this.module);
                request.setAction("ListDirectory");
                request.setAttribute("mode", 12);
                doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    ClientUtils.buildList((JList)TaskManager.this.executors_P.getList(), (Node)XMLUtils.selectElement((Node)doc, (String)"//directory"), (String)"");
                }
                request = new Request();
                request.setModule(TaskManager.this.module);
                request.setAction("RegisterGroupList");
                doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    ClientUtils.buildList((JList)TaskManager.this.groups_P.getList(), (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
                }
                TaskManager.this.initSortCombo(TaskManager.this.sort1_CB);
                TaskManager.this.initSortCombo(TaskManager.this.sort2_CB);
                TaskManager.this.initSortCombo(TaskManager.this.sort3_CB);
                TaskManager.this.initSortCombo(TaskManager.this.sort4_CB);
                TaskManager.this.initSortCombo(TaskManager.this.sort5_CB);
                TaskManager.this.setExecutors();
                request = new Request();
                request.setModule(TaskManager.this.module);
                request.setAction("TaskReportFormatList");
                doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    list = doc.getDocumentElement();
                    NodeList items = list.getElementsByTagName("item");
                    for (int i = 0; i < items.getLength(); ++i) {
                        Element item = (Element)items.item(i);
                        ListItem listItem = new ListItem(item.getAttribute("title"));
                        listItem.setAttribute("xslt", (Object)item.getAttribute("xslt"));
                        TaskManager.this.reportFormat_CB.addItem((Object)listItem);
                    }
                }
                request = new Request();
                request.setModule(TaskManager.this.module);
                request.setAction("RegisterStatusList");
                request.setAttribute("object_type", "task");
                doc = TransferManager.getDocument((Request)request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    list = XMLUtils.selectElement((Node)doc, (String)"//list");
                    ClientUtils.buildList((JList)TaskManager.this.statusList.getList(), (Node)list, null);
                    TaskManager.this.taskEditor.setStatusData(list);
                }
                TaskManager.this.init = true;
                if (TaskManager.this.contractId < 0) {
                    TaskManager.this.loadFilter();
                }
            }
            TaskManager.this.execRequest();
        }
    };

    public TaskManager() {
        this.taskEditor = new TaskEditor();
        this.syncAcceptEditor = new SyncAcceptEditor();
        this.syncCloseEditor = new SyncCloseEditor();
        this.taskEditor.init(this.module, 0);
        this.syncAcceptEditor.init(this.module, 0);
        this.syncCloseEditor.init(this.module, 0);
        this.ifSet();
    }

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.taskTableModel)){
            BGUTable table;
            {
                this.table = null;
                this.table = this;
            }

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component component = super.prepareRenderer(renderer, row, column);
                Map rowMap = (Map)((BGTableModel)this.table.getModel()).getRows().get(this.table.getRowSorter().convertRowIndexToModel(row));
                int id = (Integer)rowMap.get("id");
                if (id != -1) {
                    if (TaskManager.this.colorMap.get(id) != null) {
                        component.setBackground(this.isCellSelected(row, column) ? TaskManager.this.colorMap.get(id).darker() : TaskManager.this.colorMap.get(id));
                    } else {
                        component.setBackground(this.isCellSelected(row, column) ? this.selectionBackground : null);
                    }
                } else {
                    component.setBackground(this.isCellSelected(row, column) ? this.selectionBackground : null);
                }
                return component;
            }
        };
        table.setSelectionMode(2);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TaskManager.this.performAction("edit");
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                int index = ((BGUTable)event.getSource()).getSelectedRow();
                if (SwingUtilities.isRightMouseButton(event) && TaskManager.this.rcMenu.isPopupTrigger(event) && index > -1 && TaskManager.this.rcMenu.getComponentCount() > 0) {
                    Point p = event.getPoint();
                    TaskManager.this.rcMenu.show(event.getComponent(), p.x, p.y);
                }
            }
        });
        this.filterButton.setText("\u0424\u0438\u043b\u044c\u0442\u0440, \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430, \u0430\u0434\u0440\u0435\u0441, \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManager.this.topPanel.setVisible(TaskManager.this.filterButton.isSelected());
            }
        });
        this.topPanel.setVisible(this.filterButton.isSelected());
        JPanel addPanel = new JPanel(new GridBagLayout());
        addPanel.setBorder((Border)new BGTitleBorder(" \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e "));
        addPanel.add((Component)this.do_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        addPanel.add((Component)this.doButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.processedAllRb);
        buttonGroup.add(this.processedYesRb);
        buttonGroup.add(this.processedNoRb);
        JPanel sortPanel = new JPanel(new GridBagLayout());
        sortPanel.setBorder((Border)new BGTitleBorder(" \u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 "));
        sortPanel.add((Component)this.sort1_CB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sortPanel.add((Component)this.sort2_CB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sortPanel.add((Component)this.sort3_CB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sortPanel.add((Component)this.sort4_CB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sortPanel.add((Component)this.sort5_CB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        sortPanel.add(Box.createGlue(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.do_CB.addItem((Object)new ComboBoxItem((Object)"open", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435"));
        this.do_CB.addItem((Object)new ComboBoxItem((Object)"accept", "\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435"));
        this.do_CB.addItem((Object)new ComboBoxItem((Object)"process", "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435"));
        this.do_CB.addItem((Object)new ComboBoxItem((Object)"close", "\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435"));
        this.processedAllRb.setSelected(true);
        JTabbedPane groupAndExecutorTabs = new JTabbedPane();
        groupAndExecutorTabs.setMinimumSize(new Dimension(300, 200));
        groupAndExecutorTabs.setPreferredSize(new Dimension(300, 200));
        groupAndExecutorTabs.add((Component)this.groups_P, "\u0413\u0440\u0443\u043f\u043f\u044b");
        groupAndExecutorTabs.add((Component)this.executors_P, "\u0418\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0438");
        groupAndExecutorTabs.add((Component)this.type_CB, "\u0422\u0438\u043f\u044b");
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)addPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)this.reportFormat_CB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.topPanel.add((Component)groupAndExecutorTabs, new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.topPanel.add((Component)sortPanel, new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.actionPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        controlPanel.add((Component)this.filterButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        controlPanel.add((Component)this.countLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        controlPanel.add((Component)this.pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.taskEditor), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.syncAcceptEditor), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.syncCloseEditor), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        final HashSet<RegisterPanel> components = new HashSet<RegisterPanel>();
        components.add(this.taskEditor);
        components.add(this.syncAcceptEditor);
        components.add(this.syncCloseEditor);
        ComponentAdapter listener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TaskManager.this.execRequest();
                TaskManager.this.topPanel.setVisible(TaskManager.this.filterButton.isSelected());
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Component component = e.getComponent();
                for (Component cmp : components) {
                    if (cmp == component) continue;
                    cmp.setVisible(false);
                }
                TaskManager.this.topPanel.setVisible(false);
            }
        };
        this.taskEditor.setVisible(false);
        this.syncAcceptEditor.setVisible(false);
        this.syncCloseEditor.setVisible(false);
        this.taskEditor.addComponentListener(listener);
        this.syncAcceptEditor.addComponentListener(listener);
        this.syncCloseEditor.addComponentListener(listener);
    }

    private JPanel getFilterPanel() {
        this.city_CB.setPreferredSize(new Dimension(300, 30));
        this.city_CB.setMaximumSize(new Dimension(300, 30));
        this.quarter_CB.setPreferredSize(new Dimension(200, 30));
        this.quarter_CB.setMaximumSize(new Dimension(200, 30));
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel periodPanel = new JPanel(new GridBagLayout());
        JPanel filterPanel = new JPanel(new GridBagLayout());
        JPanel filterPanel1 = new JPanel(new GridBagLayout());
        JPanel processedFilter = new JPanel(new GridBagLayout());
        JPanel addressFilterPanel = new JPanel(new GridBagLayout());
        processedFilter.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        processedFilter.add((Component)this.processedYesRb, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        processedFilter.add((Component)this.processedNoRb, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        processedFilter.add((Component)this.processedAllRb, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        periodPanel.add((Component)this.date_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        periodPanel.add((Component)this.fromDate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        periodPanel.add((Component)this.toDate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        periodPanel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        filterPanel1.add((Component)processedFilter, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        filterPanel1.add((Component)periodPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel1.add(Box.createGlue(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        addressFilterPanel.add((Component)new JLabel("\u0413\u043e\u0440\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        addressFilterPanel.add((Component)this.city_CB, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressFilterPanel.add((Component)new JLabel("\u041a\u0432\u0430\u0440\u0442\u0430\u043b:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        addressFilterPanel.add((Component)this.quarter_CB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressFilterPanel.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        addressFilterPanel.add((Component)this.street_CB, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        addressFilterPanel.add((Component)new JLabel("\u0414\u043e\u043c:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        addressFilterPanel.add((Component)this.house_CB, new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        tabbedPane.add((Component)this.statusList, "\u0421\u0442\u0430\u0442\u0443\u0441\u044b");
        tabbedPane.add((Component)filterPanel1, "\u041f\u0435\u0440\u0438\u043e\u0434, \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u044b\u0435");
        tabbedPane.add((Component)addressFilterPanel, "\u0410\u0434\u0440\u0435\u0441");
        filterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        filterPanel.add((Component)tabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        return filterPanel;
    }

    private void ifSet() {
        this.city_CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int cityid = Integer.valueOf(((ComboBoxItem)TaskManager.this.city_CB.getSelectedItem()).getObject().toString());
                TaskManager.this.quartersList.buildComboBox(TaskManager.this.quarter_CB, cityid, true, true);
                TaskManager.this.streetsList.buildComboBox(TaskManager.this.street_CB, cityid, true, "\u043b\u044e\u0431\u0430\u044f", false, "-----", null);
                TaskManager.this.buildHouseList();
            }
        });
        this.quarter_CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManager.this.buildHouseList();
            }
        });
        this.street_CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaskManager.this.buildHouseList();
            }
        });
        JMenuItem menuItem = new JMenuItem("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440");
        this.rcMenu.add(menuItem);
        menuItem.addActionListener(e -> this.copyToBuffer());
        this.groups_P.getList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                TaskManager.this.setExecutors();
                TaskManager.this.buildTypeCombo();
            }
        });
        this.actionPanel.addActionListener(e -> this.actionPanel_actionPerformed(e));
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName != null && propertyName.startsWith("to")) {
                    TaskManager.this.execRequest();
                }
            }
        });
        this.doButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String command = (String)((ComboBoxItem)TaskManager.this.do_CB.getSelectedItem()).getObject();
                if (command.equals("open")) {
                    TaskManager.this.syncOpen();
                } else if (command.equals("accept")) {
                    TaskManager.this.syncAccept();
                } else if (command.equals("process")) {
                    TaskManager.this.syncProcess();
                } else if (command.equals("close")) {
                    TaskManager.this.syncClose();
                }
            }
        });
        this.pagePanel.init();
    }

    public void setContractId(int id) {
        this.contractId = id;
        this.taskEditor.setContractId(this.contractId);
    }

    private void saveFilter() {
        ComboBoxItem cityItem = (ComboBoxItem)this.city_CB.getSelectedItem();
        ComboBoxItem quarterItem = (ComboBoxItem)this.quarter_CB.getSelectedItem();
        ComboBoxItem streetItem = (ComboBoxItem)this.street_CB.getSelectedItem();
        ComboBoxItem houseItem = (ComboBoxItem)this.house_CB.getSelectedItem();
        ComboBoxItem dateItem = (ComboBoxItem)this.date_CB.getSelectedItem();
        ComboBoxItem sort1 = (ComboBoxItem)this.sort1_CB.getSelectedItem();
        ComboBoxItem sort2 = (ComboBoxItem)this.sort2_CB.getSelectedItem();
        ComboBoxItem sort3 = (ComboBoxItem)this.sort3_CB.getSelectedItem();
        ComboBoxItem sort4 = (ComboBoxItem)this.sort4_CB.getSelectedItem();
        ComboBoxItem sort5 = (ComboBoxItem)this.sort5_CB.getSelectedItem();
        ComboBoxItem doItem = (ComboBoxItem)this.do_CB.getSelectedItem();
        Preferences userConfig = ClientSetup.getInstance().getUserConfig();
        userConfig.set("crm.task.status.selected", this.statusList.getListValues());
        userConfig.set("crm.task.type.selected", this.type_CB.getListValues());
        userConfig.set("crm.task.executors.selected", this.executors_P.getListValues());
        userConfig.set("crm.task.groups.selected", this.groups_P.getListValues());
        userConfig.set("crm.task.city.selected", String.valueOf(cityItem.getObject()));
        userConfig.set("crm.task.quarter.selected", String.valueOf(quarterItem.getObject()));
        userConfig.set("crm.task.street.selected", String.valueOf(streetItem.getObject()));
        userConfig.set("crm.task.house.selected", String.valueOf(houseItem.getObject()));
        userConfig.set("crm.task.date_type.selected", String.valueOf(dateItem.getObject()));
        userConfig.set("crm.task.period.fromDate.selected", this.fromDate.getDateString());
        userConfig.set("crm.task.period.toDate.selected", this.toDate.getDateString());
        userConfig.set("crm.task.processedYesRb", String.valueOf(this.processedYesRb.isSelected()));
        userConfig.set("crm.task.processedNoRb", String.valueOf(this.processedNoRb.isSelected()));
        userConfig.set("crm.task.processedAllRb", String.valueOf(this.processedAllRb.isSelected()));
        userConfig.set("crm.task.sort1.selected", String.valueOf(sort1.getObject()));
        userConfig.set("crm.task.sort2.selected", String.valueOf(sort2.getObject()));
        userConfig.set("crm.task.sort3.selected", String.valueOf(sort3.getObject()));
        userConfig.set("crm.task.sort4.selected", String.valueOf(sort4.getObject()));
        userConfig.set("crm.task.sort5.selected", String.valueOf(sort5.getObject()));
        userConfig.set("crm.task.do.selected", String.valueOf(doItem.getObject()));
        ListItem formatItem = (ListItem)this.reportFormat_CB.getSelectedItem();
        if (formatItem != null) {
            userConfig.set("crm.task.reportFormat.selected", formatItem.getText());
        }
    }

    private void loadFilter() {
        Preferences userConfig = ClientSetup.getInstance().getUserConfig();
        this.statusList.setListValues(userConfig.get("crm.task.status.selected", ""));
        this.type_CB.setListValues(userConfig.get("crm.task.type.selected", ""));
        this.executors_P.setListValues(userConfig.get("crm.task.executors.selected", ""));
        this.groups_P.setListValues(userConfig.get("crm.task.groups.selected", ""));
        ClientUtils.setComboBoxSelection(this.city_CB, (Object)userConfig.get("crm.task.city.selected", ""));
        ClientUtils.setComboBoxSelection(this.quarter_CB, (Object)userConfig.get("crm.task.quarter.selected", ""));
        ClientUtils.setComboBoxSelection(this.street_CB, (Object)userConfig.get("crm.task.street.selected", ""));
        ClientUtils.setComboBoxSelection(this.house_CB, (Object)userConfig.get("crm.task.house.selected", ""));
        ClientUtils.setComboBoxSelection(this.date_CB, (Object)userConfig.get("crm.task.date_type.selected", ""));
        this.fromDate.setDateString(userConfig.get("crm.task.period.fromDate.selected", ""));
        this.toDate.setDateString(userConfig.get("crm.task.period.toDate.selected", ""));
        this.processedYesRb.setSelected(Boolean.valueOf(userConfig.get("crm.task.processedYesRb", "false")));
        this.processedNoRb.setSelected(Boolean.valueOf(userConfig.get("crm.task.processedNoRb", "false")));
        this.processedAllRb.setSelected(Boolean.valueOf(userConfig.get("crm.task.processedAllRb", "false")));
        ClientUtils.setComboBoxSelection(this.sort1_CB, (Object)userConfig.get("crm.task.sort1.selected", ""));
        ClientUtils.setComboBoxSelection(this.sort2_CB, (Object)userConfig.get("crm.task.sort2.selected", ""));
        ClientUtils.setComboBoxSelection(this.sort3_CB, (Object)userConfig.get("crm.task.sort3.selected", ""));
        ClientUtils.setComboBoxSelection(this.sort4_CB, (Object)userConfig.get("crm.task.sort4.selected", ""));
        ClientUtils.setComboBoxSelection(this.sort5_CB, (Object)userConfig.get("crm.task.sort5.selected", ""));
        ClientUtils.setComboBoxSelection(this.do_CB, (Object)userConfig.get("crm.task.do.selected", ""));
        String selected_id = userConfig.get("crm.task.reportFormat.selected", "");
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.reportFormat_CB.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ListItem comboBoxItem = (ListItem)model.getElementAt(i);
            if (!comboBoxItem.getText().equals(selected_id)) continue;
            this.reportFormat_CB.setSelectedIndex(i);
            break;
        }
    }

    public void execRequest() {
        if (this.openFromProblem) {
            this.contractId = -1;
        }
        if (this.init) {
            Request request = this.getRequest();
            request.setPageIndex(this.pagePanel.getPageIndex());
            request.setPageSize(this.pagePanel.getPageSize());
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table");
                this.colorMap.clear();
                this.taskTableModel.setData(XMLUtils.selectElements((Node)tableElement, (String)"data/row"));
                this.pagePanel.setPageInfo(tableElement);
                this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u0434\u0430\u0447: " + Page.getRecordCount((Element)tableElement));
            }
        }
    }

    private Request getRequest() {
        ListItem formatItem = (ListItem)this.reportFormat_CB.getSelectedItem();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetRegisterTaskTable");
        request.setContractId(this.contractId);
        if (formatItem != null) {
            request.setAttribute("xslt", formatItem.getAttribute("xslt"));
        }
        if (this.taskId != null) {
            request.setAttribute("taskId", this.taskId);
        }
        request.setPageIndex(0);
        this.addRequestParam(request, this.city_CB, "city");
        this.addRequestParam(request, this.quarter_CB, "quarter");
        this.addRequestParam(request, this.street_CB, "street");
        this.addRequestParam(request, this.house_CB, "house");
        this.addRequestParam(request, this.date_CB, "date_type");
        request.setAttribute("status", this.statusList.getListValues());
        request.setAttribute("type", this.type_CB.getListValues());
        request.setAttribute("executors", this.executors_P.getListValues());
        request.setAttribute("groups", this.groups_P.getListValues());
        request.setPeriod(this.fromDate.getDateString(), this.toDate.getDateString());
        if (this.processedYesRb.isSelected()) {
            request.setAttribute("processed", "1");
        } else if (this.processedNoRb.isSelected()) {
            request.setAttribute("processed", "0");
        } else {
            request.setAttribute("processed", "-1");
        }
        this.addSortParams(request);
        return request;
    }

    private void addSortParams(Request request) {
        this.addRequestParam(request, this.sort1_CB, "sort1");
        this.addRequestParam(request, this.sort2_CB, "sort2");
        this.addRequestParam(request, this.sort3_CB, "sort3");
        this.addRequestParam(request, this.sort4_CB, "sort4");
        this.addRequestParam(request, this.sort5_CB, "sort5");
    }

    private void addRequestParam(Request request, BGComboBox<ComboBoxItem> bgComboBox, String name) {
        ComboBoxItem boxItem = (ComboBoxItem)bgComboBox.getSelectedItem();
        if (boxItem != null) {
            request.setAttribute(name, boxItem.getObject());
        }
    }

    private void buildTypeCombo() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("TaskTypeList");
        req.setAttribute("groups", this.groups_P.getListValues());
        Document doc = TransferManager.getDocument((Request)req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildList((JList)this.type_CB.getList(), (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
        }
    }

    private void initSortCombo(BGComboBox<ComboBoxItem> combo) {
        combo.addItem((Object)new ComboBoxItem((Object)"no", "- \u043d\u0435\u0442 -"));
        combo.addItem((Object)new ComboBoxItem((Object)"", "---"));
        combo.addItem((Object)new ComboBoxItem((Object)"quarter.title", "\u043a\u0432\u0430\u0440\u0442\u0430\u043b"));
        combo.addItem((Object)new ComboBoxItem((Object)"street.title", "\u0443\u043b\u0438\u0446\u0430"));
        combo.addItem((Object)new ComboBoxItem((Object)"area.title", "\u0440\u0430\u0439\u043e\u043d"));
        combo.addItem((Object)new ComboBoxItem((Object)"house.house, house.frac", "\u0434\u043e\u043c \u0438 \u0434\u0440."));
        combo.addItem((Object)new ComboBoxItem((Object)"address.pod", "\u043f\u043e\u0434\u044a\u0435\u0437\u0434"));
        combo.addItem((Object)new ComboBoxItem((Object)"CAST(address.flat AS UNSIGNED), address.flat", "\u043a\u0432\u0430\u0440\u0442\u0438\u0440\u0430"));
        combo.addItem((Object)new ComboBoxItem((Object)"", "---"));
        combo.addItem((Object)new ComboBoxItem((Object)"task.open_dt", "\u0434\u0430\u0442\u0430"));
        combo.addItem((Object)new ComboBoxItem((Object)"task.open_dt DESC", "\u0434\u0430\u0442\u0430 \u043e\u0431\u0440."));
        combo.addItem((Object)new ComboBoxItem((Object)"task.target_dt", "\u0441\u0440\u043e\u043a"));
        combo.addItem((Object)new ComboBoxItem((Object)"task.target_dt DESC", "\u0441\u0440\u043e\u043a \u043e\u0431\u0440."));
        combo.addItem((Object)new ComboBoxItem((Object)"", "---"));
        combo.addItem((Object)new ComboBoxItem((Object)"task.open_uid", "\u043e\u0442\u043a\u0440\u044b\u0442\u0430"));
    }

    private void buildHouseList() {
        this.house_CB.removeAllItems();
        ComboBoxItem cityItem = (ComboBoxItem)this.city_CB.getSelectedItem();
        ComboBoxItem quarterItem = (ComboBoxItem)this.quarter_CB.getSelectedItem();
        ComboBoxItem streetItem = (ComboBoxItem)this.street_CB.getSelectedItem();
        if (quarterItem != null && streetItem != null && cityItem != null) {
            int quarterId = Utils.parseInt((String)((String)quarterItem.getObject()), (int)-1);
            int streetId = Utils.parseInt((String)((String)streetItem.getObject()), (int)-1);
            if (quarterId > 0 || streetId > 0) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("FilterHouse");
                request.setAttribute("quarter", quarterId);
                request.setAttribute("street", streetId);
                Document doc = TransferManager.getDocument((Request)request);
                ClientUtils.buildComboBox(this.house_CB, (Node)XMLUtils.selectElement((Node)doc, (String)"//list"), (String)"");
            }
            this.house_CB.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u043b\u044e\u0431\u043e\u0439"), 0);
            this.house_CB.setSelectedIndex(0);
        }
    }

    private void actionPanel_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (BGButtonPanel.PRINT_M.getActionCommand().equals(actionCommand)) {
            new HtmlPrinter(this.getHtml(), 1500, 300);
        } else if (BGButtonPanel.EMAIL_M.getActionCommand().equals(actionCommand)) {
            BGEmailDialog dialog = new BGEmailDialog();
            dialog.addPropertyChangeListener(evt -> {
                if (evt.getPropertyName().equals("selectEmail")) {
                    String email = String.valueOf(evt.getNewValue());
                    String subject = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0422\u0435\u043c\u0430 \u043f\u0438\u0441\u044c\u043c\u0430", "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0435\u0442\u0430", 3);
                    if (email != null && subject != null) {
                        Request request = this.getRequest();
                        request.setAttribute("email", email);
                        request.setAttribute("email_subject", subject);
                        request.setAttribute("contentType", "html");
                        if (ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request))) {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                        }
                        this.saveUserEmail("crm.task", email);
                    }
                }
            });
            dialog.setEmailList(ClientSetup.getInstance().getUserEmail(this.module));
            dialog.setVisible(true);
        } else if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
            BGFileChooser fc = new BGFileChooser((Component)((Object)this));
            BGFileFilter ff1 = new BGFileFilter("html", "HTML files (*.html)");
            fc.addChoosableFileFilter((FileFilter)ff1);
            BGFileFilter ff2 = new BGFileFilter("pdf", "PDF \u043d\u0430\u0440\u044f\u0434\u044b(*.pdf)");
            fc.addChoosableFileFilter((FileFilter)ff2);
            BGFileFilter ff3 = new BGFileFilter("pdf", "PDF \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u0435(*.pdf)");
            fc.addChoosableFileFilter((FileFilter)ff3);
            BGFileFilter ff4 = new BGFileFilter("pdf", "PDF \u0437\u0430\u044f\u0432\u043a\u0438(*.pdf)");
            fc.addChoosableFileFilter((FileFilter)ff4);
            if (fc.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                try {
                    if (fc.getFileFilter().equals(ff1)) {
                        ClientUtils.saveHtmlFile((String)this.getHtml(), (File)fc.getSelectedFile());
                    } else if (fc.getFileFilter().equals(ff2) || fc.getFileFilter().equals(ff3) || fc.getFileFilter().equals(ff4)) {
                        if (fc.getFileFilter().equals(ff2)) {
                            ClientUtils.saveBinaryFile((byte[])this.getPdf("npdf"), (File)fc.getSelectedFile(), (String)".pdf");
                        }
                        if (fc.getFileFilter().equals(ff3)) {
                            ClientUtils.saveBinaryFile((byte[])this.getPdf("opdf"), (File)fc.getSelectedFile(), (String)".pdf");
                        }
                        if (fc.getFileFilter().equals(ff4)) {
                            ClientUtils.saveBinaryFile((byte[])this.getPdf("zpdf"), (File)fc.getSelectedFile(), (String)".pdf");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (BGButtonPanel.DO_M.getActionCommand().equals(actionCommand)) {
            if (this.contractId < 0) {
                this.saveFilter();
            }
            this.pagePanel.init();
            this.execRequest();
        }
    }

    private byte[] getPdf(String ext) {
        Request request = this.getRequest();
        request.setAttribute("contentType", "application/pdf");
        request.setAttribute("ext", ext);
        return TransferManager.getBytes((Request)request);
    }

    private String getHtml() {
        Request request = this.getRequest();
        request.setAttribute("contentType", "html");
        request.setAttribute("ext", "html");
        String result = "<html>\u041e\u0442\u0447\u0435\u0442 \u043d\u0435 \u043f\u0440\u0438\u0448\u0435\u043b \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430</html>";
        try {
            result = TransferManager.getString((Request)request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void copyToBuffer() {
        List rows = this.taskTableModel.getSelectedRows();
        if (rows == null || rows.size() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443(\u0438)!");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map rowMap : rows) {
            Request request = new Request();
            request.setAttribute("contentType", "byte");
            request.setModule(this.module);
            request.setAction("RegisterTaskReport");
            request.setAttribute("id", this.taskTableModel.getRowId(rowMap).toString());
            String result = TransferManager.getString((Request)request);
            if (result == null) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(result);
        }
        if (sb.length() > 0) {
            try {
                Clipboard theClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection buffer = new StringSelection(sb.toString());
                theClipboard.setContents(buffer, buffer);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void syncAccept() {
        String idList = this.getSelectedIdList();
        if (idList != null) {
            this.syncAcceptEditor.setIdList(idList);
            this.syncAcceptEditor.setData();
            this.syncAcceptEditor.setVisible(true);
        }
    }

    private void syncProcess() {
        String idList = this.getSelectedIdList();
        if (idList != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438?", "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430", 0) == 0) {
            String mail = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), (Object)"E-Mail \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u0430");
            if (Utils.isEmptyString((String)mail)) {
                return;
            }
            String subject = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), (Object)"\u0422\u0435\u043c\u0430 \u043f\u0438\u0441\u044c\u043c\u0430");
            if (Utils.isEmptyString((String)subject)) {
                return;
            }
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("SyncProcessRegisterTask");
            req.setAttribute("id_list", idList);
            req.setAttribute("mail", mail);
            req.setAttribute("subject", subject);
            if (ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)req))) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430, \u043e\u0442\u0447\u0435\u0442 \u0432\u044b\u0441\u043b\u0430\u043d \u043d\u0430 \u0443\u043a\u0437\u0430\u043d\u043d\u044b\u0439 E-Mail");
            }
        }
    }

    private void syncOpen() {
        String idList = this.getSelectedIdList();
        if (idList != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u0434\u0430\u0447\u0438?", "\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("SyncOpenRegisterTask");
            request.setAttribute("id_list", idList);
            if (ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request))) {
                this.performAction("refresh");
            }
        }
    }

    private void syncClose() {
        String idList = this.getSelectedIdList();
        if (idList != null) {
            this.syncCloseEditor.setIdList(idList);
            this.syncCloseEditor.setData();
            this.syncCloseEditor.setVisible(true);
        }
    }

    private String getSelectedIdList() {
        List rows = this.taskTableModel.getSelectedRows();
        if (rows == null || rows.size() == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443(\u0438)!");
            return null;
        }
        StringBuffer idList = new StringBuffer(30);
        for (Map rowMap : rows) {
            if (idList.length() != 0) {
                idList.append(",");
            }
            idList.append(this.taskTableModel.getRowId(rowMap));
        }
        return idList.toString();
    }

    protected void setExecutors() {
        String executors = this.executors_P.getListValues();
        String groups = this.groups_P.getListValues();
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("RegisterExecutorList");
        req.setAttribute("groups", groups);
        Document doc = TransferManager.getDocument((Request)req);
        Element list = XMLUtils.selectElement((Node)doc, (String)"//list");
        ClientUtils.buildList((JList)this.executors_P.getList(), (Node)list);
        this.executors_P.setListValues(executors);
    }

    public void updateForId(String id) {
        this.taskId = id;
        this.execRequest();
        this.taskId = null;
    }

    public void setProblemId(String id) {
        this.taskEditor.setProblemId(id);
    }

    public void setOpenFrom(boolean flag) {
        this.openFromProblem = flag;
    }

    class TaskTableModel
    extends BGTableModel<Map<String, Object>> {
        private static final String COLUMN_ID = "id";
        private static final String COLUMN_CONTRACT_ID = "contract_id";
        private static final String COLUMN_FIO = "fio";
        private static final String COLUMN_CITY = "city";
        private static final String COLUMN_QUARTER = "quarter";
        private static final String COLUMN_AREA = "area";
        private static final String COLUMN_STREET = "street";
        private static final String COLUMN_HOUSE = "house";
        private static final String COLUMN_POD = "pod";
        private static final String COLUMN_FLAT = "flat";
        private static final String COLUMN_PHONE = "phone";
        private static final String COLUMN_OPEN_DATE = "open_date";
        private static final String COLUMN_OPEN_USER = "open_user";
        private static final String COLUMN_TARGET_DATE = "target_date";
        private static final String COLUMN_STATUS = "status";
        private static final String COLUMN_CONTRACT = "contract";
        private static final String COLUMN_CONTRACT_COMMENT = "contract_comment";
        private static final String COLUMN_OBJECT_TITLE = "object_title";
        private static final String COLUMN_TYPE = "type";
        private static final String COLUMN_GROUP = "group";
        private static final String COLUMN_COMMENT = "comment";

        public TaskTableModel() {
            super("crmTaskAdmin");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0424\u0418\u041e", 120, 150, 250, COLUMN_FIO, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 60, 60, 150, COLUMN_CITY, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u0432\u0430\u0440\u0442\u0430\u043b", 60, 60, 150, COLUMN_QUARTER, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0420\u0430\u0439\u043e\u043d", 60, 60, 150, COLUMN_AREA, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0423\u043b\u0438\u0446\u0430", 100, 150, 250, COLUMN_STREET, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0414\u043e\u043c", 30, 55, 60, COLUMN_HOUSE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
            this.addColumn("\u041f\u043e\u0434\u044a\u0435\u0437\u0434", 30, 55, 60, COLUMN_POD, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
            this.addColumn("\u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430", 30, 55, 60, COLUMN_FLAT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT);
            this.addColumn("\u0422\u0435\u043b\u0435\u0444\u043e\u043d", 100, 150, -1, COLUMN_PHONE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0414\u0430\u0442\u0430", Date.class, 90, 90, 90, COLUMN_OPEN_DATE, true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u041e\u0442\u043a\u0440\u044b\u0442\u0430", 100, 120, 200, COLUMN_OPEN_USER, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0421\u0440\u043e\u043a", Date.class, 120, 120, 120, COLUMN_TARGET_DATE, true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm", 0));
            this.addColumn("\u0421\u0440\u043e\u043a (\u0434\u0430\u0442\u0430)", Date.class, 90, 90, 90, COLUMN_TARGET_DATE, true).setTableCellRenderer((TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 50, 80, 100, COLUMN_STATUS, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER);
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 40, 60, 150, COLUMN_CONTRACT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 (\u0434\u043e\u0433)", 40, 120, -1, COLUMN_CONTRACT_COMMENT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041e\u0431\u044a\u0435\u043a\u0442", 40, 120, -1, COLUMN_OBJECT_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0422\u0438\u043f", 40, 150, 200, COLUMN_TYPE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u0413\u0440\u0443\u043f\u043f\u0430", 40, 120, -1, COLUMN_GROUP, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 40, 120, -1, COLUMN_COMMENT, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
        }

        void setData(Iterable<Element> rowsElement) {
            ArrayList rowsData = new ArrayList();
            for (Element rowElement : rowsElement) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put(COLUMN_ID, Utils.parseInt((String)rowElement.getAttribute(COLUMN_ID)));
                rowMap.put(COLUMN_CONTRACT_ID, Utils.parseInt((String)rowElement.getAttribute(COLUMN_CONTRACT_ID)));
                rowMap.put(COLUMN_FIO, rowElement.getAttribute(COLUMN_FIO));
                rowMap.put(COLUMN_CITY, rowElement.getAttribute(COLUMN_CITY));
                rowMap.put(COLUMN_QUARTER, rowElement.getAttribute(COLUMN_QUARTER));
                rowMap.put(COLUMN_AREA, rowElement.getAttribute(COLUMN_AREA));
                rowMap.put(COLUMN_STREET, rowElement.getAttribute(COLUMN_STREET));
                rowMap.put(COLUMN_HOUSE, rowElement.getAttribute(COLUMN_HOUSE));
                rowMap.put(COLUMN_POD, rowElement.getAttribute(COLUMN_POD));
                rowMap.put(COLUMN_FLAT, rowElement.getAttribute(COLUMN_FLAT));
                rowMap.put(COLUMN_PHONE, rowElement.getAttribute(COLUMN_PHONE));
                rowMap.put(COLUMN_PHONE, rowElement.getAttribute(COLUMN_PHONE));
                rowMap.put(COLUMN_OPEN_DATE, TimeUtils.parseDate((String)rowElement.getAttribute(COLUMN_OPEN_DATE), (String)"dd.MM.yyyy"));
                rowMap.put(COLUMN_OPEN_USER, rowElement.getAttribute(COLUMN_OPEN_USER));
                rowMap.put(COLUMN_TARGET_DATE, TimeUtils.parseDate((String)rowElement.getAttribute(COLUMN_TARGET_DATE), (String)"dd.MM.yyyy HH:mm"));
                rowMap.put(COLUMN_STATUS, rowElement.getAttribute(COLUMN_STATUS));
                rowMap.put(COLUMN_CONTRACT, rowElement.getAttribute(COLUMN_CONTRACT));
                rowMap.put(COLUMN_CONTRACT_COMMENT, rowElement.getAttribute(COLUMN_CONTRACT_COMMENT));
                rowMap.put(COLUMN_OBJECT_TITLE, rowElement.getAttribute(COLUMN_OBJECT_TITLE));
                rowMap.put(COLUMN_TYPE, rowElement.getAttribute(COLUMN_TYPE));
                rowMap.put(COLUMN_GROUP, rowElement.getAttribute(COLUMN_GROUP));
                rowMap.put(COLUMN_COMMENT, rowElement.getAttribute(COLUMN_COMMENT));
                rowsData.add(rowMap);
                String rgbString = rowElement.getAttribute("color");
                if (!Utils.notBlankString((String)rgbString)) continue;
                int rgb = Integer.valueOf(rgbString, 16);
                Color color = new Color(rgb);
                TaskManager.this.colorMap.put((Integer)rowMap.get(COLUMN_ID), color);
            }
            this.setData(rowsData);
        }

        Integer getRowId(Map<String, Object> rowMap) {
            return (Integer)rowMap.get(COLUMN_ID);
        }
    }
}

