/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.server.action.ActionBase;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionRegisterProblemHistoryTable
extends ActionBase {
    public void doAction() throws SQLException {
        int id = this.getIntParameter("id", -1);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        RegisterProblemManager manager = new RegisterProblemManager(this.con);
        List<RegisterProblem> history = manager.getProblemHistory(id);
        Map<Integer, RegisterGroup> groupMap = new RegisterGroupManager(this.con).getGroupMap();
        String statusList = this.plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        for (RegisterProblem ri : history) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(ri.getId()));
            row.setAttribute("comment", ri.getComment());
            RegisterGroup group = groupMap.get(ri.getGroupId());
            if (group != null) {
                row.setAttribute("group", group.getTitle());
            }
            row.setAttribute("status", statusMap.get(ri.getStatus()));
            row.setAttribute("urgency", this.getUrgencyColor(ri.getUrgency()) + ";" + String.valueOf(ri.getUrgency()));
            row.setAttribute("status_user", UserMap.getUser((Integer)ri.getStatusUserId()).getName());
            row.setAttribute("status_time", TimeUtils.format((Date)ri.getStatusTime(), (String)"dd.MM.yy HH:mm"));
            row.setAttribute("change_dt", ri.getValue("changeTime"));
            row.setAttribute("change_uid", UserMap.getUser((Integer)Utils.parseInt((String)ri.getValue("changeUid"))).getName());
        }
    }

    private String getUrgencyColor(int urgency) {
        String[] colors = new String[]{"ffffff", "00ff00", "ffff00", "ffC800", "ff0000"};
        int result = 0;
        if (urgency <= 2 && urgency >= -2) {
            result = Integer.parseInt(colors[urgency + 2], 16);
        }
        return String.valueOf(result);
    }
}

