/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterSubject;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class RegisterSubjectManager {
    private Connection con;

    public RegisterSubjectManager(Connection con) {
        this.con = con;
    }

    public RegisterSubject getRegisterSubjectById(int id) {
        RegisterSubject result = null;
        try {
            String query = "SELECT * FROM register_subject WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new RegisterSubject();
                this.loadFromRS(result, rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public RegisterSubject getRegisterSubjectByID(int id) {
        return this.getRegisterSubjectById(id);
    }

    public void updateRegisterSubject(String id, RegisterSubject value) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (id.equals("new")) {
                query = "INSERT INTO register_subject (title, gid, ac) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE register_subject SET title=?, gid=?, ac=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(4, Utils.parseInt((String)id, (int)-1));
            }
            ps.setString(1, value.getTitle());
            ps.setInt(2, value.getGroupId());
            ps.setInt(3, value.isAutoClose() ? 1 : 0);
            ps.executeUpdate();
            if (id.equals("new")) {
                value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            } else {
                value.setId(Utils.parseInt((String)id, (int)-1));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteRegisterSubject(int id) {
        try {
            String query = "DELETE FROM register_subject WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<RegisterSubject> getRegisterSubjectList() {
        ArrayList<RegisterSubject> result = new ArrayList<RegisterSubject>();
        try {
            String query = "SELECT * FROM register_subject ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            RegisterSubject subject = null;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                subject = new RegisterSubject();
                this.loadFromRS(subject, rs);
                result.add(subject);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void loadFromRS(RegisterSubject subject, ResultSet rs) throws SQLException {
        subject.setId(rs.getInt("id"));
        subject.setGroupId(rs.getInt("gid"));
        subject.setTitle(rs.getString("title"));
        subject.setAutoClose(rs.getInt("ac") == 1);
    }
}

