/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.dba.common.bean.TableInfo;
import ru.bitel.bgbilling.modules.dba.common.service.DBAService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ServiceTables
extends ServiceConfigTabbedPanel {
    private List<TableInfo> data = new ArrayList<TableInfo>();
    private List<IdTitle> components = null;
    private JLabel recordCount = new JLabel();
    private BGTextField monthFilter = new BGTextField(5);
    private TDBTableModel tableModel = new TDBTableModel();
    private BGUComboBox<IdTitle> componentFilter = new BGUComboBox();

    public ServiceTables() {
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getTablePanel() {
        final BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    ServiceTables.this.getPopup().show((Component)table, e.getX(), e.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        ActionListener actionListener = e -> {
            this.monthFilter.setText(e.getActionCommand());
            this.doFilter();
        };
        BGButton button0 = new BGButton("\u0432\u0441\u0435", "0", actionListener);
        BGButton button3 = new BGButton("3", "3", actionListener);
        BGButton button6 = new BGButton("6", "6", actionListener);
        BGButton button12 = new BGButton("12", "12", actionListener);
        BGButton button24 = new BGButton("24", "24", actionListener);
        BGButton button36 = new BGButton("36", "36", actionListener);
        this.monthFilter.setText("0");
        this.monthFilter.setHorizontalAlignment(0);
        this.monthFilter.addActionListener(actionListener);
        GridBagConstraints buttonConstraints = new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0422\u0430\u0431\u043b\u0438\u0446\u044b \u0441\u0442\u0430\u0440\u0448\u0435 (\u043c\u0435\u0441\u044f\u0446\u0435\u0432):"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.monthFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)button0, buttonConstraints);
        panel.add((Component)button3, buttonConstraints);
        panel.add((Component)button6, buttonConstraints);
        panel.add((Component)button12, buttonConstraints);
        panel.add((Component)button24, buttonConstraints);
        panel.add((Component)button36, buttonConstraints);
        panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c (\u043f\u043b\u0430\u0433\u0438\u043d):"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 25, 0, 5), 0, 0));
        panel.add((Component)this.componentFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.recordCount, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPopupMenu getPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("\u0412 \u0430\u0440\u0445\u0438\u0432");
        menuItem.addActionListener(e -> this.setInArchive(true));
        popupMenu.add(menuItem);
        menuItem = new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        menuItem.addActionListener(e -> this.setInArchive(false));
        popupMenu.add(menuItem);
        JMenu menu = new JMenu("\u0410\u0432\u0442\u043e\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        ActionListener auto = e -> {
            int autoValue = Utils.parseInt((String)e.getActionCommand());
            HashSet tableNameMaskSet = new HashSet();
            this.tableModel.getSelectedRows().forEach(a -> tableNameMaskSet.add(a.getTableName().replaceAll("(.*)_\\d+$", "$1")));
            this.data.forEach(a -> {
                if (tableNameMaskSet.contains(a.getTableName().replaceAll("(.*)_\\d+$", "$1"))) {
                    a.setAutoArchive(autoValue);
                }
            });
            this.tableModel.fireTableDataChanged();
            try {
                ((DBAService)this.getContext().getWebService(DBAService.class)).tableAutoarchiveUpdate(tableNameMaskSet, autoValue);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        };
        menuItem = new JMenuItem("\u043d\u0435\u0442");
        menuItem.setActionCommand("0");
        menuItem.addActionListener(auto);
        menu.add(menuItem);
        Arrays.asList("3", "6", "12", "24", "36", "60").forEach(a -> {
            JMenuItem autoMenuItem = new JMenuItem(">" + a + " \u043c\u0435\u0441.");
            autoMenuItem.setActionCommand((String)a);
            autoMenuItem.addActionListener(auto);
            menu.add(autoMenuItem);
        });
        popupMenu.add(menu);
        return popupMenu;
    }

    private void setInArchive(boolean value) {
        List tableNames = this.tableModel.getSelectedRows().stream().map(a -> a.getTableName()).collect(Collectors.toList());
        try {
            ((DBAService)this.getContext().getWebService(DBAService.class)).tableInArchiveUpdate(tableNames, value);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.tableModel.getSelectedRows().forEach(a -> a.setInArchive(value));
        this.tableModel.fireTableDataChanged();
    }

    private void doFilter() {
        ArrayList filterData = new ArrayList();
        DateTimeFormatter dateTimeFormatter = TimeUtils.getDateTimeFormatter((String)"yyyyMMdd");
        LocalDate now = LocalDate.now();
        int month = 12 * now.getYear() + now.getMonthValue();
        int monthDelta = Utils.parseInt((String)this.monthFilter.getText(), (int)0);
        this.data.stream().forEach(a -> {
            String yyyymmdd;
            LocalDate date;
            boolean add = false;
            String tableName = a.getTableName();
            if (tableName.matches(".*_\\d{6}$")) {
                String yyyymm = tableName.replaceAll(".*_(\\d{6})$", "$1");
                LocalDate date2 = LocalDate.parse(yyyymm + "01", dateTimeFormatter);
                if (month - 12 * date2.getYear() - date2.getMonthValue() >= monthDelta) {
                    add = true;
                }
            } else if (tableName.matches(".*_\\d{8}$") && month - 12 * (date = LocalDate.parse(yyyymmdd = tableName.replaceAll(".*_(\\d{8})$", "$1"), dateTimeFormatter)).getYear() - date.getMonthValue() >= monthDelta) {
                add = true;
            }
            IdTitle componentFilterSelect = (IdTitle)this.componentFilter.getSelectedItem();
            if (add && componentFilterSelect != null && componentFilterSelect.getId() > -1) {
                boolean bl = add = a.getComponentId() == componentFilterSelect.getId();
            }
            if (add) {
                filterData.add(a);
            }
        });
        this.tableModel.setData(filterData, false);
        this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)filterData.size()));
    }

    public void setData() {
        try {
            if (this.components == null) {
                this.components = new ArrayList<IdTitle>();
                ((ModuleService)this.getContext().getWebService(ModuleService.class, 0)).moduleList().forEach(a -> this.components.add(new IdTitle(a.getId(), a.getTitle())));
                this.components.add(0, new IdTitle(0, "\u042f\u0434\u0440\u043e"));
                this.components.add(0, new IdTitle(-1, "-------"));
                this.componentFilter.setData(this.components);
                this.componentFilter.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        this.doFilter();
                    }
                });
            }
            this.data = ((DBAService)this.getContext().getWebService(DBAService.class, this.getContext().getModuleId())).tableInfoList();
            this.doFilter();
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class TDBTableModel
    extends BGTableModel<TableInfo> {
        public TDBTableModel() {
            super(TDBTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0430\u0431\u043b\u0438\u0446\u044b", 200, 300, -1, "tableName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c (\u043f\u043b\u0430\u0433\u0438\u043d)", 200, 250, 300, "componentName", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0410\u0432\u0442\u043e\u0430\u0440\u0445\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", 150, 150, 150, "autoArchive", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0412 \u0430\u0440\u0445\u0438\u0432", Boolean.class, 100, 100, 100, "inArchive", true);
        }

        public Object getValue(TableInfo val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("autoArchive".equals(identifier)) {
                return val.getAutoArchive() > 0 ? ">" + val.getAutoArchive() + " \u043c\u0435\u0441." : "\u043d\u0435\u0442";
            }
            return super.getValue((Object)val, column);
        }
    }
}

