/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class SenderTypeDao
extends AbstractIdDao<SenderType> {
    public SenderTypeDao(Connection con) {
        super(con, 0, "dispatch_sender_type");
    }

    private static final List<SenderType> getPredefinedSenderTypes() {
        ArrayList<SenderType> types = new ArrayList<SenderType>();
        types.add(SenderTypeDao.getPredefined(-1));
        types.add(SenderTypeDao.getPredefined(-2));
        types.add(SenderTypeDao.getPredefined(-3));
        types.add(SenderTypeDao.getPredefined(-4));
        types.add(SenderTypeDao.getPredefined(-5));
        return types;
    }

    private static final SenderType getPredefined(int id) {
        SenderType type = null;
        switch (id) {
            case -1: {
                type = new SenderType();
                type.setId(-1);
                type.setTitle("\u041f\u043e e-mail");
                type.setClassName("ru.bitel.bgbilling.plugins.dispatch.server.sender.EmailSender");
                break;
            }
            case -2: {
                type = new SenderType();
                type.setId(-2);
                type.setTitle("\u041f\u043e SMS \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 Enterix.ru");
                type.setClassName("ru.bitel.bgbilling.plugins.dispatch.server.sender.enterix.EnterixSmsSender");
                break;
            }
            case -3: {
                type = new SenderType();
                type.setId(-3);
                type.setTitle("\u041f\u043e SMS \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 Smsc.ru");
                type.setClassName("ru.bitel.bgbilling.plugins.dispatch.server.sender.smsc.SmscSender");
                break;
            }
            case -4: {
                type = new SenderType();
                type.setId(-4);
                type.setTitle("\u041f\u043e SMS \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 SmsAero.ru");
                type.setClassName("ru.bitel.bgbilling.plugins.dispatch.server.sender.smsaero.SmsAeroSender");
                break;
            }
            case -5: {
                type = new SenderType();
                type.setId(-5);
                type.setTitle("\u041f\u043e SMS \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 Sms-Assistent.by");
                type.setClassName("ru.bitel.bgbilling.plugins.dispatch.server.sender.smsassistent.SmsAssistentSender");
                break;
            }
            case -7: {
                type = new SenderType();
                type.setId(-7);
                type.setTitle("\u041f\u043e SMS \u0447\u0435\u0440\u0435\u0437 \u0441\u0435\u0440\u0432\u0438\u0441 SmsAero.ru (V2)");
                type.setClassName("ru.bitel.bgbilling.plugins.dispatch.server.sender.smsaero.SmsAeroV2Sender");
            }
        }
        return type;
    }

    protected SenderType getFromRS(ResultSet rs) throws SQLException, BGException {
        return SenderTypeDao.getSenderTypeFromRS(rs, null);
    }

    public static SenderType getSenderTypeFromRS(ResultSet rs, String tableName) throws SQLException, BGException {
        int id = rs.getInt("dispatch_sender_type.id");
        if (id == 0) {
            return SenderTypeDao.getPredefined(rs.getInt(tableName + ".sender_type_id"));
        }
        String title = rs.getString("dispatch_sender_type.title");
        String className = rs.getString("dispatch_sender_type.class_name");
        SenderType type = new SenderType();
        type.setId(id);
        type.setTitle(title);
        type.setClassName(className);
        return type;
    }

    protected void updateImpl(SenderType b) throws BGException, SQLException {
        PreparedStatement ps = null;
        if (b.getId() == 0) {
            String query = "INSERT INTO " + this.tableName + "(title,class_name) VALUES(?,?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            String query = "UPDATE " + this.tableName + " SET title=?,class_name=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(3, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setString(2, b.getClassName());
        ps.executeUpdate();
        if (b.getId() == 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }

    public List<SenderType> getList() throws BGException {
        List<SenderType> result = SenderTypeDao.getPredefinedSenderTypes();
        result.addAll(this.list("", "title", new Object[0]));
        return result;
    }
}

