/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class TariffAVDManager
extends AbstractIdDao<TariffAVD> {
    public TariffAVDManager(Connection con, int mid) {
        super(con, mid, "drweb_tariffs");
    }

    protected TariffAVD getFromRS(ResultSet rs) throws SQLException {
        TariffAVD result = new TariffAVD();
        result.setId(rs.getInt("id"));
        result.setGroupTitle(rs.getString("group_title"));
        result.setSid(rs.getInt("sid"));
        result.setTitle(rs.getString("title"));
        result.setDateFromView((Date)rs.getDate("date_from_view"));
        result.setDateToView((Date)rs.getDate("date_to_view"));
        result.setDateFromWork((Date)rs.getDate("date_from_work"));
        result.setDateToWork((Date)rs.getDate("date_to_work"));
        result.setNextTariff(rs.getInt("next_tariff"));
        result.setGroupForView(rs.getString("group_for_view"));
        result.setOnlyForNew(rs.getBoolean("only_for_new"));
        result.setSidForNew(rs.getInt("sid_new"));
        return result;
    }

    protected void updateImpl(TariffAVD tariff) throws BGException, SQLException {
        if (tariff.getId() <= 0) {
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " ( group_title,sid,title,date_from_view, date_to_view, date_from_work, date_to_work, next_tariff, group_for_view, only_for_new, sid_new ) VALUES (?,?,?,?,?,?,?,?,?,?,? )", 1);
            int index = 1;
            ps.setString(index++, tariff.getGroupTitle());
            ps.setInt(index++, tariff.getSid());
            ps.setString(index++, tariff.getTitle());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateFromView()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateToView()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateFromWork()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateToWork()));
            ps.setInt(index++, tariff.getNextTariff());
            ps.setString(index++, tariff.getGroupForView());
            ps.setBoolean(index++, tariff.isOnlyForNew());
            ps.setInt(index++, tariff.getSidForNew());
            ps.executeUpdate();
            int id = -1;
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.last()) {
                id = rs.getInt(1);
            }
            tariff.setId(id);
            rs.close();
            ps.close();
        } else {
            PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET group_title=?, sid=?, title=?, date_from_view=?,date_to_view =?, date_from_work=?, date_to_work=?, next_tariff=?, group_for_view=?, only_for_new=?, sid_new=? WHERE id=?");
            int index = 1;
            ps.setString(index++, tariff.getGroupTitle());
            ps.setInt(index++, tariff.getSid());
            ps.setString(index++, tariff.getTitle());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateFromView()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateToView()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateFromWork()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)tariff.getDateToWork()));
            ps.setInt(index++, tariff.getNextTariff());
            ps.setString(index++, tariff.getGroupForView());
            ps.setBoolean(index++, tariff.isOnlyForNew());
            ps.setInt(index++, tariff.getSidForNew());
            ps.setInt(index++, tariff.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    public List<TariffAVD> getListAll() throws BGException {
        List list = super.list(null, null, new Object[0]);
        return list;
    }

    public Map<Integer, TariffAVD> getTariffMap() throws BGException {
        List list = super.list(null, null, new Object[0]);
        HashMap<Integer, TariffAVD> map = new HashMap<Integer, TariffAVD>();
        for (TariffAVD tariff : list) {
            map.put(tariff.getId(), tariff);
        }
        return map;
    }

    public TariffAVD getByGroupTitle(String groupTitle) throws BGException {
        ArrayList<TariffAVD> list = new ArrayList<TariffAVD>();
        list.add((TariffAVD)this.get("group_title=?", new Object[]{groupTitle}));
        return (TariffAVD)list.get(0);
    }
}

