/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.ListItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class NsServersPanel
extends BGPanel
implements ActionListener {
    private List<ListItem> serverList = new ArrayList<ListItem>();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGControlPanelListSelect primaryList = new BGControlPanelListSelect(5);
    private BGControlPanelListSelect secodaryList = new BGControlPanelListSelect(5);

    public NsServersPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tabbedPane.add((Component)this.primaryList, "Primary");
        this.tabbedPane.add((Component)this.secodaryList, "Secondary");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.setLayout(new GridBagLayout());
        this.add(this.tabbedPane, gridBagConstraints);
        this.setMinimumSize(new Dimension(this.getPreferredSize().width, 200));
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
        this.primaryList.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("itemChange".equals(event.getPropertyName())) {
                    NsServersPanel.this.rebuildNsList(NsServersPanel.this.secodaryList, NsServersPanel.this.primaryList);
                }
            }
        });
        this.secodaryList.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("itemChange".equals(event.getPropertyName())) {
                    NsServersPanel.this.rebuildNsList(NsServersPanel.this.primaryList, NsServersPanel.this.secodaryList);
                }
            }
        });
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.tabbedPane.setSelectedIndex(0);
        this.loadServers();
    }

    private void loadServers() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("NsServerList");
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            Element list = XMLUtils.getElement((Document)doc, (String)"list");
            NodeList itemList = list.getElementsByTagName("item");
            int size = itemList.getLength();
            for (int i = 0; i < size; ++i) {
                Element item = (Element)itemList.item(i);
                ListItem listItem = new ListItem();
                listItem.setAttribute("id", (Object)item.getAttribute("id"));
                listItem.setText(item.getAttribute("title"));
                this.serverList.add(listItem);
            }
        }
        this.rebuildNsList(this.primaryList, this.secodaryList);
    }

    private void rebuildNsList(BGControlPanelListSelect list1, BGControlPanelListSelect list2) {
        ArrayList<ListItem> list = new ArrayList<ListItem>(this.serverList);
        DefaultListModel listModel = (DefaultListModel)list2.getList().getModel();
        block0: for (ListItem server : this.serverList) {
            for (int index = 0; index < listModel.getSize(); ++index) {
                ListItem item = (ListItem)listModel.getElementAt(index);
                if (server != item || !item.isSelected()) continue;
                list.remove(item);
                continue block0;
            }
        }
        listModel = (DefaultListModel)list1.getList().getModel();
        listModel.clear();
        for (ListItem server : list) {
            listModel.addElement(server);
        }
    }

    private void stopAdd(boolean save) {
        if (save) {
            // empty if block
        }
    }

    public void setServerCodes(String codes) {
    }

    public String getServerPrimaryCodes() {
        return ClientUtils.getListSelectedItemtoString((JList)this.primaryList.getList());
    }

    public String getServerSecondaryCodes() {
        return ClientUtils.getListSelectedItemtoString((JList)this.secodaryList.getList());
    }

    public void setEnabled(boolean enabled) {
        this.stopAdd(false);
    }
}

