/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.accounting;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.common.SerialUtils;

@XmlRootElement
@EventType(deliveryMode=1, timeToLive=3600000L)
public class InetConnectionCommandEvent
extends QueueEvent {
    private static final long serialVersionUID = SerialUtils.generateSerialVersionUID(InetConnectionCommandEvent.class);
    @XmlAttribute
    private final int accountingRootDeviceId;
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int servId;
    @XmlAttribute
    private final long connectionId;
    @XmlAttribute
    private final String command;
    private final String params;

    protected InetConnectionCommandEvent() {
        this.accountingRootDeviceId = -1;
        this.deviceId = -1;
        this.servId = -1;
        this.connectionId = -1L;
        this.command = null;
        this.params = null;
    }

    public InetConnectionCommandEvent(int moduleId, int userId, int accountingRootDeviceId, int deviceId, int servId, long connectionId, String command) {
        this(moduleId, userId, accountingRootDeviceId, deviceId, servId, connectionId, command, null);
    }

    public InetConnectionCommandEvent(int moduleId, int userId, int accountingRootDeviceId, int deviceId, int contractId, int servId, long connectionId, String command) {
        this(moduleId, userId, accountingRootDeviceId, deviceId, contractId, servId, connectionId, command, null);
    }

    public InetConnectionCommandEvent(int moduleId, int userId, int accountingRootDeviceId, int deviceId, int servId, long connectionId, String command, String params) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.deviceId = deviceId;
        this.servId = servId;
        this.connectionId = connectionId;
        this.command = command;
        this.params = params;
    }

    public InetConnectionCommandEvent(int moduleId, int userId, int accountingRootDeviceId, int deviceId, int contractId, int servId, long connectionId, String command, String params) {
        super(moduleId, contractId, userId);
        this.accountingRootDeviceId = accountingRootDeviceId;
        this.deviceId = deviceId;
        this.servId = servId;
        this.connectionId = connectionId;
        this.command = command;
        this.params = params;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("accountingRootDeviceId", this.accountingRootDeviceId);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getServId() {
        return this.servId;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public String getCommand() {
        return this.command;
    }

    public String getParams() {
        return this.params;
    }
}

