/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;

@EventType(autoAcknowledge=false, timeToLive=432000000L)
@XmlRootElement
public class InetSaDeviceInitEvent
extends PartitionedQueueEvent {
    @XmlAttribute
    private final int deviceId;
    @XmlAttribute
    private final int initDeviceId;

    protected InetSaDeviceInitEvent() {
        this.deviceId = -1;
        this.initDeviceId = -1;
    }

    public InetSaDeviceInitEvent(int moduleId, int userId, int deviceId, int initDeviceId) {
        super(moduleId, CONTRACT_GLOBAL, userId);
        this.deviceId = deviceId;
        this.initDeviceId = initDeviceId;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("deviceId", this.deviceId);
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public int getInitDeviceId() {
        return this.initDeviceId;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; deviceId: ");
        sb.append(this.deviceId);
    }

    protected String getPackageName() {
        return InetSaServModifyEvent.PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.deviceId;
    }
}

