/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionLog;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.AuthResult;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class SessionTrackingWorker
extends AccountingWorkerTask {
    private static final Logger logger = LogManager.getLogger();
    private final Accounting accounting;
    private final Iterable<? extends InetConnectionRuntime> sessions;
    private Iterator<? extends InetConnectionRuntime> iterator;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final long lockTimeout;
    private static final ThreadLocal<Boolean> workerThread = new ThreadLocal();

    public SessionTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, Iterable<? extends InetConnectionRuntime> sessions) {
        super(scheduledExecutorService, name, params);
        logger.info("Add tracking worker: delay=" + this.getDelay() + ", batchSize=" + this.batchSize);
        this.accounting = accounting;
        this.sessions = sessions;
        this.lockTimeout = params.getLong("lockTimeout", 20000L);
    }

    public static boolean isWorkerThread() {
        return workerThread.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() throws BGException {
        logger.trace("Run connection tracker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.sessions.iterator();
        }
        long millis = System.currentTimeMillis();
        Long hour = InetUtils.getHour(millis);
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        int count = 0;
        workerThread.set(Boolean.TRUE);
        try {
            int batchSize = this.batchSize;
            while (count < batchSize && this.iterator.hasNext()) {
                InetConnectionRuntime connectionRuntime = this.iterator.next();
                if (ConnectionLog.isDebugEnabled()) {
                    ConnectionLog.log(connectionRuntime, Level.DEBUG, "SessionTrackingWorker: session " + connectionRuntime.sessionId + "; connection " + (Serializable)(connectionRuntime.connection != null ? Long.valueOf(connectionRuntime.connection.getId()) : " NULL"));
                }
                if (!SessionTrackingWorker.process(this.accounting, connectionSet, connectionRuntime, hour, millis, this.lockTimeout, false)) continue;
                ++count;
            }
        }
        finally {
            workerThread.remove();
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (logger.isDebugEnabled() && count > 0) {
            logger.debug("Tracked " + count + " sessions for " + duration + " ms.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean process(Accounting accounting, ConnectionSet connectionSet, InetConnectionRuntime connectionRuntime, Long hour, long millis, long lockTimeout, boolean forceCheck) throws BGException {
        InetConnection connection;
        block40: {
            long trafficDeltaCalculateAmount;
            if (connectionRuntime.calculateType != 0) {
                return false;
            }
            connection = connectionRuntime.connection;
            if (connection == null) {
                return false;
            }
            if (connectionRuntime.connection != null && ConnectionLog.isDebugEnabled()) {
                ConnectionLog.log(connectionRuntime, Level.DEBUG, "Tracking connection: " + connectionRuntime.connection.getId() + " for session: " + connectionRuntime.sessionId);
            }
            if (connectionRuntime.isServiceSession()) {
                return false;
            }
            if (connection.getConnectionStatus() != 1) {
                return false;
            }
            if (!forceCheck && (trafficDeltaCalculateAmount = connectionRuntime.trafficDeltaCalculateAmount) != 0L) {
                if (ConnectionLog.isTraceEnabled()) {
                    ConnectionLog.log(connectionRuntime, Level.TRACE, "Skip => trafficDeltaCalculateAmount = " + trafficDeltaCalculateAmount + " != 0");
                }
                return false;
            }
            if (accounting.getDisableServIds().contains(connectionRuntime.inetServId)) {
                if (!connectionRuntime.inetServRuntime.tryLock()) {
                    return false;
                }
            } else {
                if (lockTimeout > 0L) {
                    try {
                        if (!connectionRuntime.inetServRuntime.tryLock(lockTimeout, TimeUnit.MILLISECONDS)) {
                            return false;
                        }
                        break block40;
                    }
                    catch (InterruptedException ex) {
                        throw new BGException((Throwable)ex);
                    }
                }
                connectionRuntime.inetServRuntime.lock();
            }
        }
        try {
            int accessCode;
            if (connection.getConnectionStatus() != 1) {
                boolean ex = false;
                return ex;
            }
            connectionRuntime.trySplitSession(accounting, hour, millis);
            if (connectionRuntime.connection == null) {
                logger.info("Session was finished when trying to split.");
                boolean ex = false;
                return ex;
            }
            if (connectionRuntime.sessionDeviceState == 0) {
                switch (connection.getAccessCode()) {
                    case 1: 
                    case 2: 
                    case 46: 
                    case 47: {
                        boolean ex = true;
                        return ex;
                    }
                }
            }
            InetServRuntime parentInetServRuntime = connectionRuntime.inetServRuntime.getParentInetServRuntime(accounting);
            AuthResult authResult = accounting.authorization(Level.DEBUG, parentInetServRuntime, connectionRuntime.inetServRuntime, true, connectionRuntime.connection.getDeviceId(), connectionRuntime.connection.getAgentDeviceId(), connectionRuntime.getRealm(), null, 0, null, 0, 0, false, null, null, false, connectionRuntime.sessionCostDelta, true);
            if (ConnectionLog.isDebugEnabled()) {
                ConnectionLog.log(connectionRuntime, Level.DEBUG, "Result of authorization accessCode = " + authResult.accessCode);
            }
            if ((accessCode = authResult.accessCode) == 0 && connectionRuntime.sessionDeviceState == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Session with deviceState=disable and authResult=0. Check session count.");
                }
                if (!accounting.checkSessionCount(parentInetServRuntime, connectionRuntime.inetServRuntime, connection, connectionRuntime.getRealm(), true)) {
                    accessCode = 3;
                }
            }
            if (accessCode == 0) {
                if (connectionRuntime.processAccessCode(accounting, connectionSet, accessCode)) {
                    boolean bl = true;
                    return bl;
                }
                if (authResult.optionSet == null) {
                    boolean bl = true;
                    return bl;
                }
                if (connectionRuntime.sessionDeviceState == 1) {
                    if (ConnectionLog.isDebugEnabled()) {
                        ConnectionLog.log(connectionRuntime, Level.DEBUG, "Option set full: " + authResult.optionSet);
                    }
                    if (!connectionRuntime.processInetOptions(accounting, authResult.optionSet) && accounting.servCheckOptions && !parentInetServRuntime.getInetServ().getDeviceOptions().equals(authResult.optionSet)) {
                        parentInetServRuntime.processOptionsModified(accounting, millis, authResult.optionSet);
                    }
                }
            } else if (connectionRuntime.processAccessCode(accounting, connectionSet, accessCode)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            connectionRuntime.inetServRuntime.unlock();
        }
        return true;
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

