/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.radius;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.kernel.network.ip.IpAddressSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetAddressType;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpData;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpUtils;
import ru.bitel.bgbilling.modules.inet.server.radius.InetNas;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.radius.IpResourceEntry;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;

public class InetRadiusIpAddressUtils {
    private static final Logger logger = LogManager.getLogger();

    public static boolean setIp(InetServIpData inetServIpData, RadiusPacket request, RadiusPacket response) {
        boolean defaultRealm;
        int addressFromPacket;
        boolean needIPv6;
        InetServTypeRuntime inetServTypeRuntime = inetServIpData.getInetServTypeRuntime();
        if (inetServTypeRuntime.radiusNoAddress) {
            if (logger.isDebugEnabled()) {
                logger.debug("Option 'serv.radius.noAddress' in serv type configuration are presented. Ip doesn't not provided");
            }
            return true;
        }
        String identifier = (String)request.getOption(InetRadiusProcessor.IDENTIFIER);
        InetServType inetServType = inetServIpData.getInetServTypeRuntime().inetServType;
        int agentDeviceId = inetServIpData.getAgentDeviceId();
        String realm = inetServIpData.getIpRealm();
        String username = inetServIpData.getUsername();
        Set<Integer> optionSet = inetServIpData.getOptionSet();
        InetNas inetNas = inetServIpData.getInetNas();
        InetServ inetServ = inetServIpData.getInetServ();
        RadiusListenerWorker<?> req = inetServIpData.getRadiusListenerWorker();
        int connectionType = req.getConnectionType();
        InetConnectionManager connectionManager = inetServIpData.getConnectionManager();
        String callingStationId = request.getStringAttribute(-1, 31, "");
        byte[] macAddress = InetServ.parseMacAddress((String)((String)request.getOption(InetRadiusProcessor.MAC_ADDRESS)));
        if (macAddress == null) {
            macAddress = (byte[])request.getOption(InetRadiusProcessor.MAC_ADDRESS_BYTES);
        }
        boolean needIPv4 = (connectionType & 0x4000) == 0 || (connectionType & 0x2000) != 0;
        boolean bl = needIPv6 = (connectionType & 0x2000) == 0 || (connectionType & 0x4000) != 0;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Connection type: %d; needIPv4: %s; needIPv6: %s", connectionType, needIPv4, needIPv6));
        }
        IpResult result = new IpResult();
        if (req.connectionId > 0L) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("The connection for the request already exists. connectionId: %d", req.connectionId));
                logger.debug("Getting ip (and probably the prefix/delegatedPrefix and the prefixLength) from existing connection");
            }
            boolean addressSet = false;
            IpAddressSet ipAddressSet = req.getIpAddressSet();
            if (ipAddressSet.getAddress() != null) {
                InetServIpUtils.setFramedIPAddress(req, response, ipAddressSet.getResourceId(), ipAddressSet.getAddress());
                addressSet = true;
            }
            if (ipAddressSet.getPrefix() != null) {
                InetServIpUtils.setFramedIPv6Prefix(req, response, ipAddressSet.getPrefixResourceId(), ipAddressSet.getPrefix(), ipAddressSet.getPrefixLength());
                addressSet = true;
                if (ipAddressSet.getDelegatedPrefix() != null) {
                    InetServIpUtils.setDelegatedIPv6Prefix(req, response, ipAddressSet.getDelegatedPrefixResourceId(), ipAddressSet.getDelegatedPrefix(), ipAddressSet.getDelegatedPrefixLength());
                }
            }
            if (addressSet) {
                return true;
            }
        }
        if (inetNas.isAddressFromRequest()) {
            byte[] addressFromRequest;
            if (logger.isDebugEnabled()) {
                logger.debug("Trying to set ip from the request (option 'radius.address.fromRequest' are presented)");
            }
            if ((addressFromRequest = request.getByteAttribute(-1, 8, null)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Attribute Framed_IP_Address is empty. Trying to get ip from the attribute Assigned-IP-Address (Redback. vendor=2352, type=132)");
                }
                addressFromRequest = request.getByteAttribute(2352, 132, null);
            }
            if (addressFromRequest != null) {
                int ipResourceId;
                boolean isNeedCheck = inetNas.isAddressFromRequestCheck();
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("IP is present. Need ip from the request check (option 'radius.address.fromRequest.check'): %s", isNeedCheck));
                }
                int n = ipResourceId = isNeedCheck ? req.getIpAddressSet().getResourceId() : 0;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("IP resource id: %d", ipResourceId));
                }
                InetServIpUtils.setFramedIPAddress(req, response, ipResourceId, addressFromRequest);
                return true;
            }
        }
        if ((addressFromPacket = response.getIntAttribute(-1, 8, Integer.valueOf(0)).intValue()) != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Getting ip from response");
            }
            InetServIpUtils.setFramedIPAddress(req, response, 0, Utils.convertIntToBytes((int)addressFromPacket));
            return true;
        }
        if (inetServIpData.isFromRealmOnly()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Reject-To-Accept mode, radius.disable.mode = 0. Trying to set up ip from 'radius.disable.ipCategories'");
            }
            boolean[] resourceExist = new boolean[1];
            IpResourceReserve reserve = inetNas.reserveIp(agentDeviceId, inetServ.getId(), username, macAddress, callingStationId, identifier, realm, resourceExist, null, IpResourceEntry.AddressType.Default);
            if (reserve != null) {
                InetServIpUtils.setFramedIPAddress(req, response, reserve.getIpResourceId(), reserve.getAddress());
                return true;
            }
            return !resourceExist[0];
        }
        boolean bl2 = defaultRealm = "default".equals(realm) || "disable".equals(realm);
        if (defaultRealm) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("DEFAULT/DISABLE realm: " + defaultRealm, new Object[0]));
            }
            InetRadiusIpAddressUtils.processRootInetServ(connectionManager, inetServTypeRuntime, inetServType, inetServ, result, needIPv4, needIPv6);
        }
        if (inetServIpData.getChildrenServRuntimes() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("DEFAULT/DISABLE realm for children servs: " + defaultRealm, new Object[0]));
            }
            InetRadiusIpAddressUtils.processChildrenInetServs(connectionManager, inetNas, agentDeviceId, inetServ, inetServIpData.getChildrenServRuntimes(), defaultRealm, realm, username, macAddress, callingStationId, identifier, optionSet, result, needIPv4, needIPv6);
        }
        if ((result.ipv4Address == null && needIPv4 || result.ipv6Prefix == null && needIPv6) && !defaultRealm && !result.hasRealmChildren) {
            InetRadiusIpAddressUtils.processRootInetServ(connectionManager, inetServTypeRuntime, inetServType, inetServ, result, needIPv4, needIPv6);
        }
        InetRadiusIpAddressUtils.tryReserveFromPool(agentDeviceId, inetServ, username, macAddress, callingStationId, identifier, inetNas, realm, optionSet, needIPv4, needIPv6, result);
        if (result.ipv4Address != null || result.ipv6Prefix != null) {
            return InetRadiusIpAddressUtils.setAddresses(req, inetServTypeRuntime, inetNas, response, needIPv4, needIPv6, result);
        }
        if (result.canNull && result.routeNets != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Try to set an attribute Framed-Route");
            }
            inetNas.setFramedRoute(response, result.ipv4Address, result.routeNets);
            return result.canNull;
        }
        return result.canNull;
    }

    private static boolean setAddresses(RadiusListenerWorker<?> req, InetServTypeRuntime inetServTypeRuntime, InetNas nas, RadiusPacket response, boolean needIPv4, boolean needIPv6, IpResult result) {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting ip address to response");
        }
        if (result.ipv4Address != null && needIPv4) {
            if (result.routeNets != null) {
                nas.setFramedRoute(response, result.ipv4Address, result.routeNets);
            }
            if (inetServTypeRuntime.radiusStaticSubnet) {
                if (result.ipv4AddressTo == null) {
                    result.ipv4AddressTo = result.ipv4Address;
                }
                int mask = IpNet.getMask((byte[])result.ipv4Address, (byte[])result.ipv4AddressTo);
                int netmask = (int)(0xFFFFFFFFL << 32 - mask & 0xFFFFFFFFL);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Framed_IP_Address: %s", IpAddress.toString((byte[])result.ipv4Address)));
                }
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 8, Utils.convertBytesToInt((byte[])result.ipv4Address)));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Framed_IP_Netmask (int): %d", netmask));
                }
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeIpAddr(-1, 9, netmask));
                if (result.ipv4ResourceId > 0) {
                    req.getIpAddressSet().setResourceId(result.ipv4ResourceId);
                }
            } else {
                InetServIpUtils.setFramedIPAddress(req, response, result.ipv4ResourceId, result.ipv4Address);
            }
        }
        if (result.ipv6Prefix != null && needIPv6) {
            InetServIpUtils.setFramedIPv6Prefix(req, response, result.ipv6PrefixResourceId, result.ipv6Prefix, result.ipv6PrefixLength);
        }
        if (result.ipv6DelegetedPrefix != null && needIPv6) {
            InetServIpUtils.setDelegatedIPv6Prefix(req, response, result.ipv6DelegetedPrefixResourceId, result.ipv6DelegetedPrefix, result.ipv6DelegetedPrefixLength);
        }
        return true;
    }

    private static void tryReserveFromPool(int agentDeviceId, InetServ inetServ, String username, byte[] macAddress, String callingStationId, String identifier, InetNas nas, String realm, Set<Integer> optionSet, boolean needIPv4, boolean needIPv6, IpResult result) {
        IpResourceReserve reserve;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Try to reserve dynamic ip. ", new Object[0]));
        }
        if (result.ipv4Address == null && result.canDynamic && needIPv4) {
            result.canNull = false;
            reserve = nas.reserveIp(agentDeviceId, inetServ.getId(), username, macAddress, callingStationId, identifier, realm, null, optionSet, IpResourceEntry.AddressType.Default);
            if (reserve != null) {
                if (reserve.getAddress().length == 16) {
                    if (needIPv6) {
                        logger.info(String.format("Set IPv6 prefix from pool. prefix: %s, prefix length: %d, resourceId: %d", IpAddress.toString((byte[])reserve.getAddress()), reserve.getPrefixLength(), reserve.getIpResourceId()));
                        result.ipv6Prefix = reserve.getAddress();
                        result.ipv6PrefixResourceId = reserve.getIpResourceId();
                        result.ipv6PrefixLength = reserve.getPrefixLength();
                    }
                } else {
                    logger.info("Set IPv4 from pool");
                    result.ipv4Address = reserve.getAddress();
                    result.ipv4ResourceId = reserve.getIpResourceId();
                }
            }
        }
        if (needIPv6 && result.ipv6Prefix == null && result.canDynamic) {
            result.canNull = false;
            reserve = nas.reserveIp(agentDeviceId, inetServ.getId(), username, macAddress, callingStationId, identifier, realm, null, optionSet, IpResourceEntry.AddressType.IPv6Prefix);
            if (reserve != null && reserve.getAddress().length == 16) {
                logger.info(String.format("Set IPv6 prefix from pool. prefix: %s, prefix length: %d, resourceId: %d", IpAddress.toString((byte[])reserve.getAddress()), reserve.getPrefixLength(), reserve.getIpResourceId()));
                result.ipv6Prefix = reserve.getAddress();
                result.ipv6PrefixResourceId = reserve.getIpResourceId();
                result.ipv6PrefixLength = reserve.getPrefixLength();
            }
        }
        if (needIPv6 && result.ipv6DelegetedPrefix == null && result.canDynamic) {
            result.canNull = false;
            reserve = nas.reserveIp(agentDeviceId, inetServ.getId(), username, macAddress, callingStationId, identifier, realm, null, optionSet, IpResourceEntry.AddressType.IPv6DelegatedPrefix);
            if (reserve != null && reserve.getAddress().length == 16) {
                logger.info(String.format("Set delegated ipv6 prefix from pool. prefix: %s, prefix length: %d, resourceId: %d", IpAddress.toString((byte[])reserve.getAddress()), reserve.getPrefixLength(), reserve.getIpResourceId()));
                result.ipv6DelegetedPrefix = reserve.getAddress();
                result.ipv6DelegetedPrefixResourceId = reserve.getIpResourceId();
                result.ipv6DelegetedPrefixLength = reserve.getPrefixLength();
            }
        }
    }

    private static void processChildrenInetServs(InetConnectionManager connectionManager, InetNas nas, int agentDeviceId, InetServ inetServ, List<InetServRuntime> childrenServRuntimes, boolean defaultRealm, String realm, String username, byte[] macAddress, String callingStationId, String identifier, Set<Integer> optionSet, IpResult result, boolean needIPv4, boolean needIPv6) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Processing children servs", new Object[0]));
        }
        int size = childrenServRuntimes.size();
        block10: for (int i = 0; i < size; ++i) {
            boolean ipv6;
            InetServRuntime childServRuntime = childrenServRuntimes.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("\tChild serv: %d", childServRuntime.getInetServ().getId()));
            }
            InetServTypeRuntime childServTypeRuntime = childServRuntime.inetServTypeRef.get();
            if (childServTypeRuntime.radiusNoAddress) continue;
            InetServ childServ = childServRuntime.getInetServ();
            String login = childServ.getLogin();
            if ((!defaultRealm || !Utils.isBlankString((String)login)) && !realm.equals(login)) continue;
            InetServType childServType = childServTypeRuntime.inetServType;
            InetAddressType addressType = childServType.getAddressType();
            switch (addressType) {
                case DYNAMIC_OR_SINGLE: 
                case DYNAMIC_OR_RANGE: {
                    result.canDynamic = true;
                    break;
                }
            }
            byte[] addressFrom = childServ.getAddressFrom();
            if (addressFrom != null) {
                boolean bl = ipv6 = addressFrom.length == 16;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Ip address length from inet serv: %d", addressFrom.length));
                }
                if (!needIPv6 && ipv6 || !needIPv4 && !ipv6) {
                    continue;
                }
            } else {
                ipv6 = false;
            }
            result.hasRealmChildren = true;
            if (childServTypeRuntime.radiusFramedRoute) {
                byte[] addressTo = childServ.getAddressTo();
                if (addressFrom == null || addressTo == null) continue;
                if (result.routeNets == null) {
                    result.routeNets = new ArrayList<IpNet>(4);
                }
                result.routeNets.add(IpNet.newInstance((byte[])addressFrom, (byte[])addressTo));
                continue;
            }
            if (childServTypeRuntime.radiusDelegetedPrefix) {
                if (!ipv6) continue;
                result.ipv6DelegetedPrefix = addressFrom;
                result.ipv6DelegetedPrefixLength = (short)IpNet.getMask((byte[])addressFrom, (byte[])childServ.getAddressTo());
                result.ipv6DelegetedPrefixResourceId = childServ.getIpResourceId();
                continue;
            }
            if (ipv6 && addressType == InetAddressType.NET && result.ipv6Prefix == null && (childServ.getMacAddressListBytes() == null || childServ.getMacAddressListBytes().length == 0)) {
                result.ipv6Prefix = addressFrom;
                result.ipv6PrefixLength = (short)IpNet.getMask((byte[])addressFrom, (byte[])childServ.getAddressTo());
                result.ipv6PrefixResourceId = childServ.getIpResourceId();
                continue;
            }
            if (ipv6 || result.ipv4Address != null || childServ.getMacAddressListBytes() != null && childServ.getMacAddressListBytes().length != 0) continue;
            switch (addressType) {
                case NONE_OR_SINGLE: {
                    result.ipv4Address = addressFrom;
                    if (result.ipv4Address == null) continue block10;
                    result.ipv4ResourceId = childServ.getIpResourceId();
                    continue block10;
                }
                case SINGLE_IPV4: {
                    result.ipv4Address = addressFrom;
                    if (result.ipv4Address != null) {
                        result.ipv4ResourceId = childServ.getIpResourceId();
                        continue block10;
                    }
                }
                case DYNAMIC_OR_SINGLE: 
                case DYNAMIC_OR_RANGE: 
                case NET: {
                    if (childServTypeRuntime.radiusStaticSubnet) {
                        result.ipv4Address = addressFrom;
                        if (result.ipv4Address != null) {
                            result.ipv4ResourceId = childServ.getIpResourceId();
                            result.ipv4AddressTo = childServ.getAddressTo();
                            continue block10;
                        }
                    }
                }
                case RANGE: {
                    result.canNull = false;
                    if (result.connectionsAddresses == null) {
                        result.connectionsAddresses = InetRadiusIpAddressUtils.getConnectionsAddresses(connectionManager, inetServ.getId());
                    }
                    if (!childServTypeRuntime.radiusSkipStaticAddress) {
                        result.ipv4Address = InetRadiusIpAddressUtils.getAddressFromRange(addressFrom, childServ.getAddressTo(), result.connectionsAddresses);
                    }
                    if (result.ipv4Address != null) {
                        logger.info("Set ip from serv:" + childServ.getId());
                        result.ipv4ResourceId = childServ.getIpResourceId();
                        continue block10;
                    }
                    logger.info("Not found free static IP in serv");
                }
                case DYNAMIC: {
                    if (!result.canDynamic) continue block10;
                    result.canNull = false;
                }
            }
        }
    }

    private static void processRootInetServ(InetConnectionManager connectionManager, InetServTypeRuntime inetServTypeRuntime, InetServType inetServType, InetServ inetServ, IpResult result, boolean needIPv4, boolean needIPv6) {
        boolean ipv6;
        InetAddressType addressType = inetServType.getAddressType();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Processing root serv: %d; addressType from serv type: %d", inetServ.getId(), addressType.getCode()));
        }
        switch (addressType) {
            case DYNAMIC: {
                result.canDynamic = true;
                break;
            }
            case DYNAMIC_OR_SINGLE: 
            case DYNAMIC_OR_RANGE: 
            case SINGLE_IPV4: {
                result.canDynamic = true;
            }
        }
        byte[] addressFrom = inetServ.getAddressFrom();
        if (addressFrom != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Ip address length from inet serv: %d", addressFrom.length));
            }
            boolean bl = ipv6 = addressFrom.length == 16;
            if (!needIPv6 && ipv6) {
                return;
            }
            if (!needIPv4 && !ipv6) {
                return;
            }
        } else {
            ipv6 = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("is ipv6 ? %s", ipv6));
        }
        if (ipv6 && addressType == InetAddressType.NET && result.ipv6Prefix == null) {
            result.ipv6Prefix = addressFrom;
            result.ipv6PrefixLength = (short)IpNet.getMask((byte[])addressFrom, (byte[])inetServ.getAddressTo());
            result.ipv6PrefixResourceId = inetServ.getIpResourceId();
        } else if (!ipv6) {
            switch (addressType) {
                case NONE_OR_SINGLE: {
                    result.ipv4Address = addressFrom;
                    if (result.ipv4Address == null) break;
                    result.ipv4ResourceId = inetServ.getIpResourceId();
                    break;
                }
                case DYNAMIC: {
                    result.canNull = false;
                    result.canDynamic = true;
                    break;
                }
                case SINGLE_IPV4: {
                    result.ipv4Address = addressFrom;
                    if (result.ipv4Address != null) {
                        result.ipv4ResourceId = inetServ.getIpResourceId();
                        break;
                    }
                }
                case DYNAMIC_OR_SINGLE: 
                case DYNAMIC_OR_RANGE: {
                    result.canDynamic = true;
                }
                case NET: {
                    if (inetServTypeRuntime.radiusStaticSubnet) {
                        result.ipv4Address = addressFrom;
                        if (result.ipv4Address != null) {
                            result.ipv4ResourceId = inetServ.getIpResourceId();
                            result.ipv4AddressTo = inetServ.getAddressTo();
                            break;
                        }
                    }
                }
                case RANGE: {
                    result.canNull = false;
                    if (result.connectionsAddresses == null) {
                        result.connectionsAddresses = InetRadiusIpAddressUtils.getConnectionsAddresses(connectionManager, inetServ.getId());
                    }
                    if (!inetServTypeRuntime.radiusSkipStaticAddress) {
                        result.ipv4Address = InetRadiusIpAddressUtils.getAddressFromRange(inetServ.getAddressFrom(), inetServ.getAddressTo(), result.connectionsAddresses);
                    }
                    if (result.ipv4Address != null) {
                        logger.info("Set ip from serv:" + inetServ.getId());
                        result.ipv4ResourceId = inetServ.getIpResourceId();
                        break;
                    }
                    logger.info("Not found free static IP in serv");
                }
            }
        }
    }

    private static Set<IpAddress> getConnectionsAddresses(InetConnectionManager connectionManager, int inetServId) {
        List<InetConnectionRuntime> list = connectionManager.getByServId(inetServId);
        if (list != null && list.size() > 0) {
            HashSet<IpAddress> result = new HashSet<IpAddress>(list.size());
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                byte[] address = list.get((int)i).connection.getInetAddressBytes();
                if (address == null) continue;
                result.add(new IpAddress(address));
            }
            return result;
        }
        return Collections.emptySet();
    }

    private static byte[] getAddressFromRange(byte[] addressFrom, byte[] addressTo, Set<IpAddress> usedAddress) {
        if (addressFrom != null) {
            if (addressTo != null) {
                IpAddress address = new IpAddress(Arrays.copyOf(addressFrom, addressFrom.length));
                while (IpAddress.compare((byte[])address.address, (byte[])addressTo) <= 0) {
                    if (!usedAddress.contains(address)) {
                        return address.address;
                    }
                    IpAddress.increment((byte[])address.address);
                }
            } else {
                IpAddress address = new IpAddress(addressFrom);
                if (!usedAddress.contains(address)) {
                    return address.address;
                }
            }
        }
        return null;
    }

    private static class IpResult {
        int ipv4ResourceId = 0;
        byte[] ipv4Address = null;
        byte[] ipv4AddressTo = null;
        List<IpNet> routeNets = null;
        byte[] ipv6Prefix = null;
        short ipv6PrefixLength = 0;
        int ipv6PrefixResourceId = 0;
        byte[] ipv6DelegetedPrefix = null;
        short ipv6DelegetedPrefixLength = 0;
        int ipv6DelegetedPrefixResourceId = 0;
        Set<IpAddress> connectionsAddresses = null;
        boolean canDynamic = false;
        boolean hasRealmChildren = false;
        boolean canNull = true;

        private IpResult() {
        }
    }

    public static class IpResourceReserveKit {
        IpResourceReserve ipv4Address;
        IpResourceReserve ipv6Prefix;
        IpResourceReserve ipv6DelegatedPrefix;
    }
}

