/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime.device;

import bitel.billing.server.admin.errorlog.AlarmSender;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.naming.NameNotFoundException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.sa.ProtocolHandler;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivator;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorAdapter;
import ru.bitel.bgbilling.apps.inet.access.sa.ServiceActivatorSet;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ContainerContext;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfo;
import ru.bitel.bgbilling.kernel.container.managed.ManagedBeanInfoManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceManager;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServTypeRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.AbstractInetDeviceRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.PacketValueExtractor;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Child;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.common.dm.DeviceManager;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceReserveManager;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

public class InetDeviceRuntime
extends AbstractInetDeviceRuntime
implements Child<InetDeviceRuntime> {
    private static final Logger logger = LogManager.getLogger();
    final Semaphore semaphore = new Semaphore(1);
    public final Integer inetDeviceId;
    public final InetDevice inetDevice;
    public final InetDeviceType inetDeviceType;
    public final ParameterMap config;
    private final ParameterMap selfConfig;
    public final Map<Integer, List<Integer>> flowAgentIfaceMap;
    public ServiceActivatorSet saInstances;
    public ProtocolHandler protocolHandler;
    public DeviceManager deviceManager;
    public ManagedBeanInfo<Object> deviceManagerInfo;
    public final InetDeviceRuntime parent;
    public final Set<Integer> descendantIds;
    public final Set<Integer> ancestorIds;
    volatile Map<String, InetDeviceRuntime> descendantMap;
    volatile Map<Integer, InetDeviceRuntime> descendantSvlanMap;
    public final long connectionSuspendTimeout;
    public final long connectionCloseTimeout;
    public final long connectionAutoCloseTimeout;
    public final long connectionAutoMinDurationMillis;
    public final boolean connectionCloseTimeoutForceClose;
    public final boolean connectionCloseTimeoutCheckFlow;
    public final boolean connectionCloseForceFlush;
    public final long connectionDisableSuspendTimeout;
    public final long connectionDisableCloseTimeout;
    public final long connectionFinishTimeout;
    public final boolean sessionSplitOnDeviceState;
    public final boolean sessionSplitOnTariffOption;
    private final boolean loadSaInstances;
    public static final int MAC_ADDRESS_AUTO_OFF = 0;
    public static final int MAC_ADDRESS_AUTO_SET = 1;
    public static final int MAC_ADDRESS_AUTO_RESET = 2;
    public static final int MAC_ADDRESS_AUTO_ADD = 3;
    public static final int IDENTIFIER_AUTO_OFF = 0;
    public static final int IDENTIFIER_AUTO_SET = 1;
    public static final int IDENTIFIER_AUTO_RESET = 2;
    public static final int IDENTIFIER_AUTO_ADD = 3;
    private final int setMacAddress;
    private final int setIdentifier;
    private final int servDeviceLink;
    private final Map<String, LinkedHashSet<Integer>> ipPoolCategoryIds = new HashMap<String, LinkedHashSet<Integer>>();
    private final Map<String, IpResourceReserveManager> ipPoolMap = new HashMap<String, IpResourceReserveManager>();
    public final boolean saServiceAccountingEvent;
    private volatile Integer svlan = null;
    private volatile InetDeviceRuntime agentDeviceRoot;

    InetDeviceRuntime(Setup setup, int moduleId, InetDevice inetDevice, InetDeviceType inetDeviceType, InetDeviceRuntime parent, InetDeviceMap.InetDeviceMapItem device, ManagedBeanInfoManager<Object> beanInfoManager, Map<Integer, List<Integer>> flowAgentIfaceMap, boolean loadScript, IpResourceRuntimeManager ipResourceManager, InetApplication application) throws BGException {
        super(device.getConfig());
        this.inetDeviceId = inetDevice.getId();
        this.inetDevice = inetDevice;
        this.inetDeviceType = inetDeviceType;
        this.loadSaInstances = loadScript;
        this.parent = parent;
        this.descendantIds = device.getDescendantIds();
        this.ancestorIds = device.getAncestorIds();
        this.config = device.getConfig();
        this.selfConfig = device.getSelfConfig();
        this.connectionSuspendTimeout = this.config.getLong("connection.suspend.timeout", this.config.getLong("session.suspend.timeout", TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES)));
        this.connectionCloseTimeout = this.config.getLong("connection.close.timeout", this.config.getLong("session.close.timeout", TimeUnit.SECONDS.convert(5L, TimeUnit.MINUTES)));
        this.connectionAutoCloseTimeout = this.config.getLong("connection.close.timeout", this.connectionCloseTimeout);
        this.connectionAutoMinDurationMillis = TimeUnit.MILLISECONDS.convert(this.config.getLong("connection.auto.minDuration", TimeUnit.SECONDS.convert(60L, TimeUnit.MINUTES)), TimeUnit.SECONDS);
        this.connectionCloseTimeoutForceClose = this.config.getInt("connection.close.timeout.forceClose", this.config.getInt("connection.close.timeout.check", 0)) > 0;
        this.connectionCloseTimeoutCheckFlow = this.config.getInt("connection.close.timeout.checkFlow", 0) > 0;
        this.connectionFinishTimeout = this.config.getLong("connection.finish.timeout", this.config.getLong("session.finish.timeout", TimeUnit.SECONDS.convert(5L, TimeUnit.SECONDS)));
        this.connectionCloseForceFlush = this.config.getInt("connection.close.forceFlush", 0) > 0;
        this.connectionDisableSuspendTimeout = this.config.getLong("connection.disable.suspend.timeout", this.connectionSuspendTimeout);
        this.connectionDisableCloseTimeout = this.config.getLong("connection.disable.close.timeout", this.connectionCloseTimeout);
        this.sessionSplitOnDeviceState = this.config.getLong("session.split.onDeviceState", 0L) > 0L;
        this.sessionSplitOnTariffOption = this.config.getLong("session.split.onTariffOption", 1L) > 0L;
        this.flowAgentIfaceMap = flowAgentIfaceMap;
        this.setIdentifier = this.config.getInt("serv.identifier.auto", 0);
        this.setMacAddress = this.config.getInt("serv.macAddress.auto", 0);
        this.servDeviceLink = this.config.getInt("serv.device.link", 0);
        this.saServiceAccountingEvent = this.config.getInt("sa.connection.service.accountingEvent", 0) > 0;
        this.reloadScripts(setup, moduleId, inetDevice, inetDeviceType, beanInfoManager, application);
        for (Map.Entry e : this.config.subKeyed("resource.ip.pool.").entrySet()) {
            String name = (String)e.getKey();
            ParameterMap params = (ParameterMap)e.getValue();
            LinkedHashSet ipCategoryIds = new LinkedHashSet(Utils.toIntegerList((String)params.get("ipCategories", null)));
            int alarmFreePercent = params.getInt("alarm.freePercent", 10);
            int alarmFreeCount = params.getInt("alarm.freeCount", 300);
            boolean categoryRoundRobin = params.getInt("categoryRoundRobin", 0) > 0;
            boolean categoryRoundRobinLeastConn = params.getInt("categoryRoundRobinLeastConn", 0) > 0;
            this.ipPoolCategoryIds.put(name, ipCategoryIds);
            if (ipResourceManager == null) continue;
            IpResourceReserveManager.IpResourceReserveManagerConfig config = new IpResourceReserveManager.IpResourceReserveManagerConfig();
            config.categoryRoundRobin = categoryRoundRobin;
            config.alarmFreePercent = alarmFreePercent;
            config.alarmFreeCount = alarmFreeCount;
            config.categoryRoundRobinLeastConn = categoryRoundRobinLeastConn;
            IpResourceReserveManager reserveManager = ipResourceManager.getReserveManager(ipCategoryIds, name, config);
            this.ipPoolMap.put(name, reserveManager);
        }
    }

    public LinkedHashSet<Integer> getIpPoolCategoryIds(String name) {
        return this.ipPoolCategoryIds.get(name);
    }

    public IpResourceReserveManager getIpPool(String name) {
        return this.ipPoolMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadScripts(Setup setup, int moduleId, InetDevice inetDevice, InetDeviceType inetDeviceType, ManagedBeanInfoManager<Object> beanInfoManager, InetApplication application) {
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        ArrayList<ServiceActivatorSet.ServiceActivatorHolder> saInstanceList = new ArrayList<ServiceActivatorSet.ServiceActivatorHolder>();
        ServerContext ctx = new ServerContext(setup, moduleId, 0);
        ctx.init();
        try {
            ProtocolHandler protocolHandler;
            ResourceManager resourceManager;
            block23: {
                resourceManager = new ResourceManager();
                resourceManager.register(InetApplication.class, null, (Object)application);
                resourceManager.register(InetDeviceRuntimeMap.class, null, (Object)application.deviceMap);
                resourceManager.register(InetDeviceRuntime.class, null, (Object)this);
                resourceManager.register(PacketValueExtractor.class, null, (Object)this.getPacketValueExtractor());
                if (application instanceof Access) {
                    resourceManager.register(Access.class, null, (Object)application);
                }
                if (application instanceof Accounting) {
                    resourceManager.register(Accounting.class, null, (Object)application);
                }
                logger.info("Reload protocolHandler class for device: " + inetDevice);
                protocolHandler = null;
                if (inetDeviceType != null) {
                    try {
                        String protocolHandlerClass = inetDeviceType.getProtocolHandlerClass();
                        if (!Utils.notBlankString((String)protocolHandlerClass) || protocolHandlerClass.trim().equals("---")) break block23;
                        protocolHandler = (ProtocolHandler)dynamicClassManager.newInstance(ProtocolHandler.class, protocolHandlerClass);
                        try {
                            resourceManager.inject((ContainerContext)ctx, (Object)protocolHandler, moduleId);
                        }
                        catch (NameNotFoundException nameNotFoundException) {
                            // empty catch block
                        }
                        protocolHandler.init(setup, moduleId, inetDevice, inetDeviceType, this.config);
                    }
                    catch (Throwable ex) {
                        protocolHandler = null;
                        logger.error(ex.getMessage(), ex);
                        AlarmSender.sendAlarm((String)"inet.device.load.protocolHandler", (long)5000L, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430", (String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0440\u0430 \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430 \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ID=" + inetDevice.getId()), (Throwable)ex);
                    }
                }
            }
            this.protocolHandler = protocolHandler;
            if (this.loadSaInstances) {
                Object deviceManager = null;
                if (inetDeviceType != null) {
                    try {
                        String deviceManagerClass = inetDeviceType.getDeviceManagerClass();
                        if (Utils.notBlankString((String)deviceManagerClass) && !deviceManagerClass.trim().equals("---")) {
                            deviceManager = (DeviceManager)dynamicClassManager.newInstance(DeviceManager.class, deviceManagerClass);
                            resourceManager.inject((ContainerContext)ctx, (Object)deviceManagerClass, moduleId);
                            deviceManager.init(setup, moduleId, (Device)inetDevice, (DeviceType)inetDeviceType, this.config);
                        }
                    }
                    catch (Throwable ex) {
                        deviceManager = null;
                        logger.error(ex.getMessage(), ex);
                    }
                }
                this.deviceManager = deviceManager;
                logger.info("Reload SA classes for device: " + inetDevice);
                if (this.deviceManager != null) {
                    this.deviceManagerInfo = beanInfoManager.getManagedBeanInfo(deviceManager.getClass());
                }
                GregorianCalendar utilCalendar = new GregorianCalendar();
                InetDeviceRuntime deviceRuntime = this;
                while (deviceRuntime != null) {
                    try {
                        String saHandlerClass = deviceRuntime.inetDeviceType.getSaHandlerClass();
                        if (Utils.notBlankString((String)saHandlerClass) && !saHandlerClass.trim().equals("---")) {
                            ServiceActivator saInstance = (ServiceActivator)dynamicClassManager.newInstance(ServiceActivator.class, saHandlerClass);
                            resourceManager.inject((ContainerContext)ctx, (Object)saInstance, moduleId);
                            saInstance.init(setup, moduleId, deviceRuntime.inetDevice, deviceRuntime.inetDeviceType, deviceRuntime.config);
                            saInstanceList.add(new ServiceActivatorSet.ServiceActivatorHolder(deviceRuntime.inetDeviceId, saInstance, InetUtils.dateFrom(deviceRuntime.inetDevice.getDateFrom(), utilCalendar), InetUtils.dateTo(deviceRuntime.inetDevice.getDateTo(), utilCalendar), !deviceRuntime.inetDevice.isOrderManagerDisabled()));
                        }
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                        AlarmSender.sendAlarm((String)"inet.device.load.serviceActivator", (long)5000L, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432", (String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u043e\u0432 \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 ID=" + inetDevice.getId()), (Throwable)t);
                    }
                    deviceRuntime = deviceRuntime.parent;
                }
            }
            ctx.commit();
        }
        catch (Throwable ex) {
            saInstanceList.clear();
            saInstanceList.add(new ServiceActivatorSet.ServiceActivatorHolder(0, new ServiceActivatorAdapter(){

                @Override
                public Object connect() {
                    return false;
                }
            }, 0L, 0L, true));
            logger.error(ex.getMessage(), ex);
        }
        finally {
            ctx.destroy();
        }
        if (this.config.getInt("sa.reverse", 0) == 0) {
            Collections.reverse(saInstanceList);
        }
        this.saInstances = new ServiceActivatorSet(saInstanceList.toArray(new ServiceActivatorSet.ServiceActivatorHolder[saInstanceList.size()]));
    }

    public InetDeviceRuntime getParent() {
        return this.parent;
    }

    public void saInstancesDestroy() {
        this.saInstances.destroy();
        this.saInstances = null;
    }

    public InetDeviceRuntime getParent(Set<Integer> accountingRootDeviceIds) {
        if (accountingRootDeviceIds.contains(this.inetDeviceId)) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getParent(accountingRootDeviceIds);
        }
        return null;
    }

    public int getSetMacAddress(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.setMacAddress != null) {
            return inetServTypeRuntime.setMacAddress;
        }
        return this.setMacAddress;
    }

    public int getSetIdentifier(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.setIdentifier != null) {
            return inetServTypeRuntime.setIdentifier;
        }
        return this.setIdentifier;
    }

    public int getServDeviceLink(InetServTypeRuntime inetServTypeRuntime) {
        if (inetServTypeRuntime.servDeviceLink != null) {
            return inetServTypeRuntime.servDeviceLink;
        }
        return this.servDeviceLink;
    }

    public InetDeviceRuntime getAgentDeviceRoot(InetDeviceRuntimeMap deviceRuntimeMap) {
        InetDeviceRuntime agentDeviceRoot = this.agentDeviceRoot;
        if (agentDeviceRoot != null) {
            return agentDeviceRoot;
        }
        int deviceId = this.config.getInt("device.agentDeviceRootId", 0);
        if (deviceId > 0) {
            agentDeviceRoot = deviceRuntimeMap.get(deviceId);
            if (agentDeviceRoot == null) {
                agentDeviceRoot = this;
            }
        } else {
            agentDeviceRoot = this;
        }
        this.agentDeviceRoot = agentDeviceRoot;
        return agentDeviceRoot;
    }

    public int getSvlan() {
        if (this.svlan != null) {
            return this.svlan;
        }
        InetDeviceRuntime device = this;
        while (device != null && device.inetDevice != null) {
            int svlan = device.inetDevice.getSvlan();
            if (svlan >= 0) {
                this.svlan = svlan;
                return svlan;
            }
            device = device.parent;
        }
        this.svlan = -1;
        return -1;
    }

    public ParameterMap getConfig() {
        return this.config;
    }

    public ParameterMap getSelfConfig() {
        return this.selfConfig;
    }
}

