/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.netflow.ipn.detail.FlowDetailMaker;
import bitel.billing.server.netflow.ipn.detail.RowSelector;
import bitel.billing.server.netflow.ipn.detail.TrafficAnalizeReport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public class BasicFlowDetailMaker
extends FlowDetailMaker {
    private static final Logger logger = LogManager.getLogger();

    @Override
    protected void sendDetailImpl(DefaultServerSetup setup, Connection con, DetailCreateTask task, RowSelector selector, Iterable<IPHourlyDataLog> logs, StringBuilder messageBody, String subject) throws Exception {
        TrafficAnalizeReport trafficReport = new TrafficAnalizeReport();
        Iterator<IPHourlyDataLog> logsIterator = logs.iterator();
        int partNumber = 0;
        while (this.sendDetailPart(trafficReport, setup, con, task, selector, logsIterator, messageBody, subject, ++partNumber)) {
        }
    }

    protected boolean sendDetailPart(TrafficAnalizeReport trafficReport, DefaultServerSetup setup, Connection con, DetailCreateTask task, RowSelector selector, Iterator<IPHourlyDataLog> logs, StringBuilder messageBody, String subject, int partNumber) throws Exception {
        boolean hasNextPart = false;
        int compressionLevel = setup.getInt("ipn.collector.detail.compression.level", -1);
        int maxAttachSize = setup.getInt("ipn.collector.detail.max.attach.size", 4000000);
        final ByteArrayOutputStream bos = new ByteArrayOutputStream(1000000);
        ZipOutputStream zos = new ZipOutputStream(bos);
        zos.setLevel(compressionLevel);
        zos.putNextEntry(new ZipEntry("detail.csv"));
        PrintStream csvReport = new PrintStream((OutputStream)zos, false, "UTF-8");
        csvReport.append("\u0412\u0440\u0435\u043c\u044f;\u0421 \u0430\u0434\u0440\u0435\u0441\u0430;\u0421 \u043f\u043e\u0440\u0442\u0430;\u041d\u0430 \u0430\u0434\u0440\u0435\u0441;\u041d\u0430 \u043f\u043e\u0440\u0442;\u0411\u0430\u0439\u0442;\u0421 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430;\u041d\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        while (logs.hasNext()) {
            FlowReader reader;
            IPHourlyDataLog dataLog = logs.next();
            long hour = dataLog.getHourInMillis();
            while ((reader = (FlowReader)dataLog.nextReader(null, false)) != null) {
                FlowArray f;
                while ((f = reader.readChunk()) != null) {
                    int size = f.size;
                    for (int i = 0; i < size; ++i) {
                        Data flow = f.array[i];
                        FlowSelector.Result result = selector.test(hour, flow);
                        if (!result.isClientRecord) continue;
                        this.printToCsv(csvReport, flow, dateFormat);
                        if (result.direction == 1) {
                            trafficReport.addFromHost(flow.getSrcAddress(), flow.getOctets());
                            continue;
                        }
                        trafficReport.addToHost(flow.getDstAddress(), flow.getOctets());
                    }
                }
            }
            csvReport.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)bos.size());
            }
            if (!logs.hasNext() || bos.size() <= maxAttachSize) continue;
            hasNextPart = true;
            break;
        }
        csvReport.flush();
        zos.closeEntry();
        zos.flush();
        zos.close();
        csvReport = null;
        if (!hasNextPart) {
            trafficReport.addAnalize(messageBody);
        }
        String fileName = "detail.zip";
        MimeMultipart m = new MimeMultipart();
        MimeBodyPart attach = new MimeBodyPart();
        m.addBodyPart((BodyPart)attach);
        DataSource ds = new DataSource(){

            public String getContentType() {
                return "application/zip";
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(bos.toByteArray());
            }

            public String getName() {
                return "detail.zip";
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }
        };
        attach.setDataHandler(new DataHandler(ds));
        attach.setFileName("detail.zip");
        String fullSubject = null;
        fullSubject = hasNextPart ? subject + " [" + partNumber + "]" : subject + " [LAST]";
        this.sendDetailMail(setup, task, fullSubject, messageBody, attach);
        return hasNextPart;
    }
}

